/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.flex;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import mpi.eudico.client.annotator.linkedmedia.MediaDescriptorUtil;
import mpi.eudico.client.annotator.util.FileUtility;
import mpi.eudico.server.corpora.clom.DecoderInfo;
import mpi.eudico.server.corpora.clom.Property;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.Parser;
import mpi.eudico.server.corpora.clomimpl.abstr.PropertyImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.AnnotationRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.LanguageRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.LingTypeRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.TierRecord;
import mpi.eudico.server.corpora.clomimpl.flex.ContainerElem;
import mpi.eudico.server.corpora.clomimpl.flex.FlexDecoderInfo;
import mpi.eudico.server.corpora.clomimpl.flex.Item;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class FlexParser
extends Parser {
    private XMLReader reader;
    private ContainerElem topElement;
    private FlexDecoderInfo decoder;
    private final HashMap<String, TierRecord> tierMap = new HashMap();
    private HashMap<String, LingTypeRecord> lingTypeRecords = new HashMap();
    private HashMap<String, String> langMap = new HashMap();
    private final List<LanguageRecord> languages = new ArrayList<LanguageRecord>();
    private ArrayList<Property> properties;
    private HashMap<String, Character> participantMap = new HashMap();
    private TreeSet<String> tierNameSet = new TreeSet();
    private ArrayList<long[]> timeOrder = new ArrayList();
    private ArrayList<long[]> timeSlots = new ArrayList();
    private ArrayList<AnnotationRecord> annotationRecords = new ArrayList();
    private HashMap<String, ArrayList<AnnotationRecord>> tierNameToAnnRecordMap = new HashMap();
    private HashMap<AnnotationRecord, String> annotRecordToTierMap = new HashMap();
    private HashMap<String, String> parentPerLevel = new HashMap(8);
    private HashMap<String, LinkedHashSet<String>> tiersPerLevel = new HashMap(8);
    private HashMap<String, ExternalReferenceImpl> externalRefMap;
    private ArrayList<MediaDescriptor> mediaDescriptors;
    private List<String> unitLevels;
    private HashMap<String, String> guidIdMap = new HashMap();
    private static final String EXT_REF_ID = "er1";
    private int annotId = 1;
    private int tsId = 1;
    private static final String ANN_ID_PREFIX = "ann";
    private static final String TS_ID_PREFIX = "ts";
    private final String DEL = "-";
    private final String PARTICIPANT_DEL = "_";
    private final String UNKNOWN = "Not Specified";
    private boolean parsed = false;
    private String txtLanguage;

    public FlexParser() {
        this.unitLevels = new ArrayList<String>(5);
        this.unitLevels.add("morph");
        this.unitLevels.add("word");
        this.unitLevels.add("phrase");
        this.unitLevels.add("paragraph");
        this.unitLevels.add("interlinear-text");
        this.mediaDescriptors = new ArrayList();
        try {
            this.reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            this.reader.setFeature("http://xml.org/sax/features/namespaces", true);
            this.reader.setFeature("http://xml.org/sax/features/validation", true);
            this.reader.setContentHandler(new FlexContentHandler());
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
    }

    @Override
    public void setDecoderInfo(DecoderInfo decoderInfo) {
        if (decoderInfo instanceof FlexDecoderInfo) {
            this.decoder = (FlexDecoderInfo)decoderInfo;
        }
    }

    @Override
    public Map<String, ExternalReferenceImpl> getExternalReferences(String fileName) {
        return this.externalRefMap;
    }

    @Override
    public Locale getDefaultLanguageOf(String tierName, String fileName) {
        return null;
    }

    public ArrayList<MediaDescriptor> getMediaDescriptors(String fileName) {
        this.parse(fileName);
        List<MediaDescriptor> list = this.decoder.getMediaDescriptors();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                if (this.mediaDescriptors.contains(list.get(i))) continue;
                this.mediaDescriptors.add(list.get(i));
            }
        }
        return this.mediaDescriptors;
    }

    public ArrayList<LingTypeRecord> getLinguisticTypes(String fileName) {
        this.parse(fileName);
        return new ArrayList<LingTypeRecord>(this.lingTypeRecords.values());
    }

    public ArrayList<String> getTimeOrder(String fileName) {
        this.parse(fileName);
        ArrayList<String> resultTimeOrder = new ArrayList<String>();
        for (int i = 0; i < this.timeOrder.size(); ++i) {
            resultTimeOrder.add(TS_ID_PREFIX + this.timeOrder.get(i)[0]);
        }
        return resultTimeOrder;
    }

    public HashMap<String, String> getTimeSlots(String fileName) {
        this.parse(fileName);
        HashMap<String, String> resultSlots = new HashMap<String, String>();
        for (long[] timeSlot : this.timeSlots) {
            String tsId = TS_ID_PREFIX + timeSlot[0];
            String timeValue = Long.toString(timeSlot[1]);
            resultSlots.put(tsId, timeValue);
        }
        return resultSlots;
    }

    public ArrayList<String> getTierNames(String fileName) {
        this.parse(fileName);
        return new ArrayList<String>(this.tierNameSet);
    }

    @Override
    public String getParticipantOf(String tierName, String fileName) {
        this.parse(fileName);
        TierRecord tr = this.tierMap.get(tierName);
        if (tr != null) {
            return tr.getParticipant();
        }
        return null;
    }

    @Override
    public String getLinguisticTypeIDOf(String tierName, String fileName) {
        this.parse(fileName);
        TierRecord tr = this.tierMap.get(tierName);
        if (tr != null) {
            return tr.getLinguisticType();
        }
        return null;
    }

    @Override
    public String getParentNameOf(String tierName, String fileName) {
        this.parse(fileName);
        TierRecord tr = this.tierMap.get(tierName);
        if (tr != null) {
            return tr.getParentTier();
        }
        return null;
    }

    public ArrayList<AnnotationRecord> getAnnotationsOf(String tierName, String fileName) {
        this.parse(fileName);
        ArrayList<AnnotationRecord> records = this.tierNameToAnnRecordMap.get(tierName);
        if (records == null) {
            records = new ArrayList(0);
        }
        return records;
    }

    public ArrayList<Property> getTranscriptionProperties(String fileName) {
        this.parse(fileName);
        if (this.properties == null) {
            PropertyImpl prop;
            this.properties = new ArrayList();
            Object langPropValue = null;
            for (Map.Entry<String, String> entry : this.langMap.entrySet()) {
                prop = new PropertyImpl(entry.getKey(), entry.getValue());
                this.properties.add(prop);
                if (langPropValue == null) {
                    langPropValue = entry.getKey();
                    continue;
                }
                langPropValue = (String)langPropValue + " " + entry.getKey();
            }
            if (langPropValue != null) {
                prop = new PropertyImpl("languages", langPropValue);
                this.properties.add(prop);
            }
        }
        return this.properties;
    }

    @Override
    public List<LanguageRecord> getLanguages(String fileName) {
        this.parse(fileName);
        return this.languages;
    }

    @Override
    public String getLangRefOf(String tierName, String fileName) {
        this.parse(fileName);
        TierRecord tr = this.tierMap.get(tierName);
        if (tr != null) {
            return tr.getLangRef();
        }
        return null;
    }

    private void parse(String fileName) {
        if (this.parsed) {
            return;
        }
        if (this.decoder == null) {
            this.setDecoderInfo(new FlexDecoderInfo());
        }
        this.topElement = null;
        try {
            if (this.decoder.importParticipantInfo) {
                try {
                    URL originalFileURL = new URL(FileUtility.pathToURLString(fileName));
                    URL flextTextURL = FlexParser.class.getResource("/mpi/eudico/resources/flexTransformation.xsl");
                    if (flextTextURL != null) {
                        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                        TransformerFactory.newInstance().newTransformer(new StreamSource(flextTextURL.openStream())).transform(new StreamSource(originalFileURL.openStream()), new StreamResult(outputStream));
                        this.reader.parse(new InputSource(new ByteArrayInputStream(outputStream.toByteArray())));
                        this.parsed = true;
                    } else {
                        System.out.println("Unknown Error in the transformation file: /mpi/eudico/resources/flexTransformation.xsl");
                        this.parsed = false;
                    }
                }
                catch (MalformedURLException mue) {
                    System.out.println("URL error" + mue.getMessage());
                    this.parsed = false;
                }
                catch (TransformerException te) {
                    System.out.println("Transformation error" + te.getMessage());
                    this.parsed = false;
                }
                catch (TransformerFactoryConfigurationError e) {
                    System.out.println("Transformer Factory Configuration error" + e.getMessage());
                    this.parsed = false;
                }
            }
            if (!this.parsed) {
                this.reader.parse(fileName);
            }
            this.parsed = true;
            this.checkParentPerLevel();
            this.preprocessRecords(this.topElement);
            this.calculateDurations();
            this.createRecords();
        }
        catch (SAXException e) {
            System.out.println("Parsing error: " + e.getMessage());
        }
        catch (IOException ioe) {
            System.out.println("IO error: " + ioe.getMessage());
        }
    }

    private void createExternalRefForPunct() {
        if (this.externalRefMap == null) {
            this.externalRefMap = new HashMap();
            this.externalRefMap.put(EXT_REF_ID, new ExternalReferenceImpl("http://www.isocat.org/rest/dc/1372", 2));
        }
    }

    private void checkParentPerLevel() {
        Iterator<String> it;
        for (String key : this.tiersPerLevel.keySet()) {
            String first = null;
            String txtstart = key + "-txt";
            LinkedHashSet<String> values = this.tiersPerLevel.get(key);
            boolean found = false;
            int count = 0;
            Iterator valIt = values.iterator();
            while (valIt.hasNext()) {
                String combi = ((String)valIt.next()).substring(2);
                if (count == 0) {
                    first = combi;
                    ++count;
                }
                if (!combi.startsWith(txtstart)) continue;
                this.txtLanguage = combi.split("-")[2];
                this.parentPerLevel.put(key, combi);
                found = true;
                break;
            }
            if (found) continue;
            this.parentPerLevel.put(key, first);
        }
        if (this.txtLanguage == null && (it = this.langMap.keySet().iterator()).hasNext()) {
            this.txtLanguage = it.next();
        }
    }

    private void preprocessRecords(ContainerElem elem) {
        if (elem == null) {
            return;
        }
        boolean parentFound = false;
        if (elem.getItems() != null && elem.getItems().size() != 0) {
            for (int i = 0; i < elem.getItems().size(); ++i) {
                Item item = elem.getItems().get(i);
                if (item.tierName == null || !item.tierName.contains(this.parentPerLevel.get(elem.flexType))) continue;
                parentFound = true;
                if (i == 0) break;
                elem.getItems().add(0, elem.getItems().remove(i));
                break;
            }
            if (!parentFound) {
                elem.getItems().add(0, this.getAnItemFor(elem));
            }
        } else {
            elem.addItem(this.getAnItemFor(elem));
        }
        if (elem.getChildElems() != null && elem.getChildElems().size() > 0) {
            for (ContainerElem celem : elem.getChildElems()) {
                this.preprocessRecords(celem);
            }
        }
    }

    private Item getAnItemFor(ContainerElem elem) {
        char speaker;
        Object ppl = this.parentPerLevel.get(elem.flexType);
        if (ppl == null) {
            ppl = elem.flexType + "-txt-" + this.txtLanguage;
            this.parentPerLevel.put(elem.flexType, (String)ppl);
        }
        Item empty = new Item();
        String typeLang = ((String)ppl).substring(((String)ppl).indexOf(elem.flexType) + 1);
        empty.type = typeLang.substring(0, typeLang.indexOf("-"));
        empty.lang = typeLang.substring(typeLang.lastIndexOf("-") + 1);
        empty.tierName = !"interlinear-text".equals(elem.flexType) && !"paragraph".equals(elem.flexType) ? ((speaker = this.getParticipantForSpeaker(elem.speaker)) >= 'A' ? speaker + "_" + (String)ppl : ppl) : ppl;
        return empty;
    }

    private void createRecords() {
        block22: {
            ContainerElem elem;
            List<ContainerElem> childElems;
            if (this.topElement == null) {
                return;
            }
            AnnotationRecord par = null;
            Object topLevelTierName = null;
            if (this.decoder.inclITElement) {
                par = null;
                if (this.topElement.getItems() != null && this.topElement.getItems().size() > 0) {
                    for (int i = 0; i < this.topElement.getItems().size(); ++i) {
                        Item item = this.topElement.getItems().get(i);
                        String tName = item.tierName;
                        this.tierNameSet.add(tName);
                        TierRecord tr = new TierRecord();
                        tr.setName(tName);
                        tr.setDefaultLocale(item.lang);
                        tr.setLangRef(item.lang);
                        this.tierMap.put(tName, tr);
                        if (i == 0) {
                            tr.setLinguisticType(this.getLingType("interlinear-text", item));
                            topLevelTierName = tName;
                            par = this.createAnnotationRecord(tName, null, null, this.topElement.bt, this.topElement.et);
                            par.setValue(item.value);
                            if (this.topElement.id == null) continue;
                            this.guidIdMap.put(this.topElement.id, par.getAnnotationId());
                            par.setAnnotationId(par.getAnnotationId() + "_flexid_" + this.topElement.id);
                            continue;
                        }
                        tr.setLinguisticType(this.getLingItemType("interlinear-text", item));
                        tr.setParentTier((String)topLevelTierName);
                        AnnotationRecord child = this.createRefAnnotationRecord(tName, par, null);
                        child.setValue(item.value);
                    }
                } else {
                    this.tierNameSet.add("interlinear-text");
                    TierRecord tr = new TierRecord();
                    tr.setLinguisticType(this.getLingType("interlinear-text", null));
                    tr.setName("interlinear-text");
                    this.tierMap.put("interlinear-text", tr);
                    par = this.createAnnotationRecord("interlinear-text", null, null, this.topElement.bt, this.topElement.et);
                    if (this.topElement.id != null) {
                        this.guidIdMap.put(this.topElement.id, par.getAnnotationId());
                        par.setAnnotationId(par.getAnnotationId() + "_flexid_" + this.topElement.id);
                    }
                }
            }
            if ((childElems = this.topElement.getChildElems()) == null || childElems.size() <= 0) break block22;
            par = null;
            if (this.decoder.inclParagraphElement) {
                HashMap recordMap = new HashMap();
                ArrayList<Character> participants = new ArrayList<Character>();
                participants.addAll(this.participantMap.values());
                for (int i = 0; i < childElems.size(); ++i) {
                    elem = childElems.get(i);
                    this.createPhraseChildRecords(elem);
                }
            } else {
                for (int i = 0; i < childElems.size(); ++i) {
                    Object tName;
                    elem = childElems.get(i);
                    if (elem.getItems() != null && elem.getItems().size() > 0) {
                        for (int j = 0; j < elem.getItems().size(); ++j) {
                            Item item = elem.getItems().get(j);
                            tName = item.tierName;
                            if (!this.tierNameSet.contains(tName)) {
                                this.tierNameSet.add((String)tName);
                                TierRecord tr = new TierRecord();
                                tr.setName((String)tName);
                                tr.setDefaultLocale(item.lang);
                                tr.setLangRef(item.lang);
                                if (elem.speaker != null && !elem.speaker.equals("Not Specified")) {
                                    tr.setParticipant(elem.speaker);
                                }
                                if (j == 0) {
                                    tr.setLinguisticType(this.getLingType(elem.flexType, item));
                                } else {
                                    tr.setLinguisticType(this.getLingItemType(elem.flexType, item));
                                    tr.setParentTier((String)topLevelTierName);
                                }
                                this.tierMap.put((String)tName, tr);
                            }
                            if (j == 0) {
                                topLevelTierName = tName;
                                par = this.createAnnotationRecord((String)tName, null, null, elem.bt, elem.et);
                                par.setValue(item.value);
                                if (elem.id == null) continue;
                                this.guidIdMap.put(elem.id, par.getAnnotationId());
                                par.setAnnotationId(par.getAnnotationId() + "_flexid_" + elem.id);
                                continue;
                            }
                            AnnotationRecord child = this.createRefAnnotationRecord((String)tName, par, null);
                            child.setValue(item.value);
                        }
                    } else {
                        tName = this.participantMap.get(elem.speaker).toString() + "_" + elem.flexType;
                        if (!this.tierNameSet.contains(tName)) {
                            this.tierNameSet.add((String)tName);
                            TierRecord tr = new TierRecord();
                            tr.setLinguisticType(this.getLingType(elem.flexType, null));
                            tr.setName((String)tName);
                            if (elem.speaker != null && !elem.speaker.equals("Not Specified")) {
                                tr.setParticipant(elem.speaker);
                            }
                            this.tierMap.put((String)tName, tr);
                        }
                        par = this.createAnnotationRecord((String)tName, par, null, elem.bt, elem.et);
                        if (elem.id != null) {
                            this.guidIdMap.put(elem.id, par.getAnnotationId());
                            par.setAnnotationId(par.getAnnotationId() + "_flexid_" + elem.id);
                        }
                    }
                    this.createChildRecords(elem, par);
                }
            }
        }
    }

    private void createPhraseChildRecords(ContainerElem parElem) {
        if (parElem.getChildElems() == null || parElem.getChildElems().size() == 0) {
            return;
        }
        AnnotationRecord nextPar = null;
        AnnotationRecord prevAnn = null;
        Object firstItemTierName = null;
        HashMap<Character, AnnotationRecord> parentAnnMap = new HashMap<Character, AnnotationRecord>();
        for (int i = 0; i < parElem.getChildElems().size(); ++i) {
            Object tName;
            TierRecord tr;
            ContainerElem elem = parElem.getChildElems().get(i);
            AnnotationRecord parentAnn = (AnnotationRecord)parentAnnMap.get(Character.valueOf(this.getParticipantForSpeaker(elem.speaker)));
            if (parentAnn == null) {
                String tierName = this.getParticipantForSpeaker(elem.speaker) + "_" + parElem.flexType;
                if (!this.tierNameSet.contains(tierName)) {
                    this.tierNameSet.add(tierName);
                    tr = new TierRecord();
                    tr.setLinguisticType(this.getLingType(parElem.flexType, null));
                    tr.setName(tierName);
                    if (elem.speaker != null && !elem.speaker.equals("Not Specified")) {
                        tr.setParticipant(elem.speaker);
                    }
                    this.tierMap.put(tierName, tr);
                }
                parentAnn = this.createAnnotationRecord(tierName, null, null, parElem.bt, parElem.et);
                if (elem.id != null) {
                    this.guidIdMap.put(elem.id, parentAnn.getAnnotationId());
                    parentAnn.setAnnotationId(parentAnn.getAnnotationId() + "_flexid_" + parElem.id);
                }
                parentAnnMap.put(Character.valueOf(this.getParticipantForSpeaker(elem.speaker)), parentAnn);
            }
            if (elem.getItems() != null && elem.getItems().size() > 0) {
                for (int j = 0; j < elem.getItems().size(); ++j) {
                    Item item = elem.getItems().get(j);
                    tName = item.tierName;
                    if (!this.tierNameSet.contains(tName)) {
                        this.tierNameSet.add((String)tName);
                        tr = new TierRecord();
                        tr.setName((String)tName);
                        tr.setDefaultLocale(item.lang);
                        tr.setLangRef(item.lang);
                        if (elem.speaker != null && !elem.speaker.equals("Not Specified")) {
                            tr.setParticipant(elem.speaker);
                        }
                        if (j == 0) {
                            tr.setLinguisticType(this.getLingType(elem.flexType, item));
                            tr.setParentTier(this.annotRecordToTierMap.get(parentAnn));
                        } else {
                            tr.setLinguisticType(this.getLingItemType(elem.flexType, item));
                            tr.setParentTier((String)firstItemTierName);
                        }
                        this.tierMap.put((String)tName, tr);
                    }
                    if (j == 0) {
                        firstItemTierName = tName;
                        nextPar = this.isAlignable(elem.flexType) ? this.createAnnotationRecord((String)tName, parentAnn, prevAnn, elem.bt, elem.et) : this.createRefAnnotationRecord((String)tName, parentAnn, prevAnn);
                        if (elem.id != null) {
                            this.guidIdMap.put(elem.id, nextPar.getAnnotationId());
                            nextPar.setAnnotationId(nextPar.getAnnotationId() + "_flexid_" + elem.id);
                        }
                        if (item.type.equals("punct")) {
                            nextPar.setExtRefId(EXT_REF_ID);
                            this.createExternalRefForPunct();
                        }
                        nextPar.setValue(item.value);
                        prevAnn = nextPar;
                        continue;
                    }
                    AnnotationRecord child = this.createRefAnnotationRecord((String)tName, nextPar, null);
                    child.setValue(item.value);
                    if (!item.type.equals("punct")) continue;
                    child.setExtRefId(EXT_REF_ID);
                    this.createExternalRefForPunct();
                }
                if (nextPar == null) continue;
                this.createChildRecords(elem, nextPar);
                continue;
            }
            if (firstItemTierName != null) {
                tName = this.participantMap.get(elem.speaker).toString() + "_" + elem.flexType;
                if (!this.tierNameSet.contains(firstItemTierName)) {
                    this.tierNameSet.add((String)firstItemTierName);
                    TierRecord tr2 = new TierRecord();
                    tr2.setLinguisticType(this.getLingType(elem.flexType, null));
                    tr2.setName((String)tName);
                    tr2.setParentTier(this.annotRecordToTierMap.get(parentAnn));
                    if (elem.speaker != null && !elem.speaker.equals("Not Specified")) {
                        tr2.setParticipant(elem.speaker);
                    }
                    this.tierMap.put((String)firstItemTierName, tr2);
                }
                if (this.isAlignable(elem.flexType)) {
                    nextPar = this.createAnnotationRecord((String)firstItemTierName, parentAnn, prevAnn, elem.bt, elem.et);
                    if (elem.id != null) {
                        this.guidIdMap.put(elem.id, nextPar.getAnnotationId());
                        nextPar.setAnnotationId(nextPar.getAnnotationId() + "_flexid_" + elem.id);
                    }
                } else {
                    nextPar = this.createRefAnnotationRecord((String)firstItemTierName, parentAnn, prevAnn);
                }
                prevAnn = nextPar;
            }
            if (nextPar == null) continue;
            this.createChildRecords(elem, nextPar);
        }
    }

    private void createChildRecords(ContainerElem parElem, AnnotationRecord parentAnn) {
        if (parElem.getChildElems() == null || parElem.getChildElems().size() == 0) {
            return;
        }
        AnnotationRecord nextPar = null;
        AnnotationRecord prevAnn = null;
        Object firstItemTierName = null;
        for (int i = 0; i < parElem.getChildElems().size(); ++i) {
            Object tName;
            ContainerElem elem = parElem.getChildElems().get(i);
            if (elem.getItems() != null && elem.getItems().size() > 0) {
                for (int j = 0; j < elem.getItems().size(); ++j) {
                    Item item = elem.getItems().get(j);
                    tName = item.tierName;
                    if (!this.tierNameSet.contains(tName)) {
                        this.tierNameSet.add((String)tName);
                        TierRecord tr = new TierRecord();
                        tr.setName((String)tName);
                        tr.setDefaultLocale(item.lang);
                        tr.setLangRef(item.lang);
                        if (elem.speaker != null && !elem.speaker.equals("Not Specified")) {
                            tr.setParticipant(elem.speaker);
                        }
                        if (j == 0) {
                            tr.setLinguisticType(this.getLingType(elem.flexType, item));
                            tr.setParentTier(this.annotRecordToTierMap.get(parentAnn));
                        } else {
                            tr.setLinguisticType(this.getLingItemType(elem.flexType, item));
                            tr.setParentTier((String)firstItemTierName);
                        }
                        this.tierMap.put((String)tName, tr);
                    }
                    if (j == 0) {
                        firstItemTierName = tName;
                        nextPar = this.isAlignable(elem.flexType) ? this.createAnnotationRecord((String)tName, parentAnn, prevAnn, elem.bt, elem.et) : this.createRefAnnotationRecord((String)tName, parentAnn, prevAnn);
                        if (elem.id != null) {
                            this.guidIdMap.put(elem.id, nextPar.getAnnotationId());
                            nextPar.setAnnotationId(nextPar.getAnnotationId() + "_flexid_" + elem.id);
                        }
                        if (item.type.equals("punct")) {
                            nextPar.setExtRefId(EXT_REF_ID);
                            this.createExternalRefForPunct();
                        }
                        nextPar.setValue(item.value);
                        prevAnn = nextPar;
                        continue;
                    }
                    AnnotationRecord child = this.createRefAnnotationRecord((String)tName, nextPar, null);
                    child.setValue(item.value);
                    if (!item.type.equals("punct")) continue;
                    child.setExtRefId(EXT_REF_ID);
                    this.createExternalRefForPunct();
                }
                if (nextPar == null) continue;
                this.createChildRecords(elem, nextPar);
                continue;
            }
            if (firstItemTierName != null) {
                tName = this.participantMap.get(elem.speaker).toString() + "_" + elem.flexType;
                if (!this.tierNameSet.contains(firstItemTierName)) {
                    this.tierNameSet.add((String)firstItemTierName);
                    TierRecord tr = new TierRecord();
                    tr.setLinguisticType(this.getLingType(elem.flexType, null));
                    tr.setName((String)tName);
                    tr.setParentTier(this.annotRecordToTierMap.get(parentAnn));
                    if (elem.speaker != null && !elem.speaker.equals("Not Specified")) {
                        tr.setParticipant(elem.speaker);
                    }
                    this.tierMap.put((String)firstItemTierName, tr);
                }
                if (this.isAlignable(elem.flexType)) {
                    nextPar = this.createAnnotationRecord((String)firstItemTierName, parentAnn, prevAnn, elem.bt, elem.et);
                    if (elem.id != null) {
                        this.guidIdMap.put(elem.id, nextPar.getAnnotationId());
                        nextPar.setAnnotationId(nextPar.getAnnotationId() + "_flexid_" + elem.id);
                    }
                } else {
                    nextPar = this.createRefAnnotationRecord((String)firstItemTierName, parentAnn, prevAnn);
                }
                prevAnn = nextPar;
            }
            if (nextPar == null) continue;
            this.createChildRecords(elem, nextPar);
        }
    }

    private boolean isAlignable(String tierLevel) {
        return this.unitLevels.indexOf(tierLevel) >= this.unitLevels.indexOf(this.decoder.smallestWithTimeAlignment);
    }

    private char getParticipantForSpeaker(String speaker) {
        if (this.participantMap.containsKey(speaker)) {
            return this.participantMap.get(speaker).charValue();
        }
        char participant = (char)(this.participantMap.size() + 65);
        this.participantMap.put(speaker, Character.valueOf(participant));
        return participant;
    }

    private String getLingType(String flexType, Item item) {
        LingTypeRecord lt;
        Object lingName = flexType;
        if (flexType.equals("interlinear-text")) {
            lingName = "txt";
        }
        if (item != null && this.decoder.createLingForNewType) {
            lingName = item.type.equals("punct") ? (String)lingName + "-txt" : (String)lingName + "-" + item.type;
            if (this.decoder.createLingForNewLang && item.lang != null) {
                lingName = (String)lingName + "-" + item.lang;
            }
        }
        if ((lt = this.lingTypeRecords.get(lingName)) == null) {
            boolean alignable = false;
            String stereoType = null;
            if (flexType.equals("interlinear-text")) {
                alignable = true;
                stereoType = null;
            } else if (flexType.equals("paragraph")) {
                alignable = true;
                stereoType = null;
            } else if (flexType.equals("phrase")) {
                alignable = true;
                stereoType = this.decoder.inclParagraphElement ? Constraint.stereoTypes[1] : null;
            } else if (flexType.equals("word")) {
                if (this.decoder.smallestWithTimeAlignment.equals("word")) {
                    alignable = true;
                    stereoType = Constraint.stereoTypes[0];
                } else {
                    alignable = false;
                    stereoType = Constraint.stereoTypes[3];
                }
            } else if (flexType.equals("morph")) {
                alignable = false;
                stereoType = Constraint.stereoTypes[3];
            }
            lt = new LingTypeRecord();
            lt.setLingTypeId((String)lingName);
            lt.setTimeAlignable(String.valueOf(alignable));
            lt.setStereoType(stereoType);
            this.lingTypeRecords.put((String)lingName, lt);
        }
        return lt.getLingTypeId();
    }

    private String getLingItemType(String flexType, Item item) {
        LingTypeRecord lt;
        String lingName;
        if (this.decoder.createLingForNewType) {
            lingName = item.type.equals("punct") ? flexType + "-txt" : flexType + "-" + item.type;
            if (this.decoder.createLingForNewLang && !item.type.equals("type")) {
                lingName = (String)lingName + "-" + item.lang;
            }
        } else {
            lingName = flexType + "-item";
        }
        if ((lt = this.lingTypeRecords.get(lingName)) == null) {
            lt = new LingTypeRecord();
            lt.setLingTypeId(lingName);
            lt.setTimeAlignable("false");
            lt.setStereoType(Constraint.stereoTypes[4]);
            this.lingTypeRecords.put(lingName, lt);
        }
        return lt.getLingTypeId();
    }

    private AnnotationRecord createAnnotationRecord(String tierName, AnnotationRecord par, AnnotationRecord prev, long bt, long et) {
        AnnotationRecord ar = new AnnotationRecord();
        ar.setAnnotationId(ANN_ID_PREFIX + this.annotId++);
        ar.setAnnotationType("alignable");
        String steroetype = this.lingTypeRecords.get(this.tierMap.get(tierName).getLinguisticType()).getStereoType();
        if (par != null && steroetype != null && !steroetype.equals(Constraint.publicStereoTypes[1])) {
            if (prev != null) {
                String oldEndTSId = prev.getEndTimeSlotId();
                ar.setEndTimeSlotId(prev.getEndTimeSlotId());
                int beginTSId = this.tsId++;
                String nextId = TS_ID_PREFIX + beginTSId;
                ar.setBeginTimeSlotId(nextId);
                prev.setEndTimeSlotId(nextId);
                this.updateAnnRecordEndTS(oldEndTSId, nextId, prev.getAnnotationId());
                long[] ts = new long[]{beginTSId, bt};
                this.timeSlots.add(ts);
                this.timeOrder.add(ts);
            } else {
                ar.setBeginTimeSlotId(par.getBeginTimeSlotId());
                ar.setEndTimeSlotId(par.getEndTimeSlotId());
            }
        } else {
            int beginTSId = this.tsId++;
            int endTSId = this.tsId++;
            ar.setBeginTimeSlotId(TS_ID_PREFIX + beginTSId);
            ar.setEndTimeSlotId(TS_ID_PREFIX + endTSId);
            long[] begin = new long[]{beginTSId, bt};
            long[] end = new long[]{endTSId, et};
            this.timeSlots.add(begin);
            this.timeSlots.add(end);
            this.timeOrder.add(begin);
            this.timeOrder.add(end);
        }
        this.annotationRecords.add(ar);
        this.addRecordToTierMap(ar, tierName);
        return ar;
    }

    private AnnotationRecord createRefAnnotationRecord(String tierName, AnnotationRecord par, AnnotationRecord prev) {
        AnnotationRecord ar = new AnnotationRecord();
        ar.setAnnotationId(ANN_ID_PREFIX + this.annotId++);
        ar.setAnnotationType("reference");
        if (par != null) {
            ar.setReferredAnnotId(par.getAnnotationId());
        } else {
            System.out.println("Error: null as parent! " + tierName);
        }
        if (prev != null && prev.getAnnotationType() == "reference") {
            ar.setPreviousAnnotId(prev.getAnnotationId());
        }
        this.annotationRecords.add(ar);
        this.addRecordToTierMap(ar, tierName);
        return ar;
    }

    private void addRecordToTierMap(AnnotationRecord annRec, String tierName) {
        this.annotRecordToTierMap.put(annRec, tierName);
        if (this.tierNameToAnnRecordMap.containsKey(tierName)) {
            this.tierNameToAnnRecordMap.get(tierName).add(annRec);
        } else {
            ArrayList<AnnotationRecord> ar = new ArrayList<AnnotationRecord>();
            ar.add(annRec);
            this.tierNameToAnnRecordMap.put(tierName, ar);
        }
    }

    private void updateAnnRecordEndTS(String oldEndTSId, String nextId, String annotId) {
        try {
            int refId = 0;
            int index = annotId.indexOf("_flexid_");
            refId = index > 0 ? Integer.parseInt(this.guidIdMap.get(annotId.substring(index + "_flexid_".length())).substring(ANN_ID_PREFIX.length())) : Integer.parseInt(annotId.substring(ANN_ID_PREFIX.length()));
            int depId = 0;
            for (AnnotationRecord record : this.annotationRecords) {
                if (record.getAnnotationType() != "alignable" || record.getEndTimeSlotId() != oldEndTSId) continue;
                try {
                    index = record.getAnnotationId().indexOf("_flexid_");
                    depId = index > 0 ? Integer.parseInt(this.guidIdMap.get(record.getAnnotationId().substring(index + "_flexid_".length())).substring(ANN_ID_PREFIX.length())) : Integer.parseInt(record.getAnnotationId().substring(ANN_ID_PREFIX.length()));
                    if (depId <= refId) continue;
                    record.setEndTimeSlotId(nextId);
                }
                catch (Exception ex) {
                    System.out.println("Cannot update depending annotation record: " + record.getAnnotationId());
                }
            }
        }
        catch (NumberFormatException nfe) {
            System.out.println("Cannot update depending annotation records of: " + annotId);
        }
    }

    private void calculateDurations() {
        List<ContainerElem> elements = this.topElement.getChildElems();
        if (elements != null && elements.size() > 0) {
            if (this.decoder.inclParagraphElement) {
                long paragraphBt = 0L;
                long curTime = 0L;
                String prevSpeaker = null;
                for (int i = 0; i < elements.size(); ++i) {
                    ContainerElem elem = elements.get(i);
                    List<ContainerElem> phraseElems = elem.getChildElems();
                    if (phraseElems == null) continue;
                    for (int j = 0; j < phraseElems.size(); ++j) {
                        ContainerElem phraseElem = phraseElems.get(j);
                        String curSpeaker = phraseElem.speaker;
                        if (prevSpeaker == null || prevSpeaker.equals(curSpeaker)) {
                            if (phraseElem.bt == -1L || phraseElem.bt < curTime) {
                                phraseElem.bt = curTime;
                            }
                        } else {
                            for (int k = j - 1; k >= 0; --k) {
                                ContainerElem prevElem = elements.get(k);
                                if (prevElem.et <= phraseElem.bt) break;
                                if (!curSpeaker.equals(prevElem.speaker)) continue;
                                phraseElem.bt = prevElem.et;
                            }
                        }
                        if (phraseElem.et < phraseElem.bt) {
                            phraseElem.et = phraseElem.bt + this.decoder.perPhraseDuration;
                        }
                        if (curTime < phraseElem.et) {
                            curTime = phraseElem.et;
                        }
                        if (j == 0) {
                            paragraphBt = phraseElem.bt;
                        }
                        prevSpeaker = curSpeaker;
                    }
                    elem.bt = paragraphBt;
                    elem.et = curTime;
                    paragraphBt = curTime;
                }
                this.topElement.bt = 0L;
                this.topElement.et = curTime;
            } else {
                long curTime = 0L;
                String prevSpeaker = null;
                for (int j = 0; j < elements.size(); ++j) {
                    ContainerElem phraseElem = elements.get(j);
                    String curSpeaker = phraseElem.speaker;
                    if (prevSpeaker == null || prevSpeaker.equals(curSpeaker)) {
                        if (phraseElem.bt == -1L || phraseElem.bt < curTime) {
                            phraseElem.bt = curTime;
                        }
                    } else if (phraseElem.bt == -1L) {
                        phraseElem.bt = curTime;
                    } else {
                        for (int k = j - 1; k >= 0; --k) {
                            ContainerElem prevElem = elements.get(k);
                            if (prevElem.et <= phraseElem.bt) break;
                            if (!curSpeaker.equals(prevElem.speaker)) continue;
                            phraseElem.bt = prevElem.et;
                        }
                    }
                    if (phraseElem.et < phraseElem.bt) {
                        phraseElem.et = phraseElem.bt + this.decoder.perPhraseDuration;
                    }
                    if (curTime < phraseElem.et) {
                        curTime = phraseElem.et;
                    }
                    prevSpeaker = curSpeaker;
                }
                this.topElement.bt = 0L;
                this.topElement.et = curTime;
            }
        }
    }

    private class FlexContentHandler
    implements ContentHandler {
        private ContainerElem curElem;
        private ContainerElem nextElem;
        private Item nextItem;
        private String type;
        private char participant;
        Property prop;
        private StringBuilder content = new StringBuilder();

        private FlexContentHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if ("document".equals(qName)) {
                return;
            }
            if ("interlinear-text".equals(qName)) {
                FlexParser.this.topElement = new ContainerElem("interlinear-text");
                this.curElem = FlexParser.this.topElement;
                this.curElem.id = atts.getValue("guid");
                return;
            }
            if (((FlexParser)FlexParser.this).decoder.inclParagraphElement && "paragraph".equals(qName)) {
                this.nextElem = new ContainerElem("paragraph");
                this.nextElem.id = atts.getValue("guid");
                this.curElem.addElement(this.nextElem);
                this.curElem = this.nextElem;
            } else if ("phrase".equals(qName)) {
                this.nextElem = new ContainerElem("phrase");
                if (atts.getValue("begin-time-offset") != null) {
                    this.nextElem.bt = Long.parseLong(atts.getValue("begin-time-offset"));
                }
                if (atts.getValue("end-time-offset") != null) {
                    this.nextElem.et = Long.parseLong(atts.getValue("end-time-offset"));
                }
                if (atts.getValue("speaker") != null) {
                    this.nextElem.speaker = atts.getValue("speaker");
                }
                if (this.nextElem.speaker == null || this.nextElem.speaker.trim().length() == 0) {
                    this.nextElem.speaker = "Not Specified";
                }
                this.participant = FlexParser.this.getParticipantForSpeaker(this.nextElem.speaker);
                this.nextElem.id = atts.getValue("guid");
                this.curElem.addElement(this.nextElem);
                this.curElem = this.nextElem;
            } else if ("word".equals(qName)) {
                this.nextElem = new ContainerElem("word");
                this.nextElem.id = atts.getValue("guid");
                this.nextElem.speaker = this.curElem.speaker;
                this.curElem.addElement(this.nextElem);
                this.curElem = this.nextElem;
            } else if ("morph".equals(qName)) {
                this.nextElem = new ContainerElem("morph");
                this.nextElem.id = atts.getValue("guid");
                this.nextElem.speaker = this.curElem.speaker;
                String typeVal = atts.getValue("type");
                if (typeVal != null && typeVal.length() > 0) {
                    this.nextItem = new Item();
                    this.nextItem.type = "type";
                    this.nextItem.value = typeVal;
                    this.nextElem.addItem(this.nextItem);
                    this.nextItem.tierName = this.participant + "_" + this.nextElem.flexType + "-" + this.nextItem.type;
                    if (FlexParser.this.tiersPerLevel.get(this.nextElem.flexType) == null) {
                        FlexParser.this.tiersPerLevel.put(this.nextElem.flexType, new LinkedHashSet(10));
                    }
                    ((LinkedHashSet)FlexParser.this.tiersPerLevel.get(this.nextElem.flexType)).add(this.nextItem.tierName);
                }
                this.curElem.addElement(this.nextElem);
                this.curElem = this.nextElem;
            } else {
                MediaDescriptor descriptor;
                String medPath;
                if ("item".equals(qName)) {
                    this.type = atts.getValue("type");
                    if (this.type != null && this.type.length() > 0) {
                        this.nextItem = new Item();
                        this.nextItem.type = this.type;
                        if ("txt".equals(this.type) || "punct".equals(this.type)) {
                            this.type = "txt";
                        }
                        this.nextItem.lang = atts.getValue("lang");
                        String tierName = null;
                        tierName = this.participant >= 'A' ? this.participant + "_" + this.curElem.flexType + "-" + this.type : this.curElem.flexType + "-" + this.type;
                        if (this.nextItem.lang != null) {
                            tierName = tierName + "-" + this.nextItem.lang;
                        }
                        this.nextItem.tierName = tierName;
                        if (FlexParser.this.tiersPerLevel.get(this.curElem.flexType) == null) {
                            FlexParser.this.tiersPerLevel.put(this.curElem.flexType, new LinkedHashSet(10));
                        }
                        ((LinkedHashSet)FlexParser.this.tiersPerLevel.get(this.curElem.flexType)).add(tierName);
                    }
                    return;
                }
                if ("language".equals(qName)) {
                    String lang = atts.getValue("lang");
                    if (lang != null) {
                        String font = atts.getValue("font");
                        String vernacular = atts.getValue("vernacular");
                        Object value = font != null ? font : "";
                        if (vernacular != null) {
                            value = (String)value + "-" + vernacular;
                        }
                        FlexParser.this.langMap.put(lang, value);
                        FlexParser.this.languages.add(new LanguageRecord(lang, lang, lang));
                    }
                } else if ("media".equals(qName) && (medPath = atts.getValue("location")) != null && medPath.trim().length() > 0 && (descriptor = MediaDescriptorUtil.createMediaDescriptor(medPath)) != null && !FlexParser.this.mediaDescriptors.contains(descriptor)) {
                    FlexParser.this.mediaDescriptors.add(descriptor);
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.content.append(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("interlinear-text".equals(qName)) {
                return;
            }
            if (((FlexParser)FlexParser.this).decoder.inclParagraphElement && "paragraph".equals(qName) || "phrase".equals(qName) || "word".equals(qName) || "morph".equals(qName)) {
                this.curElem = this.curElem.parent;
            } else if ("item".equals(qName)) {
                this.nextItem.value = this.content.toString().trim();
                this.content.delete(0, this.content.length());
                this.curElem.addItem(this.nextItem);
            }
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }
    }
}

