/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.graf;

import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.AnnotationDocEncoder;
import mpi.eudico.server.corpora.clom.EncoderInfo;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.RefAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.IoUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GrAFEncoder
implements AnnotationDocEncoder {
    protected Document doc;
    private Element graphElement;

    public GrAFEncoder() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        this.doc = db.newDocument();
        this.graphElement = this.doc.createElement("graph");
    }

    @Override
    public void encodeAndSave(Transcription theTranscription, EncoderInfo theEncoderInfo, List<TierImpl> tierOrder, String path) throws IOException {
        int i;
        TierImpl t1;
        int i2;
        TranscriptionImpl transImpl = (TranscriptionImpl)theTranscription;
        this.graphElement.setAttribute("id", transImpl.getName());
        int nodeId = 1;
        int regionId = 1;
        int edgeId = 1;
        HashMap<AbstractAnnotation, CallSite> annNodeIdMap = new HashMap<AbstractAnnotation, CallSite>();
        ArrayList<Element> nodeSets = new ArrayList<Element>();
        ArrayList<Element> edges = new ArrayList<Element>();
        ArrayList<Element> regions = new ArrayList<Element>();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
        ArrayList<DefaultMutableTreeNode> tierNodes = new ArrayList<DefaultMutableTreeNode>();
        HashMap<TierImpl, DefaultMutableTreeNode> nodeMap = new HashMap<TierImpl, DefaultMutableTreeNode>();
        for (i2 = 0; i2 < transImpl.getTiers().size(); ++i2) {
            t1 = transImpl.getTiers().get(i2);
            DefaultMutableTreeNode nextnode = new DefaultMutableTreeNode(t1);
            tierNodes.add(nextnode);
            nodeMap.put(t1, nextnode);
        }
        for (i2 = 0; i2 < transImpl.getTiers().size(); ++i2) {
            t1 = transImpl.getTiers().get(i2);
            if (t1.getParentTier() == null) {
                root.add((MutableTreeNode)nodeMap.get(t1));
                continue;
            }
            ((DefaultMutableTreeNode)nodeMap.get(t1.getParentTier())).add((MutableTreeNode)nodeMap.get(t1));
        }
        tierNodes.clear();
        nodeMap.clear();
        Enumeration<TreeNode> treeEnum = root.breadthFirstEnumeration();
        treeEnum.nextElement();
        while (treeEnum.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)treeEnum.nextElement();
            t1 = (TierImpl)node.getUserObject();
            Element nodeSet = this.createNodeSet(t1.getName());
            nodeSets.add(nodeSet);
            AbstractAnnotation nextAnn = null;
            Annotation prevAnn = null;
            List<AbstractAnnotation> anns = t1.getAnnotations();
            for (int i3 = 0; i3 < anns.size(); ++i3) {
                nextAnn = anns.get(i3);
                String nid = "n" + nodeId++;
                String link = null;
                if (nextAnn instanceof AlignableAnnotation) {
                    StringBuilder anchors = new StringBuilder();
                    AlignableAnnotation nextAnnAl = (AlignableAnnotation)nextAnn;
                    if (nextAnnAl.getBegin().isTimeAligned()) {
                        anchors.append(String.valueOf(nextAnnAl.getBegin().getTime()));
                    } else {
                        anchors.append(String.valueOf(-1));
                        if (prevAnn != null && prevAnn.getParentAnnotation() == nextAnn.getParentAnnotation()) {
                            Element edge = this.createEdge("r" + edgeId++, (String)annNodeIdMap.get(prevAnn), nid);
                            edges.add(edge);
                        }
                    }
                    anchors.append(" ");
                    if (nextAnnAl.getEnd().isTimeAligned()) {
                        anchors.append(String.valueOf(nextAnnAl.getEnd().getTime()));
                    } else {
                        anchors.append(String.valueOf(-1));
                    }
                    link = "r" + regionId++;
                    Element region = this.createRegion(link, anchors.toString());
                    regions.add(region);
                } else {
                    Element edge;
                    RefAnnotation refAnno = (RefAnnotation)nextAnn;
                    if (refAnno.getPrevious() != null) {
                        edge = this.createEdge("r" + edgeId++, (String)annNodeIdMap.get(prevAnn), nid);
                        edges.add(edge);
                    }
                    if (refAnno.getParentAnnotation() != null) {
                        edge = this.createEdge("r" + edgeId++, nid, (String)annNodeIdMap.get(refAnno.getParentAnnotation()));
                        edges.add(edge);
                    }
                }
                Element annNode = this.createNode(nid, nextAnn.getValue(), link);
                nodeSet.appendChild(annNode);
                annNodeIdMap.put(nextAnn, (CallSite)((Object)nid));
                prevAnn = nextAnn;
            }
        }
        for (i = 0; i < regions.size(); ++i) {
            this.graphElement.appendChild((Node)regions.get(i));
        }
        for (i = 0; i < nodeSets.size(); ++i) {
            this.graphElement.appendChild((Node)nodeSets.get(i));
        }
        for (i = 0; i < edges.size(); ++i) {
            this.graphElement.appendChild((Node)edges.get(i));
        }
        try {
            IoUtil.writeEncodedFile("UTF-8", path, this.graphElement);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private Element createNodeSet(String id) {
        Element elem = this.doc.createElement("nodeSet");
        elem.setAttribute("id", id);
        return elem;
    }

    private Element createNode(String id, String value, String link) {
        Element nn = this.doc.createElement("node");
        if (link != null) {
            Element ln = this.doc.createElement("link");
            ln.setAttribute("to", link);
            nn.appendChild(ln);
        }
        Element as = this.doc.createElement("as");
        as.setAttribute("type", "default");
        nn.appendChild(as);
        Element feat = this.doc.createElement("f");
        feat.setAttribute("n", "label");
        feat.setAttribute("v", value);
        as.appendChild(feat);
        return nn;
    }

    private Element createEdge(String id, String from, String to) {
        Element nedge = this.doc.createElement("edge");
        nedge.setAttribute("from", from);
        nedge.setAttribute("to", to);
        return nedge;
    }

    private Element createRegion(String link, String anchors) {
        Element re = this.doc.createElement("region");
        re.setAttribute("id", link);
        re.setAttribute("anchors", anchors);
        return re;
    }

    public static void main(String[] args) {
        try {
            GrAFEncoder enc = new GrAFEncoder();
            TranscriptionImpl trans = new TranscriptionImpl("/Users/Shared/MPI/Demo material/pear/pear story.eaf");
            enc.encodeAndSave(trans, null, null, "/Users/Shared/MPI/Demo material/pear/pear story_graf.xml");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

