/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.shoebox.interlinear;

import java.util.List;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.shoebox.interlinear.Metrics;
import mpi.eudico.server.corpora.clomimpl.shoebox.interlinear.Renderer;
import mpi.eudico.server.corpora.clomimpl.shoebox.interlinear.SizeCalculator;

public class ByteRenderer
extends Renderer {
    public static String[] render(Metrics metrics) {
        String[] outputLines = new String[metrics.getMaxVerticalPosition() + 1];
        for (int i = 0; i < outputLines.length; ++i) {
            outputLines[i] = "";
        }
        ByteRenderer.renderAnnotationValues(metrics, outputLines);
        return outputLines;
    }

    public static void renderTierLabels(Metrics metrics, String[] outputLines) {
        Integer vPos2 = null;
        String tierLabel = "";
        List<Integer> vPositions = metrics.getPositionsOfNonEmptyTiers();
        for (Integer vPos2 : vPositions) {
            tierLabel = metrics.getTierLabelAt(vPos2);
            int n = vPos2;
            outputLines[n] = outputLines[n] + tierLabel + " ";
        }
    }

    public static void renderAnnotationValues(Metrics metrics, String[] outputLines) {
        List<Annotation> annots = metrics.getBlockWiseOrdered();
        for (Annotation a : annots) {
            int vPos = metrics.getVerticalPosition(a);
            int hPos = metrics.getHorizontalPosition(a);
            String tierLabel = metrics.getTierLabelAt(vPos);
            if (metrics.getInterlinearizer().getCharEncoding(tierLabel) != 0) {
                int n = vPos;
                outputLines[n] = outputLines[n] + ByteRenderer.nSpaces(hPos - outputLines[vPos].length()) + a.getValue();
                continue;
            }
            int n = vPos;
            outputLines[n] = outputLines[n] + ByteRenderer.nSpaces(hPos - SizeCalculator.getNumOfBytes(outputLines[vPos])) + a.getValue();
        }
    }

    private static String nSpaces(int n) {
        Object ret = "";
        for (int i = 0; i < n; ++i) {
            ret = (String)ret + " ";
        }
        return ret;
    }
}

