/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.shoebox.interlinear;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.RefAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.shoebox.interlinear.TimeCodedTranscription;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicAssociation;
import mpi.eudico.util.TimeFormatter;

public class TimeCodedTranscriptionImpl
implements TimeCodedTranscription {
    private TranscriptionImpl wrappedTranscription;
    private List<Tier> timeCodeTiers = null;
    private int tcTierCounter = 0;
    private LinguisticType tcLingType;
    private Map<TierImpl, TierImpl> rootTiers;
    private Map<Annotation, RefAnnotation> tcChildAnnots;

    public TimeCodedTranscriptionImpl(TranscriptionImpl trImpl) {
        this.wrappedTranscription = trImpl;
        this.timeCodeTiers = new ArrayList<Tier>();
        this.rootTiers = new HashMap<TierImpl, TierImpl>();
        this.tcChildAnnots = new HashMap<Annotation, RefAnnotation>();
        this.tcLingType = new LinguisticType("12nov2004_temp$LING$type");
        this.tcLingType.setTimeAlignable(false);
        this.tcLingType.addConstraint(new SymbolicAssociation());
    }

    @Override
    public Transcription getTranscription() {
        return this.wrappedTranscription;
    }

    @Override
    public List<Tier> getTiers() {
        List<TierImpl> tiers = this.wrappedTranscription.getTiers();
        ArrayList<Tier> allTiers = new ArrayList<Tier>(tiers);
        if (this.timeCodeTiers != null) {
            allTiers.addAll(this.timeCodeTiers);
        }
        return allTiers;
    }

    @Override
    public List<? extends Annotation> getChildAnnotationsOf(Annotation theAnnot) {
        ArrayList<Annotation> childAnnots = new ArrayList<Annotation>(this.wrappedTranscription.getChildAnnotationsOf(theAnnot));
        Annotation child = this.tcChildAnnots.get(theAnnot);
        if (child != null) {
            childAnnots.add(child);
        }
        return childAnnots;
    }

    @Override
    public TierImpl getParentTier(Tier theTier) {
        TierImpl parentTier = null;
        if (theTier != null) {
            parentTier = this.timeCodeTiers.contains(theTier) ? this.rootTiers.get(theTier) : ((TierImpl)theTier).getParentTier();
        }
        return parentTier;
    }

    @Override
    public Tier getRootTier(Tier forTier) {
        Tier rootTier = null;
        if (forTier != null) {
            rootTier = this.timeCodeTiers.contains(forTier) ? (Tier)this.rootTiers.get(forTier) : ((TierImpl)forTier).getRootTier();
        }
        return rootTier;
    }

    @Override
    public boolean isAncestorOf(Tier tier1, Tier tier2) {
        boolean ancestor = false;
        TierImpl parentTier = this.getParentTier(tier2);
        if (parentTier != null) {
            ancestor = parentTier == tier1 ? true : this.isAncestorOf(tier1, parentTier);
        }
        return ancestor;
    }

    @Override
    public List<TierImpl> getTierTree(TierImpl tier) {
        ArrayList<TierImpl> tierTree = new ArrayList<TierImpl>();
        List<TierImpl> children = tier.getChildTiers();
        tierTree.add(tier);
        for (int j = 0; j < children.size(); ++j) {
            TierImpl child = children.get(j);
            tierTree.addAll(this.getTierTree(child));
        }
        for (int i = 0; i < this.timeCodeTiers.size(); ++i) {
            TierImpl tcTier = (TierImpl)this.timeCodeTiers.get(i);
            if (this.rootTiers.get(tcTier) != tier) continue;
            tierTree.add(tcTier);
        }
        return tierTree;
    }

    @Override
    public void prepareTimeCodeRendering(int timeCodeStyle, boolean correctAnnotationTimes) {
        this.cleanupTimeCodeTiers();
        this.addTimeCodeTiers(timeCodeStyle, correctAnnotationTimes);
    }

    @Override
    public void cleanupTimeCodeTiers() {
        this.timeCodeTiers.clear();
        this.rootTiers.clear();
        this.tcChildAnnots.clear();
        this.tcTierCounter = 0;
    }

    private void addTimeCodeTiers(int timeCodeStyle, boolean correctAnnotationTimes) {
        List<MediaDescriptor> mds;
        long offset = 0L;
        if (correctAnnotationTimes && (mds = this.wrappedTranscription.getMediaDescriptors()) != null && mds.size() > 0) {
            offset = mds.get((int)0).timeOrigin;
        }
        List<TierImpl> topTiers = this.wrappedTranscription.getTopTiers();
        for (int i = 0; i < topTiers.size(); ++i) {
            TierImpl topT = topTiers.get(i);
            this.timeCodeTiers.add(this.addTCTierFor(topT, timeCodeStyle, offset));
        }
    }

    private Tier addTCTierFor(TierImpl tier, int timeCodeStyle, long mediaOffset) {
        TierImpl newTier = null;
        String newTierName = "TC-" + this.tcTierCounter++;
        newTier = new TierImpl(null, newTierName, null, null, null);
        newTier.setLinguisticType(this.tcLingType);
        for (Annotation annotation : tier.getAnnotations()) {
            RefAnnotation newAnnot = new RefAnnotation(null, newTier);
            newAnnot.getReferences().add(annotation);
            newTier.addAnnotation(newAnnot);
            long bl = -1L;
            long el = -1L;
            if (annotation instanceof AlignableAnnotation && ((AlignableAnnotation)annotation).getBegin().isTimeAligned()) {
                bl = annotation.getBeginTimeBoundary() + mediaOffset;
            }
            if (annotation instanceof AlignableAnnotation && ((AlignableAnnotation)annotation).getEnd().isTimeAligned()) {
                el = annotation.getEndTimeBoundary() + mediaOffset;
            }
            Object value = "";
            if (timeCodeStyle == 0) {
                String beginStr = "??:??:??:???";
                if (bl != -1L) {
                    beginStr = TimeFormatter.toString(bl);
                }
                String endStr = "??:??:??:???";
                if (el != -1L) {
                    endStr = TimeFormatter.toString(el);
                }
                value = beginStr + " - " + endStr;
            } else {
                double bd = (double)bl / 1000.0;
                double ed = (double)el / 1000.0;
                DecimalFormat ssmmm = new DecimalFormat("#0.000", new DecimalFormatSymbols(Locale.US));
                String bs = "?.???";
                if (bl != -1L) {
                    bs = ssmmm.format(bd);
                }
                String es = "?.???";
                if (el != -1L) {
                    es = ssmmm.format(ed);
                }
                value = bs + " - " + es;
            }
            newAnnot.setValue((String)value);
            this.tcChildAnnots.put(annotation, newAnnot);
        }
        this.rootTiers.put(newTier, tier);
        return newTier;
    }

    @Override
    public List<Tier> getTimeCodeTiers() {
        return this.timeCodeTiers;
    }
}

