/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.transcriber;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import mpi.eudico.server.corpora.clom.DecoderInfo;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.Parser;
import mpi.eudico.server.corpora.clomimpl.dobes.AnnotationRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.CVEntryRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.CVRecord;
import mpi.eudico.server.corpora.clomimpl.dobes.LingTypeRecord;
import mpi.eudico.server.corpora.clomimpl.transcriber.TranscriberDecoderInfo;
import mpi.eudico.server.corpora.clomimpl.transcriber.TranscriberEvent;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.util.Pair;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Transcriber14Parser
extends Parser {
    private static boolean verbose = false;
    private static int annotationCounter = 0;
    private static int timeSlotCounter = 0;
    private static final String ANN_PREFIX = "a";
    private static final String TS_PREFIX = "ts";
    private static final String SP_PREFIX = "Sp";
    private static final String SECTION_TIER_NAME = "Sections";
    private static final String TURN_TIER_NAME = "Turns";
    private static final String BACKGROUND_TIER_NAME = "Background";
    private static final String COMMENT_TIER_NAME = "Comments";
    private static final String MODE_TIER_NAME = "Mode";
    private static final String FIDELITY_TIER_NAME = "Fidelity";
    private static final String CHANNEL_TIER_NAME = "Channel";
    private static final String SINGLE_TIER_NAME = "Speech";
    private static final String UTTERANCE_TYPE = "UtteranceType";
    private static final String SECTION_TYPE = "SectionType";
    private static final String TURN_TYPE = "TurnType";
    private static final String MODE_TYPE = "ModeType";
    private static final String FIDELITY_TYPE = "FidelityType";
    private static final String CHANNEL_TYPE = "ChannelType";
    private static final String BACKGROUND_TYPE = "BackgroundType";
    private static final String COMMENT_TYPE = "CommentType";
    private static final String SECTION_TYPE_CV = "SectionTypeCV";
    private static final String TURN_MODE_CV = "TurnModeCV";
    private static final String TURN_FIDELITY_CV = "TurnFidelityCV";
    private static final String TURN_CHANNEL_CV = "TurnChannelCV";
    private static final String SPEAKER_UNSPECIFIED = "Unspecified";
    private SAXParser saxParser;
    private DefaultHandler transcriberHandler;
    private TranscriberDecoderInfo decoderInfo;
    private boolean singleSpeechTier = false;
    private String lastParsed = "";
    private String currentFileName;
    private boolean parseError;
    private String audioFileName;
    private String scribe;
    private String language;
    private String date;
    private Map<String, String> speakersHash = new HashMap<String, String>();
    private List<SectionRecord> sectionArrayList = new ArrayList<SectionRecord>();
    private List<UtteranceRecord> utteranceRecords = new ArrayList<UtteranceRecord>();
    private List<BackgroundRecord> backgroundArrayList = new ArrayList<BackgroundRecord>();
    private Map<String, Long> timeSlots = new HashMap<String, Long>();
    private Map<AnnotationRecord, String> annotRecordToTierMap = new HashMap<AnnotationRecord, String>();
    private TreeSet<String> tierNameSet = new TreeSet();
    private Map<String, String> topicHash = new HashMap<String, String>();
    private List<CommentRecord> commentRecords = new ArrayList<CommentRecord>();
    private Map<String, CVRecord> controlledVocabularies = null;
    private SectionRecord currentSectionRecord;
    private SectionRecord lastSectionRecord;
    private TurnRecord currentTurnRecord;
    private TurnRecord lastTurnRecord;
    private String currentSpeakerId;
    private String speakersForCurrentTurn;
    private String lastSyncTime;
    private Map<String, String> currentSpeakerContents = new HashMap<String, String>();
    private BackgroundRecord lastBackgroundRecord;
    private String currentComments = "";

    public Transcriber14Parser() {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        try {
            this.saxParser = factory.newSAXParser();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.transcriberHandler = new Transcriber14Handler();
    }

    @Override
    public String getMediaFile(String fileName) {
        this.parse(fileName);
        return null;
    }

    @Override
    public List<MediaDescriptor> getMediaDescriptors(String fileName) {
        this.parse(fileName);
        ArrayList<MediaDescriptor> mediaDescriptors = new ArrayList<MediaDescriptor>();
        if (this.audioFileName != null) {
            String urlString = this.pathToURLString(fileName);
            String mediaURL = urlString.substring(0, urlString.lastIndexOf("/") + 1) + this.audioFileName;
            if (!mediaURL.endsWith(".wav")) {
                mediaURL = mediaURL + ".wav";
            }
            MediaDescriptor md = new MediaDescriptor(mediaURL, "audio/x-wav");
            mediaDescriptors.add(md);
        }
        return mediaDescriptors;
    }

    @Override
    public String getAuthor(String fileName) {
        this.parse(fileName);
        return this.scribe;
    }

    @Override
    public List<LingTypeRecord> getLinguisticTypes(String fileName) {
        ArrayList<LingTypeRecord> lingTypeRecords = new ArrayList<LingTypeRecord>();
        this.parse(fileName);
        LingTypeRecord lt = new LingTypeRecord();
        lt.setLingTypeId(UTTERANCE_TYPE);
        lt.setTimeAlignable("true");
        lt.setStereoType(null);
        lt.setControlledVocabulary(null);
        lingTypeRecords.add(lt);
        lt = new LingTypeRecord();
        lt.setLingTypeId(SECTION_TYPE);
        lt.setTimeAlignable("true");
        lt.setStereoType(null);
        lt.setControlledVocabulary(SECTION_TYPE_CV);
        lingTypeRecords.add(lt);
        lt = new LingTypeRecord();
        lt.setLingTypeId(TURN_TYPE);
        lt.setTimeAlignable("true");
        lt.setStereoType(Constraint.stereoTypes[0]);
        lt.setControlledVocabulary(null);
        lingTypeRecords.add(lt);
        lt = new LingTypeRecord();
        lt.setLingTypeId(MODE_TYPE);
        lt.setTimeAlignable("false");
        lt.setStereoType(Constraint.stereoTypes[4]);
        lt.setControlledVocabulary(null);
        lingTypeRecords.add(lt);
        lt = new LingTypeRecord();
        lt.setLingTypeId(FIDELITY_TYPE);
        lt.setTimeAlignable("false");
        lt.setStereoType(Constraint.stereoTypes[4]);
        lt.setControlledVocabulary(null);
        lingTypeRecords.add(lt);
        lt = new LingTypeRecord();
        lt.setLingTypeId(CHANNEL_TYPE);
        lt.setTimeAlignable("false");
        lt.setStereoType(Constraint.stereoTypes[4]);
        lt.setControlledVocabulary(null);
        lingTypeRecords.add(lt);
        lt = new LingTypeRecord();
        lt.setLingTypeId(BACKGROUND_TYPE);
        lt.setTimeAlignable("true");
        lt.setStereoType(null);
        lt.setControlledVocabulary(null);
        lingTypeRecords.add(lt);
        lt = new LingTypeRecord();
        lt.setLingTypeId(COMMENT_TYPE);
        lt.setTimeAlignable("true");
        lt.setStereoType(null);
        lt.setControlledVocabulary(null);
        lingTypeRecords.add(lt);
        return lingTypeRecords;
    }

    @Override
    public List<String> getTimeOrder(String fileName) {
        this.parse(fileName);
        ArrayList<String> timeOrder = new ArrayList<String>();
        ArrayList<Pair<String, Long>> tempOrder = new ArrayList<Pair<String, Long>>();
        for (String id : this.timeSlots.keySet()) {
            Long time = this.timeSlots.get(id);
            Pair<String, Long> pair = Pair.makePair(id, time);
            tempOrder.add(pair);
        }
        Collections.sort(tempOrder, new PairComparator());
        for (int i = 0; i < tempOrder.size(); ++i) {
            timeOrder.add((String)((Pair)tempOrder.get(i)).getFirst());
        }
        return timeOrder;
    }

    @Override
    public Map<String, String> getTimeSlots(String fileName) {
        this.parse(fileName);
        HashMap<String, String> resultSlots = new HashMap<String, String>();
        for (Map.Entry<String, Long> e : this.timeSlots.entrySet()) {
            String id = e.getKey();
            String timeString = e.getValue().toString();
            resultSlots.put(id, timeString);
        }
        return resultSlots;
    }

    @Override
    public Map<String, CVRecord> getControlledVocabularies(String fileName) {
        this.parse(fileName);
        if (this.controlledVocabularies == null) {
            CVEntryRecord cvEntry = null;
            this.controlledVocabularies = new HashMap<String, CVRecord>();
            CVRecord cv = new CVRecord(SECTION_TYPE_CV);
            cv.setDescription("All values that are allowed for Transcriber Section.type attribute");
            cvEntry = new CVEntryRecord();
            cvEntry.setValue("report");
            cv.addEntry(cvEntry);
            cvEntry = new CVEntryRecord();
            cvEntry.setValue("nontrans");
            cv.addEntry(cvEntry);
            cvEntry = new CVEntryRecord();
            cvEntry.setValue("filler");
            cv.addEntry(cvEntry);
            this.controlledVocabularies.put(SECTION_TYPE_CV, cv);
            cv = new CVRecord(TURN_MODE_CV);
            cv.setDescription("All values that are allowed for Transcriber Turn.mode attribute");
            cvEntry = new CVEntryRecord();
            cvEntry.setValue("spontaneous");
            cv.addEntry(cvEntry);
            cvEntry = new CVEntryRecord();
            cvEntry.setValue("planned");
            cv.addEntry(cvEntry);
            this.controlledVocabularies.put(TURN_MODE_CV, cv);
            cv = new CVRecord(TURN_FIDELITY_CV);
            cv.setDescription("All values that are allowed for Transcriber Turn.fidelity attribute");
            cvEntry = new CVEntryRecord();
            cvEntry.setValue("high");
            cv.addEntry(cvEntry);
            cvEntry = new CVEntryRecord();
            cvEntry.setValue("medium");
            cv.addEntry(cvEntry);
            cvEntry = new CVEntryRecord();
            cvEntry.setValue("low");
            cv.addEntry(cvEntry);
            this.controlledVocabularies.put(TURN_FIDELITY_CV, cv);
            cv = new CVRecord(TURN_CHANNEL_CV);
            cv.setDescription("All values that are allowed for Transcriber Turn.channel attribute");
            cvEntry = new CVEntryRecord();
            cvEntry.setValue("telephone");
            cv.addEntry(cvEntry);
            cvEntry = new CVEntryRecord();
            cvEntry.setValue("studio");
            cv.addEntry(cvEntry);
            this.controlledVocabularies.put(TURN_CHANNEL_CV, cv);
        }
        return this.controlledVocabularies;
    }

    @Override
    public List<String> getTierNames(String fileName) {
        this.parse(fileName);
        HashSet<String> tierNames = new HashSet<String>(this.annotRecordToTierMap.values());
        return new ArrayList<String>(tierNames);
    }

    @Override
    public String getParticipantOf(String tierName, String fileName) {
        this.parse(fileName);
        String part = "";
        if (!tierName.equals(SECTION_TIER_NAME) && !tierName.equals(TURN_TIER_NAME)) {
            part = tierName;
        }
        return part;
    }

    @Override
    public String getLinguisticTypeIDOf(String tierName, String fileName) {
        this.parse(fileName);
        String lType = UTTERANCE_TYPE;
        if (tierName.equals(SECTION_TIER_NAME)) {
            lType = SECTION_TYPE;
        } else if (tierName.equals(TURN_TIER_NAME)) {
            lType = TURN_TYPE;
        } else if (tierName.equals(MODE_TIER_NAME)) {
            lType = MODE_TYPE;
        } else if (tierName.equals(FIDELITY_TIER_NAME)) {
            lType = FIDELITY_TYPE;
        } else if (tierName.equals(CHANNEL_TIER_NAME)) {
            lType = CHANNEL_TYPE;
        } else if (tierName.equals(BACKGROUND_TIER_NAME)) {
            lType = BACKGROUND_TYPE;
        } else if (tierName.equals(COMMENT_TIER_NAME)) {
            lType = COMMENT_TYPE;
        }
        return lType;
    }

    @Override
    public String getParentNameOf(String tierName, String fileName) {
        this.parse(fileName);
        if (tierName.equals(TURN_TIER_NAME)) {
            return SECTION_TIER_NAME;
        }
        if (tierName.equals(MODE_TIER_NAME)) {
            return TURN_TIER_NAME;
        }
        if (tierName.equals(FIDELITY_TIER_NAME)) {
            return TURN_TIER_NAME;
        }
        if (tierName.equals(CHANNEL_TIER_NAME)) {
            return TURN_TIER_NAME;
        }
        return "";
    }

    @Override
    public List<AnnotationRecord> getAnnotationsOf(String tierName, String fileName) {
        this.parse(fileName);
        ArrayList<AnnotationRecord> resultAnnotRecords = new ArrayList<AnnotationRecord>();
        for (AnnotationRecord annRec : this.annotRecordToTierMap.keySet()) {
            if (!this.annotRecordToTierMap.get(annRec).equals(tierName)) continue;
            resultAnnotRecords.add(annRec);
        }
        return resultAnnotRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(String fileName) {
        block18: {
            long start = System.currentTimeMillis();
            if (this.lastParsed.equals(fileName)) {
                return;
            }
            this.speakersHash.clear();
            this.sectionArrayList.clear();
            this.currentSpeakerContents.clear();
            this.currentSpeakerContents.put(SINGLE_TIER_NAME, "");
            this.utteranceRecords.clear();
            this.timeSlots.clear();
            this.annotRecordToTierMap.clear();
            this.commentRecords.clear();
            this.lastBackgroundRecord = null;
            this.speakersForCurrentTurn = "";
            annotationCounter = 0;
            timeSlotCounter = 0;
            this.currentSectionRecord = null;
            this.currentSpeakerId = null;
            this.currentTurnRecord = null;
            this.lastSectionRecord = null;
            this.lastSyncTime = null;
            this.lastTurnRecord = null;
            this.currentComments = "";
            this.tierNameSet.clear();
            this.topicHash.clear();
            if (this.singleSpeechTier) {
                this.currentSpeakerId = SINGLE_TIER_NAME;
                this.speakersHash.put(SINGLE_TIER_NAME, SINGLE_TIER_NAME);
            }
            this.lastParsed = fileName;
            this.currentFileName = fileName;
            try {
                this.saxParser.parse(fileName, this.transcriberHandler);
            }
            catch (SAXException e) {
                System.out.println("Parsing error: " + e.getMessage());
                File f = new File(fileName);
                if (!f.exists()) break block18;
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(f);
                    InputSource source = new InputSource(fis);
                    this.saxParser.parse(source, this.transcriberHandler);
                }
                catch (Exception ee) {
                    System.out.println("Parsing retry error: " + ee.getMessage());
                }
                finally {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                this.printErrorLocationInfo("Fatal(?) Error! " + e.getMessage());
            }
        }
        this.processSectionsAndTurns();
        this.processUtterances();
        this.processBackgrounds();
        this.processComments();
    }

    private void processSectionsAndTurns() {
        this.tierNameSet.add(SECTION_TIER_NAME);
        this.tierNameSet.add(TURN_TIER_NAME);
        for (int i = 0; i < this.sectionArrayList.size(); ++i) {
            SectionRecord sectionR = this.sectionArrayList.get(i);
            long sectionBegin = new Double(new Double(sectionR.startTime) * 1000.0).longValue();
            long sectionEnd = new Double(new Double(sectionR.endTime) * 1000.0).longValue();
            String sectionBeginSlotId = TS_PREFIX + timeSlotCounter++;
            String sectionEndSlotId = TS_PREFIX + timeSlotCounter++;
            Object value = sectionR.type;
            if (sectionR.topicId != null && !sectionR.topicId.equals("")) {
                value = (String)value + " - " + this.topicHash.get(sectionR.topicId);
            }
            this.addAnnotRecordAndTimeSlots(sectionBegin, sectionEnd, sectionBeginSlotId, sectionEndSlotId, (String)value, SECTION_TIER_NAME);
            Object turnBeginSlotId = "";
            Object turnEndSlotId = "";
            for (int j = 0; j < sectionR.turnRecords.size(); ++j) {
                TurnRecord turnR = sectionR.turnRecords.get(j);
                long turnBegin = new Double(new Double(turnR.startTime) * 1000.0).longValue();
                long turnEnd = new Double(new Double(turnR.endTime) * 1000.0).longValue();
                turnBeginSlotId = turnBegin == sectionBegin ? sectionBeginSlotId : (!((String)turnEndSlotId).equals("") ? turnEndSlotId : TS_PREFIX + timeSlotCounter++);
                turnEndSlotId = turnEnd == sectionEnd ? sectionEndSlotId : TS_PREFIX + timeSlotCounter++;
                Object speakerString = "";
                if (turnR.speakers != null) {
                    StringTokenizer tokenizer = new StringTokenizer(turnR.speakers);
                    while (tokenizer.hasMoreTokens()) {
                        speakerString = (String)speakerString + this.speakersHash.get(tokenizer.nextToken());
                        if (!tokenizer.hasMoreTokens()) continue;
                        speakerString = (String)speakerString + " + ";
                    }
                } else {
                    speakerString = "(no speaker)";
                }
                String parentId = this.addAnnotRecordAndTimeSlots(turnBegin, turnEnd, (String)turnBeginSlotId, (String)turnEndSlotId, (String)speakerString, TURN_TIER_NAME);
                if (turnR.mode != null && !turnR.mode.equals("")) {
                    this.tierNameSet.add(MODE_TIER_NAME);
                    this.addAnnotRecord(parentId, turnR.mode, MODE_TIER_NAME);
                }
                if (turnR.fidelity != null && !turnR.fidelity.equals("")) {
                    this.tierNameSet.add(FIDELITY_TIER_NAME);
                    this.addAnnotRecord(parentId, turnR.fidelity, FIDELITY_TIER_NAME);
                }
                if (turnR.channel == null || turnR.channel.equals("")) continue;
                this.tierNameSet.add(CHANNEL_TIER_NAME);
                this.addAnnotRecord(parentId, turnR.channel, CHANNEL_TIER_NAME);
            }
        }
    }

    private void processUtterances() {
        Iterator<String> speakerNameIter = this.speakersHash.values().iterator();
        while (speakerNameIter.hasNext()) {
            this.tierNameSet.add(speakerNameIter.next());
        }
        for (int i = 0; i < this.utteranceRecords.size(); ++i) {
            UtteranceRecord utteranceR = this.utteranceRecords.get(i);
            long uttBegin = new Double(new Double(utteranceR.startTime) * 1000.0).longValue();
            long uttEnd = new Double(new Double(utteranceR.endTime) * 1000.0).longValue();
            String beginSlotId = TS_PREFIX + timeSlotCounter++;
            String endSlotId = TS_PREFIX + timeSlotCounter++;
            this.addAnnotRecordAndTimeSlots(uttBegin, uttEnd, beginSlotId, endSlotId, utteranceR.text, utteranceR.speaker);
        }
    }

    private void processBackgrounds() {
        SectionRecord sectionR;
        this.tierNameSet.add(BACKGROUND_TIER_NAME);
        long bgBeginTime = 0L;
        long bgEndTime = 0L;
        for (int i = 0; i < this.backgroundArrayList.size(); ++i) {
            BackgroundRecord backgroundR = this.backgroundArrayList.get(i);
            bgEndTime = new Double(new Double(backgroundR.time) * 1000.0).longValue();
            if (this.lastBackgroundRecord != null && !this.lastBackgroundRecord.level.equals("off")) {
                bgBeginTime = new Double(new Double(this.lastBackgroundRecord.time) * 1000.0).longValue();
                String beginSlotId = TS_PREFIX + timeSlotCounter++;
                String endSlotId = TS_PREFIX + timeSlotCounter++;
                this.addAnnotRecordAndTimeSlots(bgBeginTime, bgEndTime, beginSlotId, endSlotId, this.lastBackgroundRecord.type, BACKGROUND_TIER_NAME);
            }
            this.lastBackgroundRecord = backgroundR;
        }
        if (this.lastBackgroundRecord != null && !this.lastBackgroundRecord.level.equals("off") && this.sectionArrayList.size() > 0 && (sectionR = this.sectionArrayList.get(this.sectionArrayList.size() - 1)) != null) {
            bgBeginTime = new Double(new Double(this.lastBackgroundRecord.time) * 1000.0).longValue();
            bgEndTime = new Double(new Double(sectionR.endTime) * 1000.0).longValue();
            String beginSlotId = TS_PREFIX + timeSlotCounter++;
            String endSlotId = TS_PREFIX + timeSlotCounter++;
            this.addAnnotRecordAndTimeSlots(bgBeginTime, bgEndTime, beginSlotId, endSlotId, this.lastBackgroundRecord.type, BACKGROUND_TIER_NAME);
        }
    }

    private void processComments() {
        this.tierNameSet.add(COMMENT_TIER_NAME);
        for (int i = 0; i < this.commentRecords.size(); ++i) {
            CommentRecord commentR = this.commentRecords.get(i);
            long commBegin = new Double(new Double(commentR.begin) * 1000.0).longValue();
            long commEnd = new Double(new Double(commentR.end) * 1000.0).longValue();
            String beginSlotId = TS_PREFIX + timeSlotCounter++;
            String endSlotId = TS_PREFIX + timeSlotCounter++;
            this.addAnnotRecordAndTimeSlots(commBegin, commEnd, beginSlotId, endSlotId, commentR.desc, COMMENT_TIER_NAME);
        }
    }

    private String addAnnotRecordAndTimeSlots(long begin, long end, String beginSlotId, String endSlotId, String value, String tierName) {
        this.timeSlots.put(beginSlotId, new Long(begin));
        this.timeSlots.put(endSlotId, new Long(end));
        String annId = ANN_PREFIX + annotationCounter++;
        AnnotationRecord annRec = new AnnotationRecord();
        annRec.setAnnotationId(annId);
        annRec.setAnnotationType("alignable");
        annRec.setBeginTimeSlotId(beginSlotId);
        annRec.setEndTimeSlotId(endSlotId);
        annRec.setValue(value);
        this.annotRecordToTierMap.put(annRec, tierName);
        return annId;
    }

    private void addAnnotRecord(String parentId, String value, String tierName) {
        AnnotationRecord annRec = new AnnotationRecord();
        annRec.setAnnotationId(ANN_PREFIX + annotationCounter++);
        annRec.setAnnotationType("reference");
        annRec.setReferredAnnotId(parentId);
        annRec.setValue(value);
        this.annotRecordToTierMap.put(annRec, tierName);
    }

    private void println(String s) {
        if (verbose) {
            System.out.println(s);
        }
    }

    private void printErrorLocationInfo(String message) {
        System.out.println(message);
        System.out.println("Exception for " + this.currentFileName);
    }

    private String pathToURLString(String path) {
        path = path.replace('\\', '/');
        int n = 0;
        while (path.charAt(0) == '/') {
            path = path.substring(1);
            ++n;
        }
        if (n == 2) {
            return "file://" + path;
        }
        return "file:///" + path;
    }

    @Override
    public void setDecoderInfo(DecoderInfo decoderInfo) {
        if (decoderInfo instanceof TranscriberDecoderInfo) {
            this.decoderInfo = (TranscriberDecoderInfo)decoderInfo;
            this.singleSpeechTier = this.decoderInfo.isSingleSpeakerTier();
        }
    }

    class PairComparator
    implements Comparator<Pair<String, Long>> {
        PairComparator() {
        }

        @Override
        public int compare(Pair<String, Long> pair0, Pair<String, Long> pair1) {
            long time1;
            long time0 = pair0.getSecond();
            if (time0 < (time1 = pair1.getSecond().longValue())) {
                return -1;
            }
            if (time0 > time1) {
                return 1;
            }
            if (time0 == time1) {
                long id1;
                long id0 = Long.parseLong(pair0.getFirst().substring(Transcriber14Parser.TS_PREFIX.length()));
                if (id0 < (id1 = Long.parseLong(pair1.getFirst().substring(Transcriber14Parser.TS_PREFIX.length())))) {
                    return -1;
                }
                if (id0 > id1) {
                    return 1;
                }
            }
            return 0;
        }
    }

    private class CommentRecord {
        public String begin;
        public String end;
        public String desc;

        public CommentRecord(String begin, String end, String desc) {
            this.begin = begin;
            this.end = end;
            this.desc = desc;
        }
    }

    private class BackgroundRecord {
        public String time;
        public String type;
        public String level;

        public BackgroundRecord(String time, String type, String level) {
            this.time = time;
            this.type = type;
            this.level = level;
        }
    }

    private class UtteranceRecord {
        public String text;
        public String speaker;
        public String startTime;
        public String endTime;
        public TurnRecord turnRecord;

        public UtteranceRecord(String text, String speaker, String startTime, String endTime, TurnRecord turnRecord) {
            this.text = text;
            this.speaker = speaker;
            this.startTime = startTime;
            this.endTime = endTime;
            this.turnRecord = turnRecord;
        }
    }

    private class TurnRecord {
        public String startTime;
        public String endTime;
        public String mode;
        public String fidelity;
        public String channel;
        public String speakers;

        public TurnRecord(String startTime, String endTime, String speakers, String mode, String fidelity, String channel) {
            this.startTime = startTime;
            this.endTime = endTime;
            this.speakers = speakers;
            this.mode = mode;
            this.fidelity = fidelity;
            this.channel = channel;
        }
    }

    private class SectionRecord {
        public String type;
        public String startTime;
        public String endTime;
        public String topicId;
        public ArrayList<TurnRecord> turnRecords;

        public SectionRecord(String type, String startTime, String endTime, String topicId) {
            this.type = type;
            this.startTime = startTime;
            this.endTime = endTime;
            this.topicId = topicId;
            this.turnRecords = new ArrayList();
        }
    }

    class Transcriber14Handler
    extends DefaultHandler {
        Transcriber14Handler() {
        }

        @Override
        public void startDocument() throws SAXException {
            Transcriber14Parser.this.parseError = false;
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startElement(String nameSpaceURI, String name, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("Trans")) {
                Transcriber14Parser.this.audioFileName = attributes.getValue("audio_filename");
                Transcriber14Parser.this.scribe = attributes.getValue("scribe");
                Transcriber14Parser.this.language = attributes.getValue("xml:lang");
                Transcriber14Parser.this.date = attributes.getValue("version_date");
            } else if (qName.equals("Speaker")) {
                String spName = attributes.getValue("name");
                if (spName == null || spName.isEmpty()) {
                    spName = attributes.getValue("id");
                }
                Transcriber14Parser.this.speakersHash.put(attributes.getValue("id"), spName);
                if (!Transcriber14Parser.this.singleSpeechTier) {
                    Transcriber14Parser.this.currentSpeakerContents.put(attributes.getValue("id"), "");
                }
            } else if (qName.equals("Section")) {
                Transcriber14Parser.this.currentSectionRecord = new SectionRecord(attributes.getValue("type"), attributes.getValue("startTime"), attributes.getValue("endTime"), attributes.getValue("topic"));
                Transcriber14Parser.this.sectionArrayList.add(Transcriber14Parser.this.currentSectionRecord);
            } else if (qName.equals("Turn")) {
                Transcriber14Parser.this.currentTurnRecord = new TurnRecord(attributes.getValue("startTime"), attributes.getValue("endTime"), attributes.getValue("speaker"), attributes.getValue("mode"), attributes.getValue("fidelity"), attributes.getValue("channel"));
                if (Transcriber14Parser.this.currentSectionRecord != null) {
                    ((Transcriber14Parser)Transcriber14Parser.this).currentSectionRecord.turnRecords.add(Transcriber14Parser.this.currentTurnRecord);
                }
                Transcriber14Parser.this.speakersForCurrentTurn = attributes.getValue("speaker");
                if (!Transcriber14Parser.this.singleSpeechTier) {
                    if (Transcriber14Parser.this.speakersForCurrentTurn != null) {
                        StringTokenizer tokenizer = new StringTokenizer(Transcriber14Parser.this.speakersForCurrentTurn);
                        if (tokenizer.hasMoreTokens()) {
                            Transcriber14Parser.this.currentSpeakerId = tokenizer.nextToken();
                        } else {
                            Transcriber14Parser.this.currentSpeakerId = "";
                        }
                    } else {
                        Transcriber14Parser.this.currentSpeakerId = Transcriber14Parser.SPEAKER_UNSPECIFIED;
                        Transcriber14Parser.this.speakersHash.put(Transcriber14Parser.SPEAKER_UNSPECIFIED, Transcriber14Parser.SPEAKER_UNSPECIFIED);
                        Transcriber14Parser.this.currentSpeakerContents.put(Transcriber14Parser.SPEAKER_UNSPECIFIED, "");
                    }
                }
            } else if (qName.equals("Sync")) {
                String time = attributes.getValue("time");
                this.storeUtterances(time);
                this.storeComments(time);
                Transcriber14Parser.this.lastSyncTime = time;
            } else if (qName.equals("Event")) {
                String desc = attributes.getValue("desc");
                String extent = attributes.getValue("extent");
                String eventString = TranscriberEvent.getEventString(desc, extent);
                if (Transcriber14Parser.this.currentSpeakerContents != null && Transcriber14Parser.this.currentSpeakerId != null) {
                    Object content = (String)Transcriber14Parser.this.currentSpeakerContents.get(Transcriber14Parser.this.currentSpeakerId);
                    if (content != null) {
                        content = (String)content + eventString;
                    }
                    Transcriber14Parser.this.currentSpeakerContents.put(Transcriber14Parser.this.currentSpeakerId, content);
                }
            } else if (qName.equals("Who")) {
                String nb = attributes.getValue("nb");
                if (Transcriber14Parser.this.singleSpeechTier) {
                    if (Transcriber14Parser.this.currentSpeakerContents != null && Transcriber14Parser.this.currentSpeakerId != null) {
                        Object content = (String)Transcriber14Parser.this.currentSpeakerContents.get(Transcriber14Parser.this.currentSpeakerId);
                        String whoStr = "(Sp:" + nb + ")";
                        content = content != null ? (((String)content).length() == 0 ? whoStr : (String)content + " " + whoStr) : whoStr;
                        Transcriber14Parser.this.currentSpeakerContents.put(Transcriber14Parser.this.currentSpeakerId, content);
                    }
                } else {
                    int num = Integer.parseInt(nb);
                    int counter = 1;
                    if (Transcriber14Parser.this.speakersForCurrentTurn != null) {
                        StringTokenizer tokenizer = new StringTokenizer(Transcriber14Parser.this.speakersForCurrentTurn);
                        while (tokenizer.hasMoreTokens()) {
                            String spkr = tokenizer.nextToken();
                            if (counter++ != num) continue;
                            Transcriber14Parser.this.currentSpeakerId = spkr;
                            break;
                        }
                    }
                }
            } else if (qName.equals(Transcriber14Parser.BACKGROUND_TIER_NAME)) {
                Transcriber14Parser.this.backgroundArrayList.add(new BackgroundRecord(attributes.getValue("time"), attributes.getValue("type"), attributes.getValue("level")));
            } else if (qName.equals("Topic")) {
                Transcriber14Parser.this.topicHash.put(attributes.getValue("id"), attributes.getValue("desc"));
            } else if (qName.equals("Comment")) {
                if (!Transcriber14Parser.this.currentComments.equals("")) {
                    Transcriber14Parser.this.currentComments = Transcriber14Parser.this.currentComments + " ";
                }
                Transcriber14Parser.this.currentComments = Transcriber14Parser.this.currentComments + ("{" + attributes.getValue("desc") + "}");
            }
        }

        private void storeUtterances(String time) {
            String spkId2 = "";
            String spkContent = "";
            for (String spkId2 : Transcriber14Parser.this.currentSpeakerContents.keySet()) {
                spkContent = (String)Transcriber14Parser.this.currentSpeakerContents.get(spkId2);
                if (spkContent.equals("")) continue;
                Transcriber14Parser.this.utteranceRecords.add(new UtteranceRecord(spkContent, (String)Transcriber14Parser.this.speakersHash.get(spkId2), Transcriber14Parser.this.lastSyncTime, time, Transcriber14Parser.this.lastTurnRecord));
            }
            for (String spkId2 : Transcriber14Parser.this.currentSpeakerContents.keySet()) {
                Transcriber14Parser.this.currentSpeakerContents.put(spkId2, "");
            }
            Transcriber14Parser.this.lastSectionRecord = Transcriber14Parser.this.currentSectionRecord;
            Transcriber14Parser.this.lastTurnRecord = Transcriber14Parser.this.currentTurnRecord;
        }

        private void storeComments(String time) {
            if (!Transcriber14Parser.this.currentComments.equals("")) {
                Transcriber14Parser.this.commentRecords.add(new CommentRecord(Transcriber14Parser.this.lastSyncTime, time, Transcriber14Parser.this.currentComments));
                Transcriber14Parser.this.currentComments = "";
            }
        }

        @Override
        public void endElement(String nameSpaceURI, String name, String qName) throws SAXException {
            if (qName.equals("Section") && Transcriber14Parser.this.currentSectionRecord != null) {
                String time = ((Transcriber14Parser)Transcriber14Parser.this).currentSectionRecord.endTime;
                this.storeUtterances(time);
                this.storeComments(time);
                Transcriber14Parser.this.lastSyncTime = time;
            }
        }

        @Override
        public void characters(char[] ch, int start, int end) throws SAXException {
            if (Transcriber14Parser.this.currentSpeakerContents == null || Transcriber14Parser.this.currentSpeakerId == null) {
                return;
            }
            Object content = (String)Transcriber14Parser.this.currentSpeakerContents.get(Transcriber14Parser.this.currentSpeakerId);
            if (content != null) {
                content = (String)content + new String(ch, start, end).trim();
            }
            Transcriber14Parser.this.currentSpeakerContents.put(Transcriber14Parser.this.currentSpeakerId, content);
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            return new InputSource(new StringReader(""));
        }
    }
}

