/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.type;

import java.util.ArrayList;
import java.util.List;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.TimeSlot;
import mpi.eudico.server.corpora.clomimpl.abstr.RefAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;

public abstract class ConstraintImpl
implements Constraint {
    protected List<Constraint> nestedConstraints = new ArrayList<Constraint>();

    @Override
    public void forceTimes(long[] segment, TierImpl forTier) {
        for (Constraint c : this.nestedConstraints) {
            c.forceTimes(segment, forTier);
        }
    }

    @Override
    public long getBeginTimeForRefAnnotation(RefAnnotation theAnnot) {
        long t = 0L;
        for (Constraint c : this.nestedConstraints) {
            t = c.getBeginTimeForRefAnnotation(theAnnot);
        }
        return t;
    }

    @Override
    public long getEndTimeForRefAnnotation(RefAnnotation theAnnot) {
        long t = 0L;
        for (Constraint c : this.nestedConstraints) {
            t = c.getEndTimeForRefAnnotation(theAnnot);
        }
        return t;
    }

    @Override
    public List<TimeSlot> getTimeSlotsForNewAnnotation(long begin, long end, TierImpl forTier) {
        List<TimeSlot> slots = new ArrayList<TimeSlot>();
        for (Constraint c : this.nestedConstraints) {
            slots = c.getTimeSlotsForNewAnnotation(begin, end, forTier);
        }
        return slots;
    }

    @Override
    public void enforceOnWholeTier(TierImpl theTier) {
    }

    @Override
    public boolean supportsInsertion() {
        return false;
    }

    @Override
    public Annotation insertBefore(Annotation beforeAnn, TierImpl theTier) {
        return null;
    }

    @Override
    public Annotation insertAfter(Annotation afterAnn, TierImpl theTier) {
        return null;
    }

    @Override
    public void detachAnnotation(Annotation theAnn, TierImpl theTier) {
    }

    @Override
    public void addConstraint(Constraint theConstraint) {
        this.nestedConstraints.add(theConstraint);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ConstraintImpl)) {
            return false;
        }
        ConstraintImpl other = (ConstraintImpl)obj;
        if (other.getStereoType() != this.getStereoType()) {
            return false;
        }
        if (this.nestedConstraints.size() != other.nestedConstraints.size()) {
            return false;
        }
        boolean allConstraintsEqual = true;
        block0: for (int i = 0; i < this.nestedConstraints.size(); ++i) {
            ConstraintImpl ci = (ConstraintImpl)this.nestedConstraints.get(i);
            for (int j = 0; j < other.nestedConstraints.size(); ++j) {
                if (ci.equals(other.nestedConstraints.get(j))) continue block0;
            }
            allConstraintsEqual = false;
            break;
        }
        return allConstraintsEqual;
    }

    @Override
    public ConstraintImpl clone() throws CloneNotSupportedException {
        ConstraintImpl copy = (ConstraintImpl)super.clone();
        ArrayList<Constraint> newList = new ArrayList<Constraint>();
        for (Constraint c : copy.nestedConstraints) {
            newList.add(c.clone());
        }
        copy.nestedConstraints = newList;
        return copy;
    }

    public static String getStereoTypeName(int typeConstant) {
        switch (typeConstant) {
            case 0: {
                return Constraint.publicStereoTypes[0];
            }
            case 1: {
                return Constraint.publicStereoTypes[1];
            }
            case 3: {
                return Constraint.publicStereoTypes[2];
            }
            case 4: {
                return Constraint.publicStereoTypes[3];
            }
        }
        return "No Constraint";
    }
}

