/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.clomimpl.type;

import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.lexicon.LexiconQueryBundle2;

public class LinguisticType {
    String typeName;
    Constraint constraints;
    boolean timeAlignable = true;
    String controlledVocabularyName;
    String dataCategory;
    LexiconQueryBundle2 lexiconQueryBundle = null;

    public LinguisticType(String theName) {
        this.typeName = theName;
    }

    public LinguisticType(String theName, LinguisticType orig) {
        this(theName);
        if (orig.hasConstraints()) {
            try {
                this.addConstraint(orig.getConstraints().clone());
            }
            catch (CloneNotSupportedException ex) {
                ex.printStackTrace();
            }
        }
        this.setTimeAlignable(orig.isTimeAlignable());
        this.setControlledVocabularyName(orig.getControlledVocabularyName());
        this.setDataCategory(orig.getDataCategory());
        if (orig.getLexiconQueryBundle() != null) {
            LexiconQueryBundle2 copyBundle = new LexiconQueryBundle2(orig.getLexiconQueryBundle());
            if (copyBundle.getLink() != null) {
                copyBundle.getLink().setSrvcClient(orig.getLexiconQueryBundle().getLink().getSrvcClient());
            }
            this.setLexiconQueryBundle(copyBundle);
        }
    }

    public String toString() {
        String stereotype = "";
        if (this.constraints != null) {
            stereotype = Constraint.stereoTypes[this.constraints.getStereoType()];
        }
        return this.typeName + ", " + this.timeAlignable + ", " + stereotype;
    }

    public String getLinguisticTypeName() {
        return this.typeName;
    }

    public void setLinguisticTypeName(String theName) {
        this.typeName = theName;
    }

    public boolean hasConstraints() {
        return this.constraints != null;
    }

    public Constraint getConstraints() {
        return this.constraints;
    }

    public void addConstraint(Constraint theConstraint) {
        if (this.constraints == null) {
            this.constraints = theConstraint;
        } else {
            this.constraints.addConstraint(theConstraint);
        }
    }

    public void removeConstraints() {
        this.constraints = null;
    }

    public boolean isTimeAlignable() {
        return this.timeAlignable;
    }

    public void setTimeAlignable(boolean isTimeAlignable) {
        this.timeAlignable = isTimeAlignable;
    }

    public boolean isUsingControlledVocabulary() {
        return this.controlledVocabularyName != null && this.controlledVocabularyName.length() != 0;
    }

    public String getControlledVocabularyName() {
        return this.controlledVocabularyName;
    }

    public void setControlledVocabularyName(String name) {
        this.controlledVocabularyName = name;
    }

    public String getDataCategory() {
        return this.dataCategory;
    }

    public void setDataCategory(String dataCategory) {
        this.dataCategory = dataCategory;
    }

    public boolean isUsingLexiconQueryBundle() {
        return this.lexiconQueryBundle != null;
    }

    public LexiconQueryBundle2 getLexiconQueryBundle() {
        return this.lexiconQueryBundle;
    }

    public void setLexiconQueryBundle(LexiconQueryBundle2 lexiconQueryBundle) {
        this.lexiconQueryBundle = lexiconQueryBundle;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LinguisticType)) {
            return false;
        }
        LinguisticType other = (LinguisticType)obj;
        if (this.typeName != null && !this.typeName.equals(other.getLinguisticTypeName())) {
            return false;
        }
        if (other.getLinguisticTypeName() != null && !other.getLinguisticTypeName().equals(this.typeName)) {
            return false;
        }
        if (this.isTimeAlignable() != other.isTimeAlignable()) {
            return false;
        }
        if (this.hasConstraints() != other.hasConstraints()) {
            return false;
        }
        if (this.hasConstraints() && !this.getConstraints().equals(other.getConstraints())) {
            return false;
        }
        if (this.isUsingControlledVocabulary()) {
            if (!other.isUsingControlledVocabulary()) {
                return false;
            }
            if (!this.controlledVocabularyName.equals(other.getControlledVocabularyName())) {
                return false;
            }
        } else if (other.isUsingControlledVocabulary()) {
            return false;
        }
        if (this.dataCategory == null ? other.getDataCategory() != null : !this.dataCategory.equals(other.getDataCategory())) {
            return false;
        }
        if (this.lexiconQueryBundle == null) {
            if (other.getLexiconQueryBundle() != null) {
                return false;
            }
        } else {
            if (other.getLexiconQueryBundle() == null) {
                return false;
            }
            if (!this.lexiconQueryBundle.equals(other.getLexiconQueryBundle())) {
                return false;
            }
        }
        return true;
    }

    public static enum PropKey {
        ID,
        NAME,
        CONSTRAINT,
        CV_NAME,
        DC,
        LEX_BUNDLE,
        LEX_LINK,
        LEX_FIELD;

    }
}

