/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.server.corpora.lexicon;

import mpi.eudico.server.corpora.lexicon.LexicalEntryFieldIdentification;
import mpi.eudico.server.corpora.lexicon.LexiconIdentification;
import mpi.eudico.server.corpora.lexicon.LexiconLink;

public class LexiconQueryBundle2 {
    private LexicalEntryFieldIdentification fldId;
    private LexiconLink link;

    public LexiconQueryBundle2(LexiconLink link, LexicalEntryFieldIdentification lexicalEntryFieldIdentification) {
        this.link = link;
        this.fldId = lexicalEntryFieldIdentification;
    }

    public LexiconQueryBundle2(LexiconQueryBundle2 otherBundle) {
        LexicalEntryFieldIdentification otherLEFI;
        if (otherBundle == null) {
            throw new NullPointerException("The Lexicon Bundle is null");
        }
        LexiconLink otherLL = otherBundle.getLink();
        if (otherLL != null) {
            LexiconIdentification otherLexId = otherLL.getLexId();
            LexiconIdentification nextLexId = null;
            if (otherLexId != null) {
                nextLexId = new LexiconIdentification(otherLexId);
            }
            this.link = new LexiconLink(otherLL.getName(), otherLL.getLexSrvcClntType(), otherLL.getUrl(), null, nextLexId);
        }
        if ((otherLEFI = otherBundle.getFldId()) != null) {
            this.fldId = new LexicalEntryFieldIdentification(otherLEFI.getId(), otherLEFI.getName());
            this.fldId.setDescription(otherLEFI.getDescription());
        }
    }

    public LexicalEntryFieldIdentification getFldId() {
        return this.fldId;
    }

    public String getLinkName() {
        if (this.link != null) {
            return this.link.getName();
        }
        return null;
    }

    public LexiconLink getLink() {
        return this.link;
    }

    public String toString() {
        if (this.link != null) {
            return this.link.getName();
        }
        return "No Name";
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof LexiconQueryBundle2)) {
            return false;
        }
        LexiconQueryBundle2 olqb = (LexiconQueryBundle2)other;
        boolean sameField = false;
        boolean sameLexLink = false;
        if (this.fldId != null && olqb.getFldId() != null) {
            boolean bl = sameField = this.fldId.compareTo(olqb.getFldId()) == 0;
        }
        if (this.link != null) {
            sameLexLink = this.link.compareNameAndLexId(olqb.getLink()) == 0;
        } else if (this.link == null && olqb.getLink() == null) {
            sameLexLink = true;
        }
        return sameField && sameLexLink;
    }
}

