/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.util;

import java.awt.Color;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import mpi.eudico.server.corpora.clom.ExternalReference;
import mpi.eudico.util.BasicControlledVocabulary;

public class CVEntry
implements Comparable<CVEntry>,
Serializable {
    private ValueDesc[] contents;
    private ExternalReference externalRef;
    private int shortcutKeyCode = -1;
    private Color prefColor;
    protected BasicControlledVocabulary parent;
    private String id;

    private void init(BasicControlledVocabulary parent) {
        this.parent = parent;
        int numLangs = parent.getNumberOfLanguages();
        this.contents = new ValueDesc[numLangs];
        this.id = "";
        for (int i = 0; i < numLangs; ++i) {
            this.contents[i] = new ValueDesc("", null);
        }
    }

    public CVEntry(BasicControlledVocabulary parent) {
        this.init(parent);
    }

    @Deprecated
    public CVEntry(BasicControlledVocabulary parent, String value, String description) {
        this(parent, parent.getDefaultLanguageIndex(), value, description);
    }

    public CVEntry(BasicControlledVocabulary parent, int index, String value, String description) {
        if (value == null) {
            throw new IllegalArgumentException("The value can not be null.");
        }
        this.init(parent);
        this.ensureCapacity(index + 1);
        this.contents[index] = new ValueDesc(value, description);
    }

    public CVEntry(CVEntry origEntry) {
        this(origEntry.getParent(), origEntry);
    }

    public CVEntry(BasicControlledVocabulary newParent, CVEntry origEntry) {
        if (origEntry == null) {
            throw new IllegalArgumentException("The CVEntry origEntry can not be null.");
        }
        this.parent = newParent;
        int numLangs = origEntry.contents.length;
        this.contents = new ValueDesc[numLangs];
        for (int i = 0; i < numLangs; ++i) {
            this.contents[i] = origEntry.contents[i].clone();
        }
        this.externalRef = origEntry.getExternalRef();
        this.prefColor = origEntry.getPrefColor();
        this.shortcutKeyCode = origEntry.getShortcutKeyCode();
        this.id = "";
        this.setId(origEntry.id);
    }

    public CVEntry(CVEntry origEntry, int index, String value, String description) {
        this(origEntry.getParent(), origEntry);
        this.ensureCapacity(index + 1);
        this.contents[index] = new ValueDesc(value, description);
    }

    public CVEntry cloneExceptValues(BasicControlledVocabulary newParent) {
        CVEntry newEntry = new CVEntry(newParent);
        newEntry.setId(this.getId());
        newEntry.setExternalRef(this.getExternalRef());
        newEntry.setPrefColor(this.getPrefColor());
        newEntry.setShortcutKeyCode(this.getShortcutKeyCode());
        return newEntry;
    }

    public BasicControlledVocabulary getParent() {
        return this.parent;
    }

    private void ensureCapacity(int size) {
        assert (size <= this.parent.getNumberOfLanguages());
        if (size <= this.contents.length) {
            return;
        }
        ValueDesc[] newContents = Arrays.copyOf(this.contents, size);
        for (int i = this.contents.length; i < size; ++i) {
            newContents[i] = new ValueDesc("", null);
        }
        this.contents = newContents;
    }

    public String getValue(int index) {
        if (index < this.contents.length) {
            return this.contents[index].getValue();
        }
        return "";
    }

    public void setValue(int index, String s) {
        this.ensureCapacity(index + 1);
        this.contents[index].setValue(s);
    }

    @Deprecated
    public String getValue() {
        return this.getValue(this.parent.getDefaultLanguageIndex());
    }

    @Deprecated
    public void setValue(String s) {
        this.setValue(this.parent.getDefaultLanguageIndex(), s);
    }

    public String getDescription(int index) {
        if (index < this.contents.length) {
            return this.contents[index].getDescription();
        }
        return null;
    }

    public void setDescription(int index, String description) {
        this.ensureCapacity(index + 1);
        this.contents[index].setDescription(description);
    }

    @Deprecated
    public String getDescription() {
        return this.getDescription(this.parent.getDefaultLanguageIndex());
    }

    @Deprecated
    public void setDescription(String description) {
        this.setDescription(this.parent.getDefaultLanguageIndex(), description);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        if (id == null) {
            id = "";
        }
        if (!this.id.isEmpty()) {
            this.parent.removeId(this);
        }
        this.id = id;
        this.parent.addId(this);
    }

    protected void internalSetId(String id) {
        this.id = id;
    }

    public ExternalReference getExternalRef() {
        return this.externalRef;
    }

    public void setExternalRef(ExternalReference externalRef) {
        this.externalRef = externalRef;
    }

    public int getShortcutKeyCode() {
        return this.shortcutKeyCode;
    }

    public void setShortcutKeyCode(int shortcutKeyCode) {
        this.shortcutKeyCode = shortcutKeyCode;
    }

    public Color getPrefColor() {
        return this.prefColor;
    }

    public void setPrefColor(Color prefColor) {
        this.prefColor = prefColor;
    }

    @Override
    public int compareTo(CVEntry other) {
        if (this == other) {
            return 0;
        }
        int upb = Math.min(this.contents.length, other.contents.length);
        for (int i = 0; i < upb; ++i) {
            ValueDesc vd1 = this.contents[i];
            ValueDesc vd2 = other.contents[i];
            int compare = vd1.compareTo(vd2);
            if (compare == 0) continue;
            return compare;
        }
        int compare = this.contents.length - other.contents.length;
        return compare;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CVEntry)) {
            return false;
        }
        CVEntry other = (CVEntry)obj;
        if (this == other) {
            return true;
        }
        if (this.compareTo(other) == 0) {
            if (this.externalRef == null) {
                return this.externalRef == other.getExternalRef();
            }
            return this.externalRef.equals(other.getExternalRef());
        }
        return false;
    }

    public int hashCode() {
        return this.contents[0].value.hashCode();
    }

    public String toString() {
        return this.getValue(this.parent.getDefaultLanguageIndex());
    }

    protected void removeLanguage(int index) {
        int newSize = this.contents.length - 1;
        if (index >= 0 && index <= newSize) {
            ValueDesc[] newContents = new ValueDesc[newSize];
            if (index > 0) {
                System.arraycopy(this.contents, 0, newContents, 0, index);
            }
            if (index < newSize) {
                System.arraycopy(this.contents, index + 1, newContents, index, newSize - index);
            }
            this.contents = newContents;
        }
    }

    public static class CVELangComparator
    implements Comparator<CVEntry> {
        private int index;

        CVELangComparator(int index) {
            this.index = index;
        }

        @Override
        public int compare(CVEntry lhs, CVEntry rhs) {
            return lhs.contents[this.index].compareTo(rhs.contents[this.index]);
        }
    }

    private static class ValueDesc
    implements Comparable<ValueDesc>,
    Cloneable {
        private String value;
        private String description;

        ValueDesc(String value, String description) {
            this.value = value;
            this.description = description;
        }

        public ValueDesc clone() {
            try {
                return (ValueDesc)super.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
                return new ValueDesc(this.value, this.description);
            }
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        @Override
        public int compareTo(ValueDesc o) {
            int compare = this.value.compareTo(o.value);
            if (compare != 0) {
                return compare;
            }
            String d1 = this.description == null ? "" : this.description;
            String d2 = o.description == null ? "" : o.description;
            return d1.compareTo(d2);
        }
    }
}

