/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.util;

import mpi.eudico.server.corpora.clom.ExternalReference;
import mpi.eudico.util.BasicControlledVocabulary;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.ExternalCVEntry;

public class ExternalCV
extends ControlledVocabulary {
    private ExternalReference externalRef;
    private boolean isLoadedFromURL;
    private boolean isLoadedFromCache;

    public ExternalCV(String name) {
        super(name);
    }

    public ExternalCV(BasicControlledVocabulary cv) {
        super(cv.getName());
        this.cloneStructure(cv);
        this.cloneEntries(cv);
    }

    public ExternalCV(ExternalCV ecv) {
        super(ecv.getName());
        this.cloneStructure(ecv);
        this.externalRef = ecv.getExternalRef();
        if (this.externalRef != null) {
            try {
                this.externalRef = this.externalRef.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        this.isLoadedFromURL = ecv.isLoadedFromURL;
        this.isLoadedFromCache = ecv.isLoadedFromCache;
        this.cloneEntries(ecv);
    }

    public ExternalReference getExternalRef() {
        return this.externalRef;
    }

    public void setExternalRef(ExternalReference externalRef) {
        if (this.externalRef == null) {
            this.externalRef = externalRef;
        } else if (!this.externalRef.equals(externalRef)) {
            this.externalRef = externalRef;
            super.handleModified();
        }
    }

    @Override
    protected void handleModified() {
    }

    public boolean isLoadedFromURL() {
        return this.isLoadedFromURL;
    }

    public void setLoadedFromURL(boolean isLoadedFromURL) {
        this.isLoadedFromURL = isLoadedFromURL;
    }

    public boolean isLoadedFromCache() {
        return this.isLoadedFromCache;
    }

    public void setLoadedFromCache(boolean isLoadedFromCache) {
        this.isLoadedFromCache = isLoadedFromCache;
    }

    @Override
    public ExternalCV clone() {
        return new ExternalCV(this);
    }

    @Override
    public void cloneEntries(BasicControlledVocabulary orig) {
        this.initMode = true;
        this.entries.clear();
        for (CVEntry e : orig) {
            this.addEntry(new ExternalCVEntry((BasicControlledVocabulary)this, e));
        }
        this.initMode = false;
    }

    public void cloneEntries(ExternalCV orig) {
        this.initMode = true;
        this.entries.clear();
        for (CVEntry e : orig) {
            this.addEntry(new ExternalCVEntry((BasicControlledVocabulary)this, (ExternalCVEntry)e));
        }
        this.initMode = false;
    }
}

