/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class TimeFormatter {
    static final int HOUR_MS = 3600000;
    static final int MIN_MS = 60000;
    static final int SEC_MS = 1000;
    private static final DecimalFormat twoDigits = new DecimalFormat("00");
    private static final DecimalFormat threeDigits = new DecimalFormat("000");
    private static final DecimalFormat secondsMillis = new DecimalFormat("#0.000", new DecimalFormatSymbols(Locale.US));

    public static long toMilliSeconds(String timeString) {
        try {
            int mark1;
            boolean negative;
            String hourString = new String("0.0");
            String minuteString = new String("0.0");
            String secondString = new String("0.0");
            boolean bl = negative = timeString.charAt(0) == '-';
            if (negative) {
                timeString = timeString.substring(1);
            }
            if ((mark1 = timeString.indexOf(58, 0)) == -1) {
                if (timeString.indexOf(46) < 0) {
                    int comma = timeString.indexOf(44);
                    if (comma < 0) {
                        if (negative) {
                            return -Long.parseLong(timeString);
                        }
                        return Long.parseLong(timeString);
                    }
                    secondString = timeString.replace(',', '.');
                } else {
                    secondString = timeString;
                }
            } else {
                int mark2 = timeString.indexOf(58, mark1 + 1);
                if (mark2 == -1) {
                    minuteString = timeString.substring(0, mark1);
                    secondString = timeString.substring(mark1 + 1, timeString.length());
                } else {
                    hourString = timeString.substring(0, mark1);
                    minuteString = timeString.substring(mark1 + 1, mark2);
                    secondString = timeString.substring(mark2 + 1, timeString.length());
                }
            }
            double hours = Double.parseDouble(hourString);
            double minutes = Double.parseDouble(minuteString);
            double seconds = Double.parseDouble(secondString);
            if (negative) {
                return (long)(-(1000.0 * (hours * 3600.0 + minutes * 60.0 + seconds)));
            }
            return (long)(1000.0 * (hours * 3600.0 + minutes * 60.0 + seconds));
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public static long toMilliSeconds(String timeString, TIME_FORMAT format) {
        if (format == null) {
            return TimeFormatter.toMilliSeconds(timeString);
        }
        try {
            boolean negative;
            boolean bl = negative = timeString.charAt(0) == '-';
            if (negative) {
                timeString = timeString.substring(1);
            }
            long t = -1L;
            switch (format) {
                case MS: {
                    t = Long.parseLong(timeString);
                    break;
                }
                case SSMS: {
                    t = (long)(1000.0 * Double.parseDouble(timeString));
                    break;
                }
                case HHMMSSMS: {
                    String[] hparts = timeString.split(":");
                    t = (long)(1000.0 * Double.parseDouble(hparts[hparts.length - 1]));
                    if (hparts.length == 3) {
                        t += 60000L * Long.parseLong(hparts[1]);
                        t += 3600000L * Long.parseLong(hparts[0]);
                        break;
                    }
                    if (hparts.length != 2) break;
                    t += 60000L * Long.parseLong(hparts[0]);
                    break;
                }
            }
            if (negative) {
                return -t;
            }
            return t;
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1L;
    }

    public static String toString(long time) {
        long hours = time / 3600000L;
        String hourString = twoDigits.format(hours);
        long minutes = (time - 3600000L * hours) / 60000L;
        String minuteString = twoDigits.format(minutes);
        long seconds = (time - 3600000L * hours - 60000L * minutes) / 1000L;
        String secondString = twoDigits.format(seconds);
        long millis = time - 3600000L * hours - 60000L * minutes - 1000L * seconds;
        String milliString = threeDigits.format(millis);
        return hourString + ":" + minuteString + ":" + secondString + "." + milliString;
    }

    public static String toSSMSString(long time) {
        double dd = (double)time / 1000.0;
        return secondsMillis.format(dd);
    }

    public static String toTimecodePAL(long time) {
        long hours = time / 3600000L;
        String hourString = twoDigits.format(hours);
        long minutes = (time - 3600000L * hours) / 60000L;
        String minuteString = twoDigits.format(minutes);
        long seconds = (time - 3600000L * hours - 60000L * minutes) / 1000L;
        String secondString = twoDigits.format(seconds);
        long frames = (time - 3600000L * hours - 60000L * minutes - 1000L * seconds) / 40L;
        String milliString = twoDigits.format(frames);
        return hourString + ":" + minuteString + ":" + secondString + ":" + milliString;
    }

    public static String toTimecodePAL50(long time) {
        long hours = time / 3600000L;
        String hourString = twoDigits.format(hours);
        long minutes = (time - 3600000L * hours) / 60000L;
        String minuteString = twoDigits.format(minutes);
        long seconds = (time - 3600000L * hours - 60000L * minutes) / 1000L;
        String secondString = twoDigits.format(seconds);
        long frames = (time - 3600000L * hours - 60000L * minutes - 1000L * seconds) / 20L;
        String milliString = twoDigits.format(frames);
        return hourString + ":" + minuteString + ":" + secondString + ":" + milliString;
    }

    public static String toFrameNumberPAL(long time) {
        return String.valueOf(time / 40L);
    }

    public static String toFrameNumberPAL50(long time) {
        return String.valueOf(time / 20L);
    }

    public static String toTimecodeNTSC(long time) {
        int frameNumber = (int)((double)((float)time / 1000.0f) * 29.97);
        int numTenMin = frameNumber / 17982;
        int hours = numTenMin / 6;
        numTenMin -= 6 * hours;
        int numMin = frameNumber % 17982;
        int min = numMin / 1800;
        int rest = numMin - min * 1800;
        int sec = rest / 30;
        int fr = rest - sec * 30;
        if ((fr += min * 2) > 29) {
            fr -= 30;
            if (++sec > 59) {
                sec = 0;
                ++min;
                fr += 2;
            }
        }
        return twoDigits.format(hours) + ":" + twoDigits.format(numTenMin * 10 + min) + ":" + twoDigits.format(sec) + ":" + twoDigits.format(fr);
    }

    public static String toFrameNumberNTSC(long time) {
        int frameNumber = (int)((double)((float)time / 1000.0f) * 29.97);
        return String.valueOf(frameNumber);
    }

    public static String toFrameNumber(long timeMs, double frameDurationMs) {
        return String.valueOf((int)((double)timeMs / frameDurationMs));
    }

    public static String toTimeCode(long timeMs, double frameDurationMs) {
        int maxFrameNum;
        double framesRemainTimeMs;
        double secRemainTimeMs;
        double modRemain = (double)timeMs % frameDurationMs;
        double frameBeginTime = (double)timeMs - modRemain;
        int numHours = 0;
        int numMinutes = 0;
        int numSeconds = 0;
        int numFrames = 0;
        numHours = (int)(frameBeginTime / 3600000.0);
        double minuteRemainTimeMs = frameBeginTime - (double)(numHours * 3600000);
        numMinutes = (int)(minuteRemainTimeMs / 60000.0);
        if (numMinutes == 60) {
            --numMinutes;
            ++numHours;
        }
        if ((numSeconds = (int)((secRemainTimeMs = minuteRemainTimeMs - (double)(numMinutes * 60000)) / 1000.0)) == 60) {
            --numSeconds;
            if (++numMinutes == 60) {
                --numMinutes;
                ++numHours;
            }
        }
        if ((numFrames = (int)((framesRemainTimeMs = secRemainTimeMs - (double)(numSeconds * 1000)) / frameDurationMs)) > (maxFrameNum = (int)Math.ceil(1000.0 / frameDurationMs) - 1) && ++numSeconds == 60) {
            --numSeconds;
            if (++numMinutes == 60) {
                --numMinutes;
                ++numHours;
            }
        }
        return String.format("%s:%s:%s:%s", twoDigits.format(numHours), twoDigits.format(numMinutes), twoDigits.format(numSeconds), twoDigits.format(numFrames));
    }

    public static enum TIME_FORMAT {
        HHMMSSMS,
        SSMS,
        MS,
        HHMMSSFF;

    }
}

