/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.util.multilangcv;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mpi.eudico.util.multilangcv.LangInfo;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class LanguageCollection {
    private static final String sourceURL = "http://catalog.clarin.eu/ds/ComponentRegistry/rest/registry/components/clarin.eu:cr1:c_1271859438110";
    private static String localCacheFolder;
    private static final long REFRESH_TIME = 8640000L;
    private static SoftReference<List<LangInfo>> languages;

    public static List<LangInfo> getLanguages() {
        List<LangInfo> langs;
        if (languages != null && (langs = languages.get()) != null) {
            return langs;
        }
        try {
            return LanguageCollection.getLanguagesFromCacheFile();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public static LangInfo getLanguageInfo(String id) {
        List<LangInfo> langs = LanguageCollection.getLanguages();
        LangInfo info = null;
        for (int i = 0; i < langs.size(); ++i) {
            info = langs.get(i);
            if (!info.getId().equals(id) && !info.getLongId().equals(id)) continue;
            return info;
        }
        return null;
    }

    private static synchronized List<LangInfo> getLanguagesFromCacheFile() throws IOException {
        LanguageHandler lh;
        boolean successFromServer;
        String cacheProp;
        List<LangInfo> langs;
        if (languages != null && (langs = languages.get()) != null) {
            return langs;
        }
        Object cacheFileName = "";
        cacheFileName = localCacheFolder != null ? localCacheFolder + File.separator + "ISO-639-3-Languages.xml" : ((cacheProp = System.getProperty("LanguagesCacheFolder")) != null ? cacheProp + File.separator + "ISO-639-3-Languages.xml" : System.getProperty("user.home") + File.separator + "ISO-639-3-Languages.xml");
        File cacheFile = new File((String)cacheFileName);
        if (!(cacheFile.exists() && System.currentTimeMillis() - cacheFile.lastModified() <= 8640000000L || (successFromServer = LanguageCollection.getLanguagesFromServer(sourceURL, (String)cacheFileName)) || cacheFile.exists())) {
            return null;
        }
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            reader.setFeature("http://xml.org/sax/features/namespaces", false);
            reader.setFeature("http://xml.org/sax/features/validation", false);
            reader.setFeature("http://apache.org/xml/features/validation/schema", false);
            reader.setFeature("http://apache.org/xml/features/validation/dynamic", false);
            lh = new LanguageHandler();
            reader.setContentHandler(lh);
            reader.setErrorHandler(lh);
            reader.parse((String)cacheFileName);
        }
        catch (SAXException se) {
            se.printStackTrace();
            throw new IOException(se.getMessage());
        }
        langs = lh.getLanguages();
        Collections.sort(langs, LangInfo.getLabelComparator());
        languages = new SoftReference<List<LangInfo>>(langs);
        return langs;
    }

    public static boolean getLanguagesFromServer(String sourceURL, String cacheFileName) {
        String newFileName = cacheFileName + ".new";
        File newFile = new File(newFileName);
        boolean ok = false;
        try {
            HttpURLConnection conn = LanguageCollection.getConnection(new URL(sourceURL));
            int respCode = conn.getResponseCode();
            Object cont = conn.getContent();
            if (respCode == 200 && cont instanceof InputStream) {
                InputStream is = (InputStream)cont;
                LanguageCollection.copy(is, newFile);
                ok = true;
            }
            conn.disconnect();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!ok || newFile.length() < 100L) {
            return false;
        }
        File file = new File(cacheFileName);
        if (file.exists() && newFile.length() < file.length() * 2L / 3L) {
            return false;
        }
        return LanguageCollection.safeRename(newFile, file, new File(cacheFileName + ".bak"));
    }

    private static HttpURLConnection getConnection(URL url) {
        if (url == null) {
            return null;
        }
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setDefaultUseCaches(true);
            conn.setRequestMethod("GET");
            conn.connect();
            return conn;
        }
        catch (IOException iOException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return conn;
    }

    private static void copy(InputStream in, File file) {
        try {
            int len;
            FileOutputStream out = new FileOutputStream(file);
            byte[] buf = new byte[4096];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((OutputStream)out).close();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean safeRename(File newFile, File curFile, File bakFile) {
        if (curFile.exists()) {
            if (bakFile.exists() && !bakFile.delete()) {
                return false;
            }
            if (!curFile.renameTo(bakFile)) {
                return false;
            }
        }
        return newFile.renameTo(curFile);
    }

    public static LangInfo tryParse(String selection) {
        String id = null;
        String longId = null;
        String label = "";
        String[] parts = selection.split(" - ");
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = parts[i].trim();
        }
        if (parts.length == 3) {
            String idPattern1 = "^[a-z][a-z0-9]{0,4}$";
            String idPattern2 = "^[a-zA-Z][a-zA-Z0-9]{0,4}$";
            if (parts[1].matches("^[a-z][a-z0-9]{0,4}$")) {
                label = parts[0];
                id = parts[1];
                longId = parts[2];
            } else if (parts[1].matches("^[a-zA-Z][a-zA-Z0-9]{0,4}$")) {
                label = parts[0];
                id = parts[1].toLowerCase();
                longId = parts[2];
            }
        }
        if (id != null && longId != null) {
            if (label.isEmpty()) {
                label = id;
            }
            return new LangInfo(id, longId, label);
        }
        return null;
    }

    public static LangInfo validate(LangInfo selectedNewLanguage) {
        if (selectedNewLanguage == null) {
            return null;
        }
        String id = selectedNewLanguage.getId();
        String longId = selectedNewLanguage.getLongId();
        for (LangInfo li : LanguageCollection.getLanguages()) {
            if (li.getId().equals(id)) {
                if (li.getLongId().equals(longId)) {
                    return selectedNewLanguage;
                }
                return null;
            }
            if (!li.getLongId().equals(longId)) continue;
            return null;
        }
        return selectedNewLanguage;
    }

    public static String getLocalCacheFolder() {
        return localCacheFolder;
    }

    public static void setLocalCacheFolder(String localCacheFolder) {
        LanguageCollection.localCacheFolder = localCacheFolder;
    }

    static class LanguageHandler
    extends DefaultHandler
    implements ContentHandler {
        private String conceptLink;
        private String appInfo;
        private String content;
        private List<LangInfo> languages = new ArrayList<LangInfo>();

        LanguageHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            this.content = "";
            if (qName.equals("item")) {
                this.conceptLink = atts.getValue("ConceptLink");
                this.appInfo = atts.getValue("AppInfo");
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("item")) {
                LangInfo li = new LangInfo(this.content.trim(), this.conceptLink, this.appInfo);
                this.languages.add(li);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.content = this.content + new String(ch, start, length);
        }

        public List<LangInfo> getLanguages() {
            return this.languages;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            System.out.println("Error: " + exception.getMessage());
            System.out.println("System id: " + exception.getSystemId());
            System.out.println("Public id: " + exception.getPublicId());
            System.out.println("Line: " + exception.getLineNumber());
            System.out.println("Column: " + exception.getColumnNumber());
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            System.out.println("FatalError: " + exception.getMessage());
            throw exception;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            System.out.println("Warning: " + exception.getMessage());
        }
    }
}

