/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.util.multilangcv;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import mpi.eudico.util.IoUtil;
import mpi.eudico.util.multilangcv.LangInfo;
import mpi.eudico.util.multilangcv.RecentLanguageListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class RecentLanguages {
    private List<LangInfo> recentLanguages;
    private List<WeakReference<RecentLanguageListener>> listeners;
    private static RecentLanguages instance;
    private final int UNIQUE = Integer.MIN_VALUE;

    public static RecentLanguages getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new RecentLanguages();
        return instance;
    }

    private RecentLanguages() {
        this.recentLanguages = new ArrayList<LangInfo>();
    }

    public List<LangInfo> getRecentLanguages() {
        return Collections.unmodifiableList(this.recentLanguages);
    }

    public boolean canAddLanguage(LangInfo newLI) {
        return this.findConflictingLanguage(newLI, -1) < 0;
    }

    private int findConflictingLanguage(LangInfo newLI, int skipIndex) {
        int size = this.recentLanguages.size();
        for (int i = 0; i < size; ++i) {
            if (i == skipIndex) continue;
            LangInfo li = this.recentLanguages.get(i);
            if (li == newLI || li.getLongId().equals(newLI.getLongId())) {
                return li.getId().equals(newLI.getId()) ? -i - 1 : i;
            }
            if (!li.getId().equals(newLI.getId())) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    public int addRecentLanguage(LangInfo newLI) {
        int index = this.findConflictingLanguage(newLI, -1);
        if (index == Integer.MIN_VALUE) {
            index = this.recentLanguages.size();
            this.recentLanguages.add(newLI);
            this.notifyListenersAdded(index, newLI);
            return index;
        }
        if (index >= 0) {
            return -1;
        }
        return -index - 1;
    }

    public void removeRecentLanguage(int index) {
        if (index >= 0 && index < this.recentLanguages.size()) {
            this.recentLanguages.remove(index);
            this.notifyListenersChanged(index, null);
        }
    }

    public boolean changeRecentLanguage(int index, LangInfo newLI) {
        if (index >= 0 && index < this.recentLanguages.size()) {
            if (this.findConflictingLanguage(newLI, index) != Integer.MIN_VALUE) {
                return false;
            }
            this.recentLanguages.set(index, newLI);
            this.notifyListenersChanged(index, newLI);
            return true;
        }
        return false;
    }

    public LangInfo getLanguageInfo(String id) {
        for (LangInfo li : this.recentLanguages) {
            if (li.getLongId().equals(id)) {
                return li;
            }
            if (!li.getId().equals(id)) continue;
            return li;
        }
        return null;
    }

    public void loadRecentLanguages(String filePath) throws IOException {
        if (filePath == null) {
            throw new IOException("Cannot load languages, the file location is null");
        }
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            reader.setFeature("http://xml.org/sax/features/namespaces", false);
            reader.setFeature("http://xml.org/sax/features/validation", false);
            reader.setFeature("http://apache.org/xml/features/validation/schema", false);
            reader.setFeature("http://apache.org/xml/features/validation/dynamic", false);
            RecentLanguagesHandler rlh = new RecentLanguagesHandler();
            reader.setContentHandler(rlh);
            reader.setErrorHandler(rlh);
            reader.parse(filePath);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    public void saveRecentLanguages(String filePath) throws IOException {
        if (filePath == null) {
            throw new IOException("Cannot save languages, the file location is null");
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            Element root = doc.createElement("RECENT_LANGUAGES");
            doc.appendChild(root);
            for (LangInfo li : this.recentLanguages) {
                Element l = doc.createElement("LANGUAGE");
                l.setAttribute("LANG_ID", li.getId());
                l.setAttribute("LANG_DEF", li.getLongId());
                l.setAttribute("LANG_LABEL", li.getLabel());
                root.appendChild(l);
            }
            IoUtil.writeEncodedFile("UTF-8", filePath, doc.getDocumentElement());
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void addRecentLanguageListener(RecentLanguageListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<WeakReference<RecentLanguageListener>>(1);
        }
        this.listeners.add(new WeakReference<RecentLanguageListener>(listener));
    }

    public void removeRecentLanguageListener(RecentLanguageListener listener) {
        if (this.listeners != null) {
            Iterator<WeakReference<RecentLanguageListener>> iter = this.listeners.iterator();
            while (iter.hasNext()) {
                WeakReference<RecentLanguageListener> ref = iter.next();
                if (ref.get() != listener && ref.get() != null) continue;
                iter.remove();
            }
        }
    }

    private void notifyListenersAdded(int freeIndex, LangInfo newLI) {
        if (this.listeners != null) {
            Iterator<WeakReference<RecentLanguageListener>> iter = this.listeners.iterator();
            while (iter.hasNext()) {
                WeakReference<RecentLanguageListener> ref = iter.next();
                RecentLanguageListener listener = (RecentLanguageListener)ref.get();
                if (listener == null) {
                    iter.remove();
                    continue;
                }
                listener.recentLanguageAdded(freeIndex, newLI);
            }
        }
    }

    private void notifyListenersChanged(int freeIndex, LangInfo newLI) {
        if (this.listeners != null) {
            Iterator<WeakReference<RecentLanguageListener>> iter = this.listeners.iterator();
            while (iter.hasNext()) {
                WeakReference<RecentLanguageListener> ref = iter.next();
                RecentLanguageListener listener = (RecentLanguageListener)ref.get();
                if (listener == null) {
                    iter.remove();
                    continue;
                }
                listener.recentLanguageChanged(freeIndex, newLI);
            }
        }
    }

    private class RecentLanguagesHandler
    extends DefaultHandler {
        @Override
        public void startElement(String nameSpaceURI, String name, String rawName, Attributes attrs) throws SAXException {
            if ("LANGUAGE".equals(rawName)) {
                String id = attrs.getValue("LANG_ID");
                String def = attrs.getValue("LANG_DEF");
                String label = attrs.getValue("LANG_LABEL");
                LangInfo rli = new LangInfo(id, def, label);
                RecentLanguages.this.addRecentLanguage(rli);
            }
        }
    }
}

