/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.webserviceclient.weblicht;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpi.eudico.server.corpora.util.ServerLogger;
import mpi.eudico.webserviceclient.weblicht.TCFElement;
import mpi.eudico.webserviceclient.weblicht.TCFType;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class TCFParser
implements ContentHandler {
    private XMLReader reader;
    private String inputContent;
    private StringBuilder content = new StringBuilder();
    private TCFElement curElement;
    private TCFType curType;
    private String text;
    private Map<TCFType, List<TCFElement>> baseElements;

    public TCFParser(String inputContent) {
        this.inputContent = inputContent;
    }

    public String getText() {
        return this.text;
    }

    public List<TCFElement> getElementsByType(TCFType type) {
        return this.baseElements.get((Object)type);
    }

    public void parse() throws SAXException, IOException {
        if (this.inputContent == null) {
            return;
        }
        this.baseElements = new HashMap<TCFType, List<TCFElement>>();
        this.baseElements.put(TCFType.SENTENCE, new ArrayList());
        this.baseElements.put(TCFType.TOKEN, new ArrayList());
        this.baseElements.put(TCFType.TAG, new ArrayList());
        this.baseElements.put(TCFType.LEMMA, new ArrayList());
        try {
            this.reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            this.reader.setContentHandler(this);
            this.reader.parse(new InputSource(new StringReader(this.inputContent)));
        }
        catch (SAXException se) {
            ServerLogger.LOG.warning("Parser exception: " + se.getMessage());
            throw se;
        }
        catch (IOException ioe) {
            ServerLogger.LOG.warning("IO exception: " + ioe.getMessage());
            throw ioe;
        }
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        if ("sentence".equals(localName)) {
            this.baseElements.get((Object)TCFType.SENTENCE).add(new TCFElement(atts.getValue("ID"), atts.getValue("tokenIDs"), null));
            this.curType = TCFType.SENTENCE;
        } else if ("token".equals(localName)) {
            this.curElement = new TCFElement(atts.getValue("ID"), null, null);
            this.baseElements.get((Object)TCFType.TOKEN).add(this.curElement);
            this.curType = TCFType.TOKEN;
        } else if ("tag".equals(localName)) {
            this.curElement = new TCFElement(atts.getValue("ID"), atts.getValue("tokenIDs"), null);
            this.baseElements.get((Object)TCFType.TAG).add(this.curElement);
        } else if ("POStags".equals(localName)) {
            this.curType = TCFType.POS_TAG;
        } else if ("lemma".equals(localName)) {
            this.curElement = new TCFElement(null, atts.getValue("tokenIDs"), null);
            this.baseElements.get((Object)TCFType.LEMMA).add(this.curElement);
            this.curType = TCFType.LEMMA;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.content.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if ("token".equals(localName) || "tag".equals(localName) || "lemma".equals(localName)) {
            this.curElement.setText(this.content.toString().trim());
        } else if ("text".equals(localName)) {
            this.text = this.content.toString().trim();
        }
        this.content.delete(0, this.content.length());
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }
}

