/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.webserviceclient.weblicht;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

public class TiersToTCF {
    private int tokenId = 1;
    private int sentenceId = 1;
    private Map<AbstractAnnotation, String> annTokenMap;
    private Map<AbstractAnnotation, String> annSentenceMap;
    private StringBuilder textBuilder;
    private StringBuilder tokenBuilder;
    private StringBuilder sentenceBuilder;
    private String langAttr = "en";
    private final String SPACE = " ";
    private final String NL = "\n";
    private final String LT = "<";
    private final String LT_S = "</";
    private final String GT = ">";
    private final String S_GT = "/>";
    private final String EQ = "=";
    private final String QUOTE = "\"";
    private final String FS = ".";
    private final String TOKEN_B = "<token ID=\"";
    private final String TOKEN_E = "</token>\n";
    private final String SENT_B = "<sentence ID=\"";
    private final String SENT_M = "\" tokenIDs=\"";

    public String toTCFString(TierImpl sourceTier, String type) {
        if (sourceTier == null) {
            return null;
        }
        boolean sourceTierIsToken = true;
        if (type != null && type.equals("Sentence")) {
            sourceTierIsToken = false;
        }
        if (sourceTier.getLangRef() != null) {
            this.langAttr = sourceTier.getLangRef();
            if (this.langAttr.length() > 2) {
                this.langAttr = this.langAttr.substring(0, 2);
            }
        }
        this.annTokenMap = new HashMap<AbstractAnnotation, String>();
        this.annSentenceMap = new LinkedHashMap<AbstractAnnotation, String>();
        this.textBuilder = new StringBuilder();
        this.tokenBuilder = new StringBuilder();
        this.sentenceBuilder = new StringBuilder();
        if (sourceTierIsToken) {
            TierImpl parTier = sourceTier.getParentTier();
            if (parTier == null) {
                this.createSentence(sourceTier.getAnnotations());
            } else {
                ArrayList<AbstractAnnotation> group = new ArrayList<AbstractAnnotation>();
                AbstractAnnotation curRootAnn = null;
                List<AbstractAnnotation> annotations = sourceTier.getAnnotations();
                for (int i = 0; i < annotations.size(); ++i) {
                    String curSentId;
                    AbstractAnnotation aa = annotations.get(i);
                    if (curRootAnn == null) {
                        curRootAnn = (AbstractAnnotation)aa.getParentAnnotation();
                        group.add(aa);
                    } else if (curRootAnn == aa.getParentAnnotation()) {
                        group.add(aa);
                    } else {
                        curSentId = this.createSentence(group);
                        if (curSentId != null) {
                            this.annSentenceMap.put(curRootAnn, curSentId);
                        }
                        group.clear();
                        group.add(aa);
                        curRootAnn = (AbstractAnnotation)aa.getParentAnnotation();
                    }
                    if (i != annotations.size() - 1 || (curSentId = this.createSentence(group)) == null) continue;
                    this.annSentenceMap.put(curRootAnn, curSentId);
                }
            }
        } else {
            List<AbstractAnnotation> annotations = sourceTier.getAnnotations();
            Pattern pattern = Pattern.compile(" ");
            for (int i = 0; i < annotations.size(); ++i) {
                String curSentId;
                String[] splitValue;
                AbstractAnnotation aa = annotations.get(i);
                String value = aa.getValue();
                if (value == null || value.length() == 0 || (splitValue = pattern.split(value)).length <= 0 || (curSentId = this.createSentence(splitValue)) == null) continue;
                this.annSentenceMap.put(aa, curSentId);
            }
        }
        return this.currentContentToTCF();
    }

    public String toPlainText(TierImpl sourceTier) {
        if (sourceTier == null) {
            return null;
        }
        this.textBuilder = new StringBuilder();
        List<AbstractAnnotation> annotations = sourceTier.getAnnotations();
        for (int i = 0; i < annotations.size(); ++i) {
            AbstractAnnotation aa = annotations.get(i);
            String value = aa.getValue();
            if (value == null || aa.getValue().length() <= 0) continue;
            this.textBuilder.append(value);
            if (Character.getType(value.charAt(value.length() - 1)) != 22) {
                this.textBuilder.append(".");
            }
            this.textBuilder.append(" ");
        }
        return this.textBuilder.toString();
    }

    private String currentContentToTCF() {
        StringBuilder tcfBuilder = new StringBuilder();
        tcfBuilder.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        tcfBuilder.append("\n");
        tcfBuilder.append("<D-Spin xmlns=\"http://www.dspin.de/data\" version=\"0.4\">");
        tcfBuilder.append("\n");
        tcfBuilder.append("<MetaData xmlns=\"http://www.dspin.de/data/metadata\"><source/></MetaData>");
        tcfBuilder.append("\n");
        tcfBuilder.append("<TextCorpus xmlns=\"http://www.dspin.de/data/textcorpus\" lang=\"");
        tcfBuilder.append(this.langAttr);
        tcfBuilder.append("\">");
        tcfBuilder.append("\n");
        tcfBuilder.append("<text>");
        tcfBuilder.append("\n");
        if (this.textBuilder != null) {
            tcfBuilder.append(this.textBuilder.toString());
            tcfBuilder.append("\n");
        }
        tcfBuilder.append("</text>");
        tcfBuilder.append("\n");
        tcfBuilder.append("<tokens>");
        tcfBuilder.append("\n");
        if (this.tokenBuilder != null) {
            tcfBuilder.append(this.tokenBuilder.toString());
        }
        tcfBuilder.append("</tokens>");
        tcfBuilder.append("\n");
        tcfBuilder.append("<sentences>");
        tcfBuilder.append("\n");
        if (this.sentenceBuilder != null) {
            tcfBuilder.append(this.sentenceBuilder.toString());
        }
        tcfBuilder.append("</sentences>");
        tcfBuilder.append("\n");
        tcfBuilder.append("</TextCorpus>");
        tcfBuilder.append("\n");
        tcfBuilder.append("</D-Spin>");
        return tcfBuilder.toString();
    }

    private String createSentence(List<AbstractAnnotation> annotations) {
        StringBuilder tokenIDs = new StringBuilder();
        for (int i = 0; i < annotations.size(); ++i) {
            String tokenID;
            AbstractAnnotation aa = annotations.get(i);
            String value = aa.getValue();
            if (value == null || value.length() <= 0) continue;
            if (i != 0) {
                this.textBuilder.append(" ");
            }
            this.textBuilder.append(value);
            if (i == annotations.size() - 1) {
                this.textBuilder.append(" ");
            }
            if (Character.getType(value.charAt(0)) == 21) {
                tokenID = this.addToken(value.substring(0, 1));
                tokenIDs.append(tokenID);
                if (value.length() > 1) {
                    tokenIDs.append(" ");
                    value = value.substring(1);
                } else {
                    this.annTokenMap.put(aa, tokenID);
                    if (i == annotations.size() - 1) continue;
                    tokenIDs.append(" ");
                    continue;
                }
            }
            if (Character.getType(value.charAt(value.length() - 1)) == 22) {
                if (value.length() > 1) {
                    String punct = value.substring(value.length() - 1);
                    value = value.substring(0, value.length() - 1);
                    tokenID = this.addToken(value);
                    tokenIDs.append(tokenID);
                    tokenIDs.append(" ");
                    this.annTokenMap.put(aa, tokenID);
                    tokenID = this.addToken(punct);
                    tokenIDs.append(tokenID);
                    if (i == annotations.size() - 1) continue;
                    tokenIDs.append(" ");
                    continue;
                }
                tokenID = this.addToken(value);
                tokenIDs.append(tokenID);
                if (i != annotations.size() - 1) {
                    tokenIDs.append(" ");
                }
                this.annTokenMap.put(aa, tokenID);
                continue;
            }
            tokenID = this.addToken(value);
            tokenIDs.append(tokenID);
            if (i != annotations.size() - 1) {
                tokenIDs.append(" ");
            }
            this.annTokenMap.put(aa, tokenID);
        }
        if (tokenIDs.length() > 0) {
            String sentenceID = "s" + this.sentenceId++;
            this.sentenceBuilder.append("<sentence ID=\"");
            this.sentenceBuilder.append(sentenceID);
            this.sentenceBuilder.append("\" tokenIDs=\"");
            this.sentenceBuilder.append(tokenIDs.toString());
            this.sentenceBuilder.append("\"");
            this.sentenceBuilder.append("/>");
            this.sentenceBuilder.append("\n");
            return sentenceID;
        }
        return null;
    }

    private String createSentence(String[] tokens) {
        if (tokens != null && tokens.length > 0) {
            StringBuilder tokenIDs = new StringBuilder();
            for (int i = 0; i < tokens.length; ++i) {
                String tokenID;
                String value = tokens[i];
                if (value == null || value.length() == 0) continue;
                if (i != 0) {
                    this.textBuilder.append(" ");
                }
                this.textBuilder.append(value);
                if (i == tokens.length - 1 && Character.getType(this.textBuilder.charAt(this.textBuilder.length() - 1)) != 21) {
                    this.textBuilder.append(".");
                }
                if (i == tokens.length - 1) {
                    this.textBuilder.append(" ");
                }
                if (Character.getType(value.charAt(0)) == 21) {
                    tokenID = this.addToken(value.substring(0, 1));
                    tokenIDs.append(tokenID);
                    if (value.length() > 1) {
                        tokenIDs.append(" ");
                        value = value.substring(1);
                    } else {
                        if (i == tokens.length - 1) continue;
                        tokenIDs.append(" ");
                        continue;
                    }
                }
                if (Character.getType(value.charAt(value.length() - 1)) == 22) {
                    if (value.length() > 1) {
                        String punct = value.substring(value.length() - 1);
                        value = value.substring(0, value.length() - 1);
                        tokenID = this.addToken(value);
                        tokenIDs.append(tokenID);
                        tokenIDs.append(" ");
                        tokenID = this.addToken(punct);
                        tokenIDs.append(tokenID);
                        if (i == tokens.length - 1) continue;
                        tokenIDs.append(" ");
                        continue;
                    }
                    tokenID = this.addToken(value);
                    tokenIDs.append(tokenID);
                    if (i == tokens.length - 1) continue;
                    tokenIDs.append(" ");
                    continue;
                }
                tokenID = this.addToken(value);
                tokenIDs.append(tokenID);
                if (i == tokens.length - 1) continue;
                tokenIDs.append(" ");
            }
            if (tokenIDs.length() > 0) {
                String sentenceID = "s" + this.sentenceId++;
                this.sentenceBuilder.append("<sentence ID=\"");
                this.sentenceBuilder.append(sentenceID);
                this.sentenceBuilder.append("\" tokenIDs=\"");
                this.sentenceBuilder.append(tokenIDs.toString());
                this.sentenceBuilder.append("\"");
                this.sentenceBuilder.append("/>");
                this.sentenceBuilder.append("\n");
                return sentenceID;
            }
        }
        return null;
    }

    private String addToken(String value) {
        String id = "t" + this.tokenId++;
        this.tokenBuilder.append("<token ID=\"");
        this.tokenBuilder.append(id);
        this.tokenBuilder.append("\"");
        this.tokenBuilder.append(">");
        this.tokenBuilder.append(value);
        this.tokenBuilder.append("</token>\n");
        return id;
    }
}

