/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.webserviceclient.weblicht;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import mpi.eudico.webserviceclient.WsClientRest;
import mpi.eudico.webserviceclient.weblicht.WLServiceDescriptor;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSException;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;

public class WebLichtHarvester {
    private List<WLServiceDescriptor> defaultDescriptors;
    final Logger LOG = Logger.getLogger("global");
    public long cacheReloadInterval = 86400000L;
    public final String CACHE_FILENAME = "WebLichtServices.xml";
    private final String NS_WC = "*";

    public List<WLServiceDescriptor> getServicesDescriptors() {
        this.defaultDescriptors = new ArrayList<WLServiceDescriptor>();
        return this.defaultDescriptors;
    }

    public String harvestServicesRemote() throws IOException {
        WsClientRest wsClient = new WsClientRest();
        String urlString = "http://weblicht.sfs.uni-tuebingen.de/apps/harvester/resources/services";
        HashMap<String, String> requestHead = new HashMap<String, String>(3);
        requestHead.put("Connection", "Keep-Alive");
        String base64Encoded = "Y2xhcmluZGRldmVsb3Blcjp3ZWJzZXJ2aWNlaGFydmVzdGluZw==";
        requestHead.put("Authorization", "Basic " + base64Encoded);
        try {
            String result = wsClient.callServiceGetMethod(urlString, null, requestHead, null, null, 0.0f, 0.0f);
            if (result != null) {
                return result;
            }
            this.LOG.warning("An error occurred while harvesting available web services...");
        }
        catch (IOException ioe) {
            this.LOG.warning("IO error while harvesting: " + ioe.getMessage());
            throw ioe;
        }
        return null;
    }

    public List<WLServiceDescriptor> parseRelevantServices(String xmlString) throws IOException {
        if (xmlString == null || xmlString.isEmpty()) {
            return null;
        }
        List<WLServiceDescriptor> wlDescriptors = null;
        try {
            DOMImplementationLS domImplementation = (DOMImplementationLS)((Object)DOMImplementationRegistry.newInstance().getDOMImplementation("LS"));
            LSInput lsInput = domImplementation.createLSInput();
            lsInput.setEncoding("UTF-8");
            lsInput.setStringData(xmlString);
            LSParser parser = domImplementation.createLSParser((short)1, null);
            Document wlDoc = parser.parse(lsInput);
            wlDescriptors = this.parseRelevantServices(wlDoc);
        }
        catch (IllegalAccessException iae) {
            throw new IOException(iae.getMessage());
        }
        catch (ClassCastException cce) {
            throw new IOException(cce.getMessage());
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe.getMessage());
        }
        catch (InstantiationException ie) {
            throw new IOException(ie.getMessage());
        }
        catch (DOMException de) {
            throw new IOException(de.getMessage());
        }
        catch (LSException lse) {
            throw new IOException(lse.getMessage());
        }
        return wlDescriptors;
    }

    private List<WLServiceDescriptor> parseRelevantServices(Document weblichtDoc) {
        if (weblichtDoc == null) {
            return null;
        }
        ArrayList<WLServiceDescriptor> wlDescriptors = new ArrayList<WLServiceDescriptor>();
        Element docElem = weblichtDoc.getDocumentElement();
        NodeList serviceList = docElem.getElementsByTagNameNS("*", "Service");
        this.LOG.info("Number of WebLicht web services: " + serviceList.getLength());
        for (int i = 0; i < serviceList.getLength(); ++i) {
            NodeList urlList;
            NodeList orgList;
            Element outputEl;
            NodeList outParams;
            boolean validOutput;
            NodeList outputElems;
            Element inputEl;
            NodeList inParams;
            NodeList inputElems;
            WLServiceDescriptor curWLDescriptor = null;
            Element serviceEl = (Element)serviceList.item(i);
            String serviceName = null;
            NodeList serviceNameList = serviceEl.getElementsByTagNameNS("*", "Name");
            if (serviceNameList.getLength() > 0) {
                serviceName = serviceNameList.item(0).getTextContent();
            }
            if (serviceName == null || serviceName.isEmpty() || (inputElems = serviceEl.getElementsByTagNameNS("*", "Input")).getLength() == 0 || (curWLDescriptor = this.checkInputParameters(serviceName, inParams = (inputEl = (Element)inputElems.item(0)).getElementsByTagNameNS("*", "Parameter"))) == null || (outputElems = serviceEl.getElementsByTagNameNS("*", "Output")).getLength() == 0 || !(validOutput = this.checkOutputParameters(outParams = (outputEl = (Element)outputElems.item(0)).getElementsByTagNameNS("*", "Parameter"), curWLDescriptor))) continue;
            NodeList descriptionList = serviceEl.getElementsByTagNameNS("*", "Description");
            if (descriptionList.getLength() > 0) {
                Node descEl = descriptionList.item(0);
                curWLDescriptor.description = descEl.getTextContent().replaceAll("\n", " ");
            }
            if ((orgList = serviceEl.getElementsByTagNameNS("*", "Organisation")).getLength() > 0) {
                curWLDescriptor.creator = orgList.item(0).getTextContent();
            }
            if ((urlList = serviceEl.getElementsByTagNameNS("*", "url")).getLength() <= 0) continue;
            curWLDescriptor.fullURL = urlList.item(0).getTextContent();
            wlDescriptors.add(curWLDescriptor);
        }
        return wlDescriptors;
    }

    private WLServiceDescriptor checkInputParameters(String serviceName, NodeList inputParams) {
        if (inputParams == null || inputParams.getLength() == 0) {
            return null;
        }
        WLServiceDescriptor curWLDescriptor = new WLServiceDescriptor(serviceName);
        try {
            for (int j = 0; j < inputParams.getLength(); ++j) {
                Element nameEl;
                String name;
                Element param = (Element)inputParams.item(j);
                NodeList nameList = param.getElementsByTagNameNS("*", "Name");
                if (nameList.getLength() <= 0 || (name = (nameEl = (Element)nameList.item(0)).getTextContent()) == null) continue;
                if (name.equals("sentences")) {
                    curWLDescriptor.sentenceInput = true;
                    continue;
                }
                if (name.equals("tokens")) {
                    curWLDescriptor.tokensInput = true;
                    continue;
                }
                if (!name.equals("type")) continue;
                NodeList valList = param.getElementsByTagNameNS("*", "Value");
                for (int k = 0; k < valList.getLength(); ++k) {
                    Element valEl = (Element)valList.item(k);
                    String value = valEl.getTextContent();
                    if ("text/tcf+xml".equals(value)) {
                        curWLDescriptor.tcfInput = true;
                        continue;
                    }
                    if (!"text/plain".equals(value)) continue;
                    curWLDescriptor.plainTextInput = true;
                }
            }
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        if (curWLDescriptor.plainTextInput || curWLDescriptor.tcfInput) {
            return curWLDescriptor;
        }
        return null;
    }

    private boolean checkOutputParameters(NodeList outputParams, WLServiceDescriptor curWLDescriptor) {
        if (outputParams == null || curWLDescriptor == null || outputParams.getLength() == 0) {
            return false;
        }
        try {
            for (int j = 0; j < outputParams.getLength(); ++j) {
                Element nameEl;
                String name;
                Element param = (Element)outputParams.item(j);
                NodeList nameList = param.getElementsByTagNameNS("*", "Name");
                if (nameList.getLength() <= 0 || (name = (nameEl = (Element)nameList.item(0)).getTextContent()) == null) continue;
                if (name.equals("sentences")) {
                    curWLDescriptor.sentenceOutput = true;
                    continue;
                }
                if (name.equals("tokens")) {
                    curWLDescriptor.tokensOutput = true;
                    continue;
                }
                if (name.equals("lemmas")) {
                    curWLDescriptor.lemmaSupport = true;
                    continue;
                }
                if (name.indexOf("postags") > -1) {
                    curWLDescriptor.posTagSupport = true;
                    continue;
                }
                if (!name.equals("type")) continue;
                NodeList valList = param.getElementsByTagNameNS("*", "Value");
                for (int k = 0; k < valList.getLength(); ++k) {
                    Element valEl = (Element)valList.item(k);
                    String value = valEl.getTextContent();
                    if (!"text/tcf+xml".equals(value)) continue;
                    curWLDescriptor.tcfOutput = true;
                }
            }
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        return curWLDescriptor.tcfOutput || curWLDescriptor.lemmaSupport || curWLDescriptor.sentenceOutput || curWLDescriptor.tokensOutput || curWLDescriptor.posTagSupport;
    }

    public long getLastCachingTime(String cachePath) {
        if (cachePath == null) {
            return 0L;
        }
        try {
            File cf = new File(cachePath);
            if (cf.exists() && cf.canRead() && !cf.isDirectory()) {
                return cf.lastModified();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0L;
    }

    public List<WLServiceDescriptor> loadRelevantServicesFromCache(String cachePath) throws IOException {
        if (cachePath == null) {
            return null;
        }
        List<WLServiceDescriptor> wlDescriptors = null;
        InputStreamReader reader = null;
        try {
            DOMImplementationLS domImplementation = (DOMImplementationLS)((Object)DOMImplementationRegistry.newInstance().getDOMImplementation("LS"));
            LSInput lsInput = domImplementation.createLSInput();
            lsInput.setEncoding("UTF-8");
            reader = new InputStreamReader(new FileInputStream(cachePath));
            lsInput.setCharacterStream(reader);
            LSParser parser = domImplementation.createLSParser((short)1, null);
            Document wlDoc = parser.parse(lsInput);
            wlDescriptors = this.parseRelevantServices(wlDoc);
        }
        catch (IllegalAccessException iae) {
            throw new IOException(iae.getMessage());
        }
        catch (ClassCastException cce) {
            throw new IOException(cce.getMessage());
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException(cnfe.getMessage());
        }
        catch (InstantiationException ie) {
            throw new IOException(ie.getMessage());
        }
        catch (DOMException de) {
            throw new IOException(de.getMessage());
        }
        catch (LSException lse) {
            throw new IOException(lse.getMessage());
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return wlDescriptors;
    }

    public void storeCachedVersion(String cachePath, String xmlString) throws IOException {
        BufferedWriter bufWriter = null;
        try {
            File outFile = new File(cachePath);
            bufWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8"));
            bufWriter.write(xmlString);
            bufWriter.flush();
        }
        catch (Throwable t) {
            this.LOG.warning("Cannot write WebLicht cache file:" + t.getMessage());
            throw new IOException("Cannot write WebLicht cache file:" + t.getMessage());
        }
        finally {
            if (bufWriter != null) {
                try {
                    bufWriter.close();
                }
                catch (Throwable outFile) {}
            }
        }
    }
}

