/*
 * Decompiled with CFR 0.152.
 */
package mpi.search.content.query.viewer;

import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultTreeModel;
import mpi.eudico.client.annotator.search.model.ElanType;
import mpi.search.SearchLocale;
import mpi.search.content.model.CorpusType;
import mpi.search.content.query.model.AnchorConstraint;
import mpi.search.content.query.viewer.AbstractConstraintPanel;

public class AnchorConstraintPanel
extends AbstractConstraintPanel {
    private final JLabel lockedConstraintLabel = new JLabel();
    private String lockedTierName = null;
    private String lockedPattern = null;

    public AnchorConstraintPanel(AnchorConstraint constraint, DefaultTreeModel treeModel, CorpusType type, Action startAction) {
        super(constraint, treeModel, type, startAction);
        this.titleComponent.add(new JLabel(SearchLocale.getString("Search.Query.Find").toUpperCase()));
        this.titleComponent.setBorder(new EmptyBorder(0, 0, 5, 0));
        this.tierComboBox = new JComboBox(type.getTierNames()){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                AbstractConstraintPanel.tierComboBoxWidth = this.getPreferredSize().width;
            }
        };
        if (type.allowsSearchOverMultipleTiers() && type.getTierNames().length > 1) {
            this.tierComboBox.insertItemAt("Search.Constraint.AllTiers", 0);
            if (type instanceof ElanType) {
                this.tierComboBox.insertItemAt("Search.Constraint.CustomTiers", 1);
            }
        }
        this.lockedConstraintLabel.setHorizontalAlignment(0);
        this.framedPanel.add((Component)this.lockedConstraintLabel, "locked");
        this.makeLayout();
        this.setConstraint(constraint);
        this.tierComboBox.addPopupMenuListener(this);
    }

    @Override
    protected void setTierName(String tierName) {
        for (int i = 0; i < this.type.getIndexTierNames().length; ++i) {
            if (!this.type.getIndexTierNames()[i].equals(tierName.toUpperCase())) continue;
            this.lockedTierName = tierName.toUpperCase();
            this.framedPanelLayout.show(this.framedPanel, "locked");
            return;
        }
        if (this.lockedTierName != null) {
            this.lockedTierName = null;
            this.lockedPattern = null;
            this.framedPanelLayout.show(this.framedPanel, "");
        }
        super.setTierName(tierName);
    }

    protected void setTierNames(List<String> tierNames) {
        if (tierNames.size() > 0) {
            if (tierNames.size() == 1) {
                this.setTierName(tierNames.get(0));
            } else {
                this.tierComboBox.setSelectedItem("Search.Constraint.CustomTiers");
                this.selectedTiers = new ArrayList<String>(tierNames);
            }
        } else {
            this.tierComboBox.setSelectedIndex(0);
        }
    }

    protected void setTierNames(String[] tierNames) {
        this.setTierNames(Arrays.asList(tierNames));
    }

    @Override
    public String getTierName() {
        return this.lockedTierName == null ? super.getTierName() : this.lockedTierName;
    }

    @Override
    protected void setPattern(String pattern) {
        if (this.lockedTierName != null) {
            this.lockedPattern = pattern;
            this.lockedConstraintLabel.setText(this.type.getUnabbreviatedTierName(this.lockedTierName) + " " + this.lockedPattern);
        } else {
            super.setPattern(pattern);
        }
    }

    @Override
    protected String getPattern() {
        return this.lockedPattern == null ? super.getPattern() : this.lockedPattern;
    }

    public void setConstraint(AnchorConstraint c) {
        this.setTierNames(c.getTierNames());
        super.setConstraint(c);
    }
}

