/*
 * Decompiled with CFR 0.152.
 */
package mpi.search.content.result.viewer;

import mpi.eudico.util.TimeFormatter;
import mpi.search.SearchLocale;
import mpi.search.content.result.model.ContentMatch;
import mpi.search.content.result.model.ContentResult;

public class ContentResult2HTML {
    public static void appendMatchValue(StringBuilder sb, ContentMatch match) {
        String s = match.getValue();
        int[][] highlights = match.getMatchedSubstringIndices();
        if (highlights != null && ContentResult2HTML.arrayIsConsistent(s, highlights)) {
            if (highlights.length > 0) {
                for (int j = 0; j < highlights.length; ++j) {
                    String substring = s.substring(j == 0 ? 0 : highlights[j - 1][1], highlights[j][0]);
                    sb.append(substring);
                    substring = s.substring(highlights[j][0], highlights[j][1]);
                    sb.append("<b>" + substring + "</b>");
                }
                sb.append(s.substring(highlights[highlights.length - 1][1]));
            } else {
                sb.append(s);
            }
        } else {
            sb.append(s);
        }
    }

    public static void appendResultAsTable(StringBuilder sb, ContentResult result) {
        sb.append("<table border=\"1\" rules=\"all\" cellpadding=\"3\">\n");
        sb.append("<thead><tr><th>" + SearchLocale.getString("Search.Table.Count") + "</th><th>" + SearchLocale.getString("Search.Annotation_SG") + "</th><th>" + SearchLocale.getString("Search.Table.BeginTime") + "</th><th>" + SearchLocale.getString("Search.Table.EndTime") + "</th><th>" + SearchLocale.getString("Search.Table.Duration") + "</th></tr></thead>\n<tbody>");
        for (int i = 0; i < result.getRealSize(); ++i) {
            ContentMatch match = result.getMatch(i + 1);
            sb.append("<tr>");
            sb.append("<td align=\"right\">" + (i + 1) + "</td><td>");
            ContentResult2HTML.appendMatchValue(sb, match);
            sb.append("</td><td align=\"right\">" + TimeFormatter.toSSMSString(match.getBeginTimeBoundary()) + "</td><td align=\"right\">" + TimeFormatter.toSSMSString(match.getEndTimeBoundary()) + "</td><td align=\"right\">" + TimeFormatter.toSSMSString(match.getEndTimeBoundary() - match.getBeginTimeBoundary()) + "</td>");
            sb.append("</tr>\n");
        }
        sb.append("</tbody>\n</table>\n");
    }

    private static boolean arrayIsConsistent(String s, int[][] highlights) {
        for (int j = 0; j < highlights.length; ++j) {
            if (highlights[j][0] >= 0 && highlights[j][0] <= highlights[j][1] && highlights[j][1] <= s.length()) continue;
            return false;
        }
        return true;
    }
}

