/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.avf.player;

import java.awt.Dimension;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.mpi.avf.player.JAVFPlayerException;

public class AVFBasePlayer {
    static final Logger LOG;
    long id;
    String mediaPath;
    static boolean nativeLibLoaded;
    final int STATUS_UNKNOWN = 0;
    final int STATUS_READY = 1;
    final int STATUS_FAILED = 2;
    final int MAX_LOAD_TIME = 15000;

    public AVFBasePlayer(String mediaPath) throws JAVFPlayerException {
        this.mediaPath = mediaPath;
        if (mediaPath.startsWith("file:///")) {
            this.mediaPath = mediaPath.substring(5);
        }
        this.id = this.initPlayer(this.mediaPath);
        if (this.id <= 0L) {
            throw new JAVFPlayerException("Failed to create a native AVPlayer");
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("New player created, ID: %d for path %s", this.id, this.mediaPath));
        }
    }

    public void deletePlayer() {
        this.deletePlayer(this.id);
        this.id = -this.id;
    }

    public void start() {
        this.start(this.id);
    }

    public void stop() {
        this.stop(this.id);
    }

    public void pause() {
        this.pause(this.id);
    }

    public boolean isPlaying() {
        return this.isPlaying(this.id);
    }

    public void setRate(float rate) {
        this.setRate(this.id, rate);
    }

    public float getRate() {
        return this.getRate(this.id);
    }

    public void setVolume(float volume) {
        this.setVolume(this.id, volume);
    }

    public float getVolume() {
        return this.getVolume(this.id);
    }

    public long getMediaTime() {
        return this.getMediaTime(this.id);
    }

    public double getMediaTimeSeconds() {
        return this.getMediaTimeSeconds(this.id);
    }

    public void setMediaTime(long time) {
        this.setMediaTime(this.id, time);
    }

    public void setMediaTimeSeconds(double time) {
        this.setMediaTimeSeconds(this.id, time);
    }

    public boolean hasVideo() {
        return this.hasVideo(this.id);
    }

    public boolean hasAudio() {
        return this.hasAudio(this.id);
    }

    public long getDuration() {
        return this.getDuration(this.id);
    }

    public double getDurationSeconds() {
        return this.getDurationSeconds(this.id);
    }

    public double getFrameRate() {
        return this.getFrameRate(this.id);
    }

    public double getTimePerFrame() {
        return this.getTimePerFrame(this.id);
    }

    public float getAspectRatio() {
        return this.getAspectRatio(this.id);
    }

    public Dimension getOriginalSize() {
        return this.getOriginalSize(this.id);
    }

    public void setVideoScaleFactor(float scale) {
    }

    public void setVideoBounds(int x, int y, int w, int h) {
    }

    public int[] getVideoBounds() {
        return null;
    }

    public void repaintVideo() {
    }

    public static void setLogLevel(Level level) {
        if (level == null) {
            return;
        }
        if (level == Level.ALL) {
            AVFBasePlayer.setJAVFLogLevel(0);
        } else if (level == Level.OFF) {
            AVFBasePlayer.setJAVFLogLevel(10);
        } else if (level.intValue() > Level.ALL.intValue() && level.intValue() <= Level.FINE.intValue()) {
            AVFBasePlayer.setJAVFLogLevel(3);
        } else if (level.intValue() > Level.FINE.intValue() && level.intValue() <= Level.INFO.intValue()) {
            AVFBasePlayer.setJAVFLogLevel(5);
        } else if (level.intValue() > Level.INFO.intValue() && level.intValue() <= Level.WARNING.intValue()) {
            AVFBasePlayer.setJAVFLogLevel(8);
        } else if (level.intValue() > Level.WARNING.intValue()) {
            AVFBasePlayer.setJAVFLogLevel(10);
        }
    }

    static native void setJAVFLogLevel(int var0);

    static native int getJAVFLogLevel();

    native long initPlayer(String var1);

    native int getPlayerLoadStatus(long var1);

    native String getPlayerError(long var1);

    native void deletePlayer(long var1);

    native void start(long var1);

    native void stop(long var1);

    native void pause(long var1);

    native boolean isPlaying(long var1);

    native int getState(long var1);

    native void setRate(long var1, float var3);

    native float getRate(long var1);

    native void setVolume(long var1, float var3);

    native float getVolume(long var1);

    native long getMediaTime(long var1);

    native double getMediaTimeSeconds(long var1);

    native void setMediaTime(long var1, long var3);

    native void setMediaTimeSeconds(long var1, double var3);

    native boolean hasVideo(long var1);

    native boolean hasAudio(long var1);

    native long getDuration(long var1);

    native double getDurationSeconds(long var1);

    native double getFrameRate(long var1);

    native double getTimePerFrame(long var1);

    native float getAspectRatio(long var1);

    native Dimension getOriginalSize(long var1);

    static {
        block6: {
            LOG = Logger.getLogger("AVF");
            nativeLibLoaded = false;
            try {
                System.loadLibrary("AVFPlayer");
                nativeLibLoaded = true;
            }
            catch (SecurityException se) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Could not load native library (libAVFPlayer.dylib): " + se.getMessage());
                }
            }
            catch (UnsatisfiedLinkError ule) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Could not load native library (libAVFPlayer.dylib): " + ule.getMessage());
                }
            }
            catch (Throwable t) {
                if (!LOG.isLoggable(Level.WARNING)) break block6;
                LOG.warning("Could not load native library (libAVFPlayer.dylib): " + t.getMessage());
            }
        }
    }
}

