/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.avf.player;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import javax.swing.JRootPane;
import nl.mpi.avf.player.AVFBaseMediaPlayer;
import nl.mpi.avf.player.AVFNativePlayer;
import nl.mpi.avf.player.JAVFPlayerException;

public class AVFNativeMediaPlayer
extends AVFBaseMediaPlayer {
    private AVFNCanvas visualComponent;
    private final ReentrantLock paintLock = new ReentrantLock();

    public AVFNativeMediaPlayer(String mediaPath) throws JAVFPlayerException {
        super(mediaPath);
    }

    @Override
    void initMediaPlayer() throws JAVFPlayerException {
        try {
            this.avfPlayer = new AVFNativePlayer(this.mediaPath);
        }
        catch (JAVFPlayerException je) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("Cannot create %s, message: %s", AVFNativePlayer.class.getName(), je.getMessage()));
            }
            throw je;
        }
        if (this.avfPlayer.hasVideo()) {
            this.visualComponent = new AVFNCanvas();
        }
    }

    @Override
    public Component getVisualComponent() {
        return this.visualComponent;
    }

    @Override
    public void deletePlayer() {
        this.avfPlayer.deletePlayer();
    }

    @Override
    public Dimension getOriginalSize() {
        return this.avfPlayer.getOriginalSize();
    }

    @Override
    public void setVideoScaleFactor(float scaleFactor) {
        super.setVideoScaleFactor(scaleFactor);
        this.avfPlayer.setVideoScaleFactor(scaleFactor);
        this.componentResized();
        this.visualComponent.nativeVideoBoundsChanged();
    }

    @Override
    public float getVideoScaleFactor() {
        return super.getVideoScaleFactor();
    }

    @Override
    public void repaintVideo() {
        this.avfPlayer.repaintVideo();
    }

    @Override
    public void setVideoBounds(int x, int y, int w, int h) {
        this.avfPlayer.setVideoBounds(x, y, w, h);
    }

    @Override
    public int[] getVideoBounds() {
        return this.avfPlayer.getVideoBounds();
    }

    @Override
    public void moveVideoPos(int dx, int dy) {
        if (dx == 0 && dy == 0) {
            return;
        }
        new MoveThread(dx, dy).start();
    }

    void componentResized() {
        if (this.videoScaleFactor > 1.0f) {
            int[] curBounds = this.getVideoBounds();
            if (curBounds != null) {
                int nw = this.visualComponent.getWidth();
                int nh = this.visualComponent.getHeight();
                float bw = (float)nw * this.videoScaleFactor;
                float bh = (float)nh * this.videoScaleFactor;
                int bx = (int)(this.vxToTlcPerc * (double)bw);
                int by = (int)(this.vyToTlcPerc * (double)bh);
                bx = (float)bx + bw < (float)nw ? (int)((float)nw - bw) : bx;
                by = (float)by + bh < (float)nh ? (int)((float)nh - bh) : by;
                this.setVideoBounds(bx, by, (int)bw, (int)bh);
            } else {
                System.out.println("Cannot set video bounds, old bounds is null");
            }
        } else {
            this.setVideoBounds(0, 0, this.visualComponent.getWidth(), this.visualComponent.getHeight());
        }
    }

    class AVFNCanvas
    extends Canvas
    implements ComponentListener {
        private int reshapeW = -1;
        private int reshapeH = -1;
        boolean firstMove = true;

        public AVFNCanvas() {
            this.setBackground(new Color(0, 64, 64));
            this.addComponentListener(this);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            ((AVFNativePlayer)AVFNativeMediaPlayer.this.avfPlayer).setVisualComponent(AVFNativeMediaPlayer.this.visualComponent);
            Container parComp = this.getParent();
            if (parComp != null) {
                parComp.addComponentListener(this);
                while ((parComp = parComp.getParent()) != null) {
                    if (!(parComp instanceof JRootPane)) continue;
                    parComp.addComponentListener(this);
                    break;
                }
            }
        }

        @Override
        public void removeNotify() {
            ((AVFNativePlayer)AVFNativeMediaPlayer.this.avfPlayer).disconnectVisualComponent(AVFNativeMediaPlayer.this.visualComponent);
            Container parComp = this.getParent();
            if (parComp != null) {
                parComp.removeComponentListener(this);
                while ((parComp = parComp.getParent()) != null) {
                    if (!(parComp instanceof JRootPane)) continue;
                    parComp.removeComponentListener(this);
                    break;
                }
            }
            super.removeNotify();
        }

        void nativeVideoBoundsChanged() {
            Rectangle rect = this.getBounds();
            this.reshapeW = rect.width + 1;
            this.reshapeH = rect.height;
            this.setSize(this.reshapeW, this.reshapeH);
            --this.reshapeW;
            this.setSize(this.reshapeW, this.reshapeH);
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (e.getSource() == this) {
                Rectangle curRect = e.getComponent().getBounds();
                if (curRect.getWidth() != (double)this.reshapeW && curRect.getHeight() != (double)this.reshapeH) {
                    AVFNativeMediaPlayer.this.componentResized();
                }
            } else if (e.getSource() == this.getParent()) {
                this.nativeVideoBoundsChanged();
            } else {
                this.nativeVideoBoundsChanged();
            }
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            if (this.firstMove) {
                this.nativeVideoBoundsChanged();
                this.firstMove = false;
            }
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }
    }

    class MoveThread
    extends Thread {
        private int dx;
        private int dy;

        public MoveThread(int dx, int dy) {
            super("MoveThread");
            this.dx = dx;
            this.dy = dy;
        }

        @Override
        public void run() {
            try {
                if (AVFNativeMediaPlayer.this.paintLock.tryLock(1L, TimeUnit.MILLISECONDS)) {
                    int[] oldBounds = AVFNativeMediaPlayer.this.getVideoBounds();
                    Dimension curCanvasSize = AVFNativeMediaPlayer.this.visualComponent.getSize();
                    if (oldBounds != null && curCanvasSize != null) {
                        int nx = oldBounds[0] + this.dx > 0 ? 0 : oldBounds[0] + this.dx;
                        nx = nx + oldBounds[2] < curCanvasSize.width ? curCanvasSize.width - oldBounds[2] : nx;
                        int ny = oldBounds[1] + this.dy > 0 ? 0 : oldBounds[1] + this.dy;
                        int n = ny = ny + oldBounds[3] < curCanvasSize.height ? curCanvasSize.height - oldBounds[3] : ny;
                        if (nx != oldBounds[0] || ny != oldBounds[1]) {
                            AVFNativeMediaPlayer.this.vxToTlcPerc = (double)nx / (double)oldBounds[2];
                            AVFNativeMediaPlayer.this.vyToTlcPerc = (double)ny / (double)oldBounds[3];
                            AVFNativeMediaPlayer.this.setVideoBounds(nx, ny, oldBounds[2], oldBounds[3]);
                        }
                    }
                    AVFNativeMediaPlayer.this.paintLock.unlock();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

