/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.avf.player;

import java.awt.Component;
import java.util.logging.Level;
import nl.mpi.avf.player.AVFBasePlayer;
import nl.mpi.avf.player.JAVFPlayerException;

public class AVFNativePlayer
extends AVFBasePlayer {
    private Component visualComponent;

    public AVFNativePlayer(String mediaPath) throws JAVFPlayerException {
        super(mediaPath);
        if (this.id > 0L && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Player type: AVFNativePlayer - rendering in a AVPlayerLayer");
        }
    }

    public void setVisualComponent(Component comp) {
        this.setVisualComponent(this.id, comp);
        this.visualComponent = comp;
    }

    public Component getVisualComponent() {
        return this.visualComponent;
    }

    public void disconnectVisualComponent(Component comp) {
        this.disconnectVisualComponent(this.id, comp);
    }

    @Override
    public void deletePlayer() {
        if (this.id <= 0L) {
            return;
        }
        if (this.visualComponent != null) {
            this.disconnectVisualComponent(this.id, this.visualComponent);
        }
        this.deletePlayer(this.id);
        this.id = -this.id;
    }

    @Override
    public void setVideoScaleFactor(float scale) {
        this.setVideoScaleFactor(this.id, scale);
    }

    @Override
    public void setVideoBounds(int x, int y, int w, int h) {
        this.setVideoBounds(this.id, x, y, w, h);
    }

    @Override
    public int[] getVideoBounds() {
        return this.getVideoBounds(this.id);
    }

    @Override
    public void repaintVideo() {
        this.repaintVideo(this.id);
    }

    @Override
    native long initPlayer(String var1);

    @Override
    native void deletePlayer(long var1);

    private native void setVisualComponent(long var1, Component var3);

    private native void disconnectVisualComponent(long var1, Component var3);

    native void setVideoScaleFactor(long var1, float var3);

    native void setVideoBounds(long var1, int var3, int var4, int var5, int var6);

    native int[] getVideoBounds(long var1);

    native void repaintVideo(long var1);
}

