/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.avf.player;

import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JAVFImageProducer {
    private final Logger LOG = Logger.getLogger("AVF");
    private IMAGE_PRESETS curImagePreset;
    private ComponentColorModel comColorModel;
    private ColorModel colorModel;
    private SampleModel sampleModel;
    private int bytesPerPixel = 3;
    private int[] bandOrder = new int[]{0, 1, 2};
    final int AM = -16777216;
    final int RM = 0xFF0000;
    final int GM = 65280;
    final int BM = 255;
    int[] masks = new int[]{0xFF0000, 65280, 255};

    public JAVFImageProducer() {
        this.setDefaultImagePreset();
    }

    private void setDefaultImagePreset() {
        this.setImagePreset(IMAGE_PRESETS.AV_24RGB_DATABUFFER_INT);
    }

    public void setImagePreset(IMAGE_PRESETS nextPreset) {
        if (nextPreset != this.curImagePreset) {
            switch (nextPreset) {
                case AV_24RGB_DATABUFFER_BYTE: {
                    this.bandOrder = new int[]{0, 1, 2};
                    this.masks = new int[]{0xFF0000, 65280, 255};
                    this.bytesPerPixel = 3;
                    this.colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), false, true, 1, 0);
                    break;
                }
                case AV_24RGB_DATABUFFER_INT: {
                    this.bandOrder = new int[]{0, 1, 2};
                    this.masks = new int[]{0xFF0000, 65280, 255};
                    this.bytesPerPixel = this.masks.length;
                    this.colorModel = new DirectColorModel(ColorSpace.getInstance(1000), 24, this.masks[0], this.masks[1], this.masks[2], 0, true, 3);
                    break;
                }
                case AV_32ARGB_DATABUFFER_BYTE: {
                    this.bandOrder = new int[]{1, 2, 3};
                    this.masks = new int[]{0xFF0000, 65280, 255};
                    this.bytesPerPixel = 4;
                    this.colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), false, true, 1, 0);
                    break;
                }
                case AV_32ARGB_DATABUFFER_INT: {
                    this.bandOrder = new int[]{1, 2, 3, 0};
                    this.masks = new int[]{0xFF0000, 65280, 255, -16777216};
                    this.bytesPerPixel = this.masks.length;
                    this.colorModel = new DirectColorModel(ColorSpace.getInstance(1000), 32, this.masks[0], this.masks[1], this.masks[2], this.masks[3], true, 3);
                    break;
                }
                case AV_32BGRA_DATABUFFER_BYTE: {
                    this.bandOrder = new int[]{2, 1, 0};
                    this.masks = new int[]{0xFF0000, 65280, 255};
                    this.bytesPerPixel = 4;
                    this.colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), false, true, 1, 0);
                    break;
                }
                case AV_32BGRA_DATABUFFER_INT: {
                    this.bandOrder = new int[]{2, 1, 0};
                    this.masks = new int[]{255, 65280, 0xFF0000};
                    this.bytesPerPixel = this.masks.length;
                    this.colorModel = new DirectColorModel(ColorSpace.getInstance(1000), 24, this.masks[0], this.masks[1], this.masks[2], 0, true, 3);
                    break;
                }
            }
            this.bytesPerPixel = this.bandOrder.length;
            this.sampleModel = null;
            this.curImagePreset = nextPreset;
        }
    }

    public void setColorModel(int colorSpaceType, int dataType, boolean hasAlpha) {
        block2: {
            try {
                this.colorModel = new ComponentColorModel(ColorSpace.getInstance(colorSpaceType), hasAlpha, true, 1, dataType);
            }
            catch (IllegalArgumentException e) {
                if (!this.LOG.isLoggable(Level.WARNING)) break block2;
                this.LOG.warning("Could not change the color model: " + e.getMessage());
            }
        }
    }

    public Image[] produceImagesFromBuffer(ByteBuffer byteBuffer, int bytesPerImage, int numImages, int width, int height) {
        switch (this.curImagePreset) {
            case AV_24RGB_DATABUFFER_INT: 
            case AV_32ARGB_DATABUFFER_INT: 
            case AV_32BGRA_DATABUFFER_INT: {
                if (bytesPerImage == width * height * this.bytesPerPixel) {
                    return this.produceImagesFromBufferInt(byteBuffer, bytesPerImage, numImages, width, height);
                }
                return this.produceImagesFromBufferIntCorrectForStride(byteBuffer, bytesPerImage, numImages, width, height);
            }
            case AV_24RGB_DATABUFFER_BYTE: 
            case AV_32ARGB_DATABUFFER_BYTE: 
            case AV_32BGRA_DATABUFFER_BYTE: {
                return this.produceImagesFromBufferByte(byteBuffer, bytesPerImage, numImages, width, height);
            }
        }
        return null;
    }

    private Image[] produceImagesFromBufferByte(ByteBuffer byteBuffer, int bytesPerImage, int numImages, int width, int height) {
        Image[] images = new BufferedImage[numImages];
        int position = 0;
        for (int imgIndex = 0; imgIndex < numImages && position <= byteBuffer.capacity() - bytesPerImage; ++imgIndex) {
            byte[] copyBytes = new byte[bytesPerImage];
            byteBuffer.get(copyBytes, 0, bytesPerImage);
            try {
                DataBufferByte dataBufferByte = new DataBufferByte(copyBytes, bytesPerImage);
                int scanlineStride = this.bytesPerPixel * width;
                if (scanlineStride != bytesPerImage / height) {
                    scanlineStride = bytesPerImage / height;
                }
                WritableRaster raster = Raster.createInterleavedRaster(dataBufferByte, width, height, scanlineStride, this.bytesPerPixel, this.bandOrder, null);
                images[imgIndex] = new BufferedImage(this.colorModel, raster, true, null);
                byteBuffer.position(position += bytesPerImage);
                continue;
            }
            catch (RasterFormatException rfe) {
                if (!this.LOG.isLoggable(Level.WARNING)) break;
                this.LOG.warning("Cannot convert to images, invalid raster format: " + rfe.getMessage());
                break;
            }
            catch (IllegalArgumentException iae) {
                if (!this.LOG.isLoggable(Level.WARNING)) break;
                this.LOG.warning("Cannot convert to images: " + iae.getMessage());
                break;
            }
        }
        byteBuffer.rewind();
        return images;
    }

    private Image[] produceImagesFromBufferInt(ByteBuffer byteBuffer, int bytesPerImage, int numImages, int width, int height) {
        Image[] images = new BufferedImage[numImages];
        int imgIndex = 0;
        int position = 0;
        if (this.sampleModel == null) {
            this.sampleModel = new SinglePixelPackedSampleModel(3, width, height, this.masks);
        }
        while (imgIndex < numImages && position <= byteBuffer.capacity() - bytesPerImage) {
            byte[] copyBytes = new byte[bytesPerImage];
            byteBuffer.get(copyBytes, 0, bytesPerImage);
            try {
                int[] copyInts = new int[width * height];
                int j = 0;
                for (int i = 0; i < copyBytes.length; i += this.bytesPerPixel) {
                    int p = 0;
                    for (int m = 0; m < this.masks.length; ++m) {
                        p |= copyBytes[i + m] & 0xFF;
                        if (m >= this.masks.length - 1) continue;
                        p <<= 8;
                    }
                    copyInts[j++] = p;
                }
                DataBufferInt dataBufferInt = new DataBufferInt(copyInts, copyInts.length);
                WritableRaster raster = Raster.createWritableRaster(this.sampleModel, dataBufferInt, null);
                images[imgIndex] = new BufferedImage(this.colorModel, raster, true, null);
                ++imgIndex;
                byteBuffer.position(position += bytesPerImage);
            }
            catch (RasterFormatException rfe) {
                if (!this.LOG.isLoggable(Level.WARNING)) break;
                this.LOG.warning("Cannot convert to images, invalid raster format: " + rfe.getMessage());
                break;
            }
            catch (IllegalArgumentException iae) {
                if (!this.LOG.isLoggable(Level.WARNING)) break;
                this.LOG.warning("Cannot convert to images: " + iae.getMessage());
                break;
            }
        }
        byteBuffer.rewind();
        return images;
    }

    private Image[] produceImagesFromBufferIntCorrectForStride(ByteBuffer byteBuffer, int bytesPerImage, int numImages, int width, int height) {
        Image[] images = new BufferedImage[numImages];
        int imgIndex = 0;
        int position = 0;
        if (this.sampleModel == null) {
            this.sampleModel = new SinglePixelPackedSampleModel(3, width, height, this.masks);
        }
        int scline = this.bytesPerPixel * width;
        int scline2 = bytesPerImage / height;
        int scplus = 0;
        if (scline != scline2) {
            scplus = scline2 - scline;
        }
        while (imgIndex < numImages && position <= byteBuffer.capacity() - bytesPerImage) {
            byte[] copyBytes = new byte[bytesPerImage];
            byteBuffer.get(copyBytes, 0, bytesPerImage);
            try {
                int[] copyInts = new int[width * height];
                int j = 0;
                for (int i = 0; i < copyBytes.length; i += this.bytesPerPixel) {
                    int p = 0;
                    for (int m = 0; m < this.masks.length; ++m) {
                        p |= copyBytes[i + m] & 0xFF;
                        if (m >= this.masks.length - 1) continue;
                        p <<= 8;
                    }
                    copyInts[j++] = p;
                    if (scplus <= 0 || (i + this.bytesPerPixel + scplus) % scline2 != 0) continue;
                    i += scplus;
                }
                DataBufferInt dataBufferInt = new DataBufferInt(copyInts, copyInts.length);
                WritableRaster raster = Raster.createWritableRaster(this.sampleModel, dataBufferInt, null);
                images[imgIndex] = new BufferedImage(this.colorModel, raster, true, null);
                ++imgIndex;
                byteBuffer.position(position += bytesPerImage);
            }
            catch (RasterFormatException rfe) {
                if (!this.LOG.isLoggable(Level.WARNING)) break;
                this.LOG.warning("Cannot convert to images, invalid raster format: " + rfe.getMessage());
                break;
            }
            catch (IllegalArgumentException iae) {
                if (!this.LOG.isLoggable(Level.WARNING)) break;
                this.LOG.warning("Cannot convert to images: " + iae.getMessage());
                break;
            }
        }
        byteBuffer.rewind();
        return images;
    }

    public static enum IMAGE_PRESETS {
        AV_24RGB_DATABUFFER_INT,
        AV_24RGB_DATABUFFER_BYTE,
        AV_32BGRA_DATABUFFER_INT,
        AV_32BGRA_DATABUFFER_BYTE,
        AV_32ARGB_DATABUFFER_INT,
        AV_32ARGB_DATABUFFER_BYTE;

    }
}

