/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.avf.player;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.AffineTransform;
import javax.swing.JPanel;
import nl.mpi.avf.player.JAVFComponent;
import nl.mpi.avf.player.TimedImage;

public class JAVFVisualComponent
extends JPanel
implements ComponentListener,
JAVFComponent {
    private Dimension naturalVideoSize;
    private AffineTransform pixelsToVideoSizeTransform = null;
    private boolean pixelToImageTransformChecked = false;
    private boolean paintBackground = false;
    private Image currentImage;
    private double currentTimeSeconds = -1.0;
    private long currentTime = -1L;
    private final double MS_SEC = 1000.0;
    private float forcedAspectRatio = -1.0f;
    private AffineTransform displayTransform = null;
    float videoScaleFactor = 1.0f;
    int vx = 0;
    int vy = 0;
    int vw = 0;
    int vh = 0;
    double vxToTlcPerc = 0.0;
    double vyToTlcPerc = 0.0;

    public JAVFVisualComponent() {
        this.setBackground(new Color(0.0f, 0.5f, 1.0f));
        this.addComponentListener(this);
    }

    @Override
    public void setImage(long time, Image image) {
        this.currentTime = time;
        this.currentTimeSeconds = (double)time / 1000.0;
        this.currentImage = image;
        if (!this.pixelToImageTransformChecked) {
            this.calculatePixelToVideoImageTransform();
        }
        if (this.displayTransform == null) {
            this.calculateTransform();
        }
        this.repaint();
    }

    @Override
    public void setNaturalVideoSize(Dimension naturalSize) {
        if (naturalSize != null) {
            this.naturalVideoSize = new Dimension(naturalSize);
            if (!this.pixelToImageTransformChecked) {
                this.calculatePixelToVideoImageTransform();
            }
            this.displayTransform = null;
        }
    }

    @Override
    public void setImage(double timeInSeconds, Image image) {
        this.currentTimeSeconds = timeInSeconds;
        this.currentTime = (long)(timeInSeconds * 1000.0);
        this.currentImage = image;
        if (!this.pixelToImageTransformChecked) {
            this.calculatePixelToVideoImageTransform();
        }
        if (this.displayTransform == null) {
            this.calculateTransform();
        }
        this.repaint();
    }

    @Override
    public void setImage(TimedImage timedImage) {
        if (timedImage != null) {
            this.setImage(timedImage.t, timedImage.img);
        }
    }

    @Override
    public long getCurrentImageTime() {
        return this.currentTime;
    }

    @Override
    public double getCurrentImageTimeSeconds() {
        return this.currentTimeSeconds;
    }

    @Override
    public Image getCurrentImage() {
        return this.currentImage;
    }

    @Override
    public void setAspectRatio(float aspectRatio) {
        if (aspectRatio == this.forcedAspectRatio) {
            return;
        }
        this.forcedAspectRatio = aspectRatio;
        this.calculatePixelToVideoImageTransform();
    }

    @Override
    public void resetAspectRatio() {
        this.forcedAspectRatio = -1.0f;
        this.calculatePixelToVideoImageTransform();
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.paintBackground) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        Graphics2D g2d = (Graphics2D)g;
        if (this.currentImage != null) {
            if (this.displayTransform == null) {
                this.calculateTransform();
            }
            if (this.displayTransform == null) {
                g2d.drawImage(this.currentImage, 0, 0, null);
            } else {
                g2d.drawImage(this.currentImage, this.displayTransform, null);
            }
        }
    }

    @Override
    protected void paintChildren(Graphics g) {
    }

    @Override
    protected void paintBorder(Graphics g) {
    }

    private void calculatePixelToVideoImageTransform() {
        if (this.naturalVideoSize != null && this.currentImage != null) {
            if (this.naturalVideoSize.width != this.currentImage.getWidth(null) || this.naturalVideoSize.height != this.currentImage.getHeight(null)) {
                double videoImageSW = this.naturalVideoSize.getWidth() / (double)this.currentImage.getWidth(null);
                double videoImageSH = this.naturalVideoSize.getHeight() / (double)this.currentImage.getHeight(null);
                this.pixelsToVideoSizeTransform = AffineTransform.getScaleInstance(videoImageSW, videoImageSH);
            }
            this.pixelToImageTransformChecked = true;
        } else {
            this.pixelsToVideoSizeTransform = null;
        }
    }

    private void calculateTransform() {
        if (this.currentImage == null) {
            return;
        }
        double srcWidth = 0.0;
        double srcHeight = 0.0;
        if (this.naturalVideoSize != null) {
            srcWidth = this.naturalVideoSize.getWidth();
            srcHeight = this.naturalVideoSize.getHeight();
        } else {
            srcWidth = this.currentImage.getWidth(null);
            srcHeight = this.currentImage.getHeight(null);
        }
        double w = (float)this.getWidth() * this.videoScaleFactor;
        double h = (float)this.getHeight() * this.videoScaleFactor;
        if (w > 0.0 && h > 0.0 && srcWidth > 0.0 && srcHeight > 0.0) {
            double hs = w / srcWidth;
            double vs = h / srcHeight;
            if (this.forcedAspectRatio == -1.0f) {
                if (vs > hs) {
                    vs = hs;
                } else if (hs > vs) {
                    hs = vs;
                }
            }
            if (this.pixelsToVideoSizeTransform != null) {
                hs *= this.pixelsToVideoSizeTransform.getScaleX();
                vs *= this.pixelsToVideoSizeTransform.getScaleY();
            }
            double xImg = (w - hs * srcWidth) / 2.0;
            double yImg = (h - vs * srcHeight) / 2.0;
            this.displayTransform = new AffineTransform(hs, 0.0, 0.0, vs, xImg, yImg);
        } else {
            this.displayTransform = null;
        }
    }

    public void setVideoScaleFactor(float scaleFactor) {
        if (scaleFactor < 1.0f || scaleFactor == this.videoScaleFactor) {
            return;
        }
        this.videoScaleFactor = scaleFactor;
        this.componentResizedOrVideoScaled();
        this.repaint();
    }

    public void setVideoBounds(int x, int y, int w, int h) {
        if (this.videoScaleFactor > 1.0f && x <= 0 && y <= 0) {
            this.moveVideoPosition(x - this.vx, y - this.vy);
        }
    }

    public int[] getVideoBounds() {
        if (this.vw != 0 && this.vh != 0) {
            return new int[]{this.vx, this.vy, this.vw, this.vh};
        }
        return new int[]{0, 0, this.getWidth(), this.getHeight()};
    }

    public void moveVideoPosition(int dx, int dy) {
        if (this.displayTransform != null && this.videoScaleFactor > 1.0f) {
            double dvw = (float)this.getWidth() * this.videoScaleFactor;
            double dvh = (float)this.getHeight() * this.videoScaleFactor;
            if (this.vw == 0) {
                this.vw = (int)dvw;
            }
            if (this.vh == 0) {
                this.vh = (int)dvh;
            }
            int nx = this.vx + dx;
            int ny = this.vy + dy;
            nx = nx > 0 ? 0 : nx;
            nx = nx + this.vw < this.getWidth() ? this.getWidth() - this.vw : nx;
            ny = ny > 0 ? 0 : ny;
            ny = ny + this.vh < this.getHeight() ? this.getHeight() - this.vh : ny;
            this.vxToTlcPerc = (double)nx / dvw;
            this.vyToTlcPerc = (double)ny / dvh;
            if (nx != this.vx && ny != this.vy) {
                this.vx = nx;
                this.vy = ny;
                this.displayTransform = new AffineTransform(this.displayTransform.getScaleX(), 0.0, 0.0, this.displayTransform.getScaleY(), (double)this.vx, (double)this.vy);
            }
            this.repaint();
        }
    }

    private void componentResizedOrVideoScaled() {
        if (this.videoScaleFactor > 1.0f) {
            this.calculateTransform();
            int nw = this.getWidth();
            int nh = this.getHeight();
            float bw = (float)nw * this.videoScaleFactor;
            float bh = (float)nh * this.videoScaleFactor;
            this.vw = (int)bw;
            this.vh = (int)bh;
            double bx = this.vxToTlcPerc * (double)bw;
            double by = this.vyToTlcPerc * (double)bh;
            bx = bx + (double)bw < (double)nw ? (double)((float)nw - bw) : bx;
            by = by + (double)bh < (double)nh ? (double)((float)nh - bh) : by;
            this.vx = (int)bx;
            this.vy = (int)by;
            if (this.displayTransform != null) {
                this.displayTransform = new AffineTransform(this.displayTransform.getScaleX(), 0.0, 0.0, this.displayTransform.getScaleY(), bx, by);
            }
            this.vxToTlcPerc = bx / (double)bw;
            this.vyToTlcPerc = by / (double)bh;
        } else {
            this.vx = 0;
            this.vy = 0;
            this.vw = this.getWidth();
            this.vh = this.getHeight();
            this.vxToTlcPerc = 0.0;
            this.vyToTlcPerc = 0.0;
            this.calculateTransform();
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.componentResizedOrVideoScaled();
        this.repaint();
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.calculateTransform();
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.naturalVideoSize != null) {
            return this.naturalVideoSize;
        }
        if (this.currentImage != null) {
            return new Dimension(this.currentImage.getWidth(null), this.currentImage.getHeight(null));
        }
        return super.getPreferredSize();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.calculateTransform();
        this.repaint();
    }
}

