/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.avf.player;

import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.mpi.avf.player.TimedImage;

public class TimedImageSequence
implements Comparable<TimedImageSequence> {
    private final Logger LOG = Logger.getLogger("AVF");
    private List<TimedImage> timeImaList;
    private double timePerImage = 0.0;
    private double mediaDuration = 0.0;

    public TimedImageSequence() {
        this.timeImaList = new ArrayList<TimedImage>(50);
    }

    public TimedImageSequence(double[] times, Image[] images) {
        this.fillList(times, images);
        this.calcTimePerImage();
    }

    public void setMediaDuration(double mediaDuration) {
        this.mediaDuration = mediaDuration;
    }

    public double getFirstTime() {
        if (this.timeImaList != null && !this.timeImaList.isEmpty()) {
            return this.timeImaList.get((int)0).t;
        }
        return -1.0;
    }

    public double getLastTime() {
        if (this.timeImaList != null && !this.timeImaList.isEmpty()) {
            return this.timeImaList.get((int)(this.timeImaList.size() - 1)).t;
        }
        return -1.0;
    }

    public boolean hasTime(double time) {
        if (this.timeImaList != null && !this.timeImaList.isEmpty()) {
            return time >= this.timeImaList.get((int)0).t && (time < this.timeImaList.get((int)(this.timeImaList.size() - 1)).t + this.timePerImage || time > this.mediaDuration - this.timePerImage && this.timeImaList.get((int)(this.timeImaList.size() - 1)).t >= this.mediaDuration - this.timePerImage);
        }
        return false;
    }

    public void setSequence(double[] times, Image[] images) {
        this.fillList(times, images);
        this.calcTimePerImage();
    }

    public Image getImageForTime(double time) {
        int index = this.indexForTime(time);
        if (index < 0) {
            return null;
        }
        return this.timeImaList.get((int)index).img;
    }

    public double getStartTimeOfImage(Image image) {
        if (this.timeImaList == null || this.timeImaList.isEmpty()) {
            return -1.0;
        }
        for (int i = 0; i < this.timeImaList.size(); ++i) {
            if (this.timeImaList.get((int)i).img != image) continue;
            return this.timeImaList.get((int)i).t;
        }
        return -1.0;
    }

    public TimedImage getTimedImageForTime(double time) {
        int index = this.indexForTime(time);
        if (index < 0) {
            return null;
        }
        return this.timeImaList.get(index);
    }

    private int indexForTime(double time) {
        if (this.timeImaList == null || this.timeImaList.isEmpty()) {
            return -1;
        }
        for (int i = 0; i < this.timeImaList.size() - 1; ++i) {
            if (!(time >= this.timeImaList.get((int)i).t) || !(time < this.timeImaList.get((int)(i + 1)).t)) continue;
            return i;
        }
        if (time >= this.timeImaList.get((int)(this.timeImaList.size() - 1)).t && time < this.timeImaList.get((int)(this.timeImaList.size() - 1)).t + this.timePerImage) {
            return this.timeImaList.size() - 1;
        }
        if (time > this.mediaDuration - this.timePerImage && this.timeImaList.get((int)(this.timeImaList.size() - 1)).t >= this.mediaDuration - this.timePerImage) {
            return this.timeImaList.size() - 1;
        }
        return -1;
    }

    private void calcTimePerImage() {
        if (this.timePerImage == 0.0 && this.timeImaList != null && this.timeImaList.size() >= 2) {
            this.timePerImage = this.timeImaList.get((int)(this.timeImaList.size() - 1)).t - this.timeImaList.get((int)(this.timeImaList.size() - 2)).t;
            if (this.timePerImage < 0.0) {
                this.timePerImage = 0.0;
            }
        }
    }

    private void fillList(double[] times, Image[] images) {
        this.timeImaList.clear();
        int numMissed = 0;
        for (int i = 0; i < times.length && i < images.length; ++i) {
            if (times[i] < 0.0) {
                if (this.LOG.isLoggable(Level.FINE) && numMissed == 0) {
                    this.LOG.fine(String.format("Image at index %d has invalid time value %f", i, times[i]));
                }
                ++numMissed;
                continue;
            }
            if (images[i] == null) {
                if (this.LOG.isLoggable(Level.FINE) && numMissed == 0) {
                    this.LOG.fine(String.format("Image at index %d is null", i));
                }
                ++numMissed;
                continue;
            }
            this.timeImaList.add(new TimedImage(times[i], images[i]));
        }
        if (this.LOG.isLoggable(Level.FINE) && numMissed > 0) {
            this.LOG.info(String.format("Sequence has %d invalid time values", numMissed));
        }
    }

    public void copySequenceTo(TimedImageSequence otherSeq) {
        if (otherSeq != null && this.timeImaList != null) {
            otherSeq.setSequence(this.timeImaList);
        }
    }

    void setSequence(List<TimedImage> timeImageList) {
        if (this.LOG.isLoggable(Level.FINE)) {
            this.LOG.fine("Updating the sequence");
        }
        if (timeImageList != null) {
            this.timeImaList.clear();
            this.timeImaList.addAll(timeImageList);
        }
    }

    public void clear() {
        if (this.timeImaList != null) {
            for (TimedImage ti : this.timeImaList) {
                ti.img.flush();
            }
            this.timeImaList.clear();
        }
    }

    @Override
    public int compareTo(TimedImageSequence otherSeq) {
        if (otherSeq == null) {
            return -1;
        }
        double d = otherSeq.getFirstTime();
        if (this.timeImaList != null && !this.timeImaList.isEmpty()) {
            if (d < 0.0) {
                return -1;
            }
            if (this.timeImaList.get((int)0).t < d) {
                return -1;
            }
            if (this.timeImaList.get((int)0).t > d) {
                return 1;
            }
        } else {
            if (d == -1.0) {
                return 0;
            }
            return 1;
        }
        return 0;
    }
}

