/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.jmmf;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JMMFFrameGrabber {
    private static final Logger LOG;
    private String mediaPath;
    private long id;
    private boolean fieldsInited = false;
    private int numBytesPerFrame;
    private int numBytesPerRow;
    private int numPixelComponents = 4;
    private int numBitsPerPixelComponent = 8;
    private int numBitsPerPixel = 32;
    private int imageWidth;
    private int imageHeight;
    private int videoWidth;
    private int videoHeight;
    private long videoDuration;
    private ByteBuffer byteBuffer;
    private ColorModel colorModel;
    private SampleModel sampleModel;
    private byte[] byteArray;
    private boolean useByteArray = false;
    final int RM = 0xFF0000;
    final int GM = 65280;
    final int BM = 255;
    int[] masks = new int[]{255, 65280, 0xFF0000};

    public JMMFFrameGrabber(String mediaPath) {
        this.mediaPath = mediaPath;
        this.id = this.initNative(mediaPath);
        if (this.id > 0L) {
            this.videoWidth = this.getVideoImageWidth(this.id);
            this.videoHeight = this.getVideoImageHeight(this.id);
            this.numBytesPerRow = this.getBytesPerRow(this.id);
            if (this.numBytesPerRow < this.videoWidth) {
                this.numBytesPerRow = this.numPixelComponents * this.videoWidth;
            }
            this.numBytesPerFrame = this.numBytesPerRow * this.videoHeight;
            if (this.getBytesPerPixel(this.id) > 1) {
                this.numBitsPerPixel = this.getBytesPerPixel(this.id) * 8;
            }
            this.numBitsPerPixelComponent = this.numBitsPerPixel / this.numPixelComponents;
            if (this.numBytesPerRow > 0 || this.videoWidth > 0 || this.videoHeight > 0) {
                this.fieldsInited = true;
            }
        } else if (LOG.isLoggable(Level.WARNING)) {
            LOG.warning("The MMFoundation based FrameGrabber could not be initialized");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized BufferedImage getVideoFrameImage(long sampleTime) {
        if (!this.fieldsInited) {
            if (!LOG.isLoggable(Level.WARNING)) return null;
            LOG.warning("No Image: the FrameGrabber was not correctly initialized");
            return null;
        }
        if (this.numBytesPerFrame == 0) {
            this.numBytesPerFrame = this.numBytesPerRow * this.imageHeight;
        }
        int numBytes = 0;
        if (this.useByteArray) {
            if (this.byteArray == null) {
                this.byteArray = new byte[this.numBytesPerFrame];
            }
            numBytes = this.grabVideoFrameBA(this.id, sampleTime, this.byteArray);
        } else {
            if (this.byteBuffer == null) {
                this.byteBuffer = ByteBuffer.allocateDirect(this.numBytesPerFrame);
            } else {
                this.byteBuffer.position(0);
            }
            numBytes = this.grabVideoFrame(this.id, sampleTime * 10000L, this.byteBuffer);
        }
        if (numBytes > 0) {
            try {
                byte[] dataBytes = null;
                if (this.useByteArray) {
                    dataBytes = this.byteArray;
                } else if (this.byteBuffer.hasArray()) {
                    dataBytes = this.byteBuffer.array();
                } else {
                    dataBytes = new byte[numBytes];
                    this.byteBuffer.get(dataBytes, 0, numBytes);
                }
                if (this.imageWidth == 0) {
                    this.imageWidth = this.videoWidth;
                }
                if (this.imageHeight != 0) return this.createImageDataBufferInt(dataBytes, this.imageWidth, this.imageHeight, this.numBitsPerPixel / this.numBitsPerPixelComponent);
                this.imageHeight = this.videoHeight;
                return this.createImageDataBufferInt(dataBytes, this.imageWidth, this.imageHeight, this.numBitsPerPixel / this.numBitsPerPixelComponent);
            }
            catch (Throwable t) {
                if (!LOG.isLoggable(Level.WARNING)) return null;
                LOG.warning("Error converting frame bytes to Java image: " + t.getMessage());
                return null;
            }
        } else {
            if (!LOG.isLoggable(Level.WARNING)) return null;
            LOG.warning("Error retrieving frame bytes from the AVFoundation image generator ");
        }
        return null;
    }

    private ColorModel createCorrespondingColorModel() {
        return new DirectColorModel(ColorSpace.getInstance(1000), 24, this.masks[0], this.masks[1], this.masks[2], 0, true, 3);
    }

    private SampleModel createCorrespondingSampleModel() {
        return new SinglePixelPackedSampleModel(3, this.imageWidth, this.imageHeight, this.masks);
    }

    private BufferedImage createImageDataBufferInt(byte[] copyBytes, int imageWidth, int imageHeight, int bytesPerPixel) {
        int[] copyInts = new int[imageWidth * imageHeight];
        int j = 0;
        for (int i = 0; i < copyBytes.length; i += bytesPerPixel) {
            int p = 0;
            for (int m = 0; m < this.masks.length; ++m) {
                p |= copyBytes[i + m] & 0xFF;
                if (m >= this.masks.length - 1) continue;
                p <<= 8;
            }
            copyInts[j++] = p;
        }
        DataBufferInt dataBufferInt = new DataBufferInt(copyInts, copyInts.length);
        if (this.sampleModel == null) {
            this.sampleModel = this.createCorrespondingSampleModel();
        }
        WritableRaster raster = Raster.createWritableRaster(this.sampleModel, dataBufferInt, null);
        if (this.colorModel == null) {
            this.colorModel = this.createCorrespondingColorModel();
        }
        return new BufferedImage(this.colorModel, raster, true, null);
    }

    public void release() {
        if (this.id > 0L) {
            this.release(this.id);
        }
    }

    public int getNumBytesPerFrame() {
        return this.numBytesPerFrame;
    }

    public int getNumBytesPerRow() {
        return this.numBytesPerRow;
    }

    public int getNumBitsPerPixel() {
        return this.numBitsPerPixel;
    }

    public int getNumBitsPerPixelComponent() {
        return this.numBitsPerPixelComponent;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public int getVideoWidth() {
        return this.videoWidth;
    }

    public int getVideoHeight() {
        return this.videoHeight;
    }

    public long getVideoDuration() {
        return this.videoDuration;
    }

    private native long initNative(String var1);

    private native int grabVideoFrame(long var1, long var3, ByteBuffer var5);

    private native int grabVideoFrameBA(long var1, long var3, byte[] var5);

    private native boolean saveFrameNative(long var1, String var3, long var4);

    private native void release(long var1);

    private native int getBytesPerRow(long var1);

    private native int getBytesPerPixel(long var1);

    private native int getVideoImageWidth(long var1);

    private native int getVideoImageHeight(long var1);

    public static native void setDebugMode(boolean var0);

    public static native boolean isDebugMode();

    static {
        block3: {
            LOG = Logger.getLogger("JMMF");
            try {
                System.loadLibrary("MMFFrameGrabber");
                String debug = System.getProperty("JMMFDebug");
                if (debug != null && debug.toLowerCase().equals("true")) {
                    JMMFFrameGrabber.setDebugMode(true);
                }
            }
            catch (Throwable t) {
                if (!LOG.isLoggable(Level.WARNING)) break block3;
                LOG.warning("Error loading native library: " + t.getMessage());
            }
        }
    }
}

