/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.jsound;

import java.io.IOException;
import javax.sound.sampled.AudioInputStream;

public class SegmentAudioInputStream
extends AudioInputStream {
    private long startSampleFrame;

    public SegmentAudioInputStream(AudioInputStream aiStream, long startTimeMicro, long endTimeMicro) throws IOException {
        super(aiStream, aiStream.getFormat(), aiStream.getFrameLength());
        long nextSkip;
        float durationMicroSec = 1000000.0f * ((float)aiStream.getFrameLength() / this.format.getFrameRate());
        float microSecFrame = durationMicroSec / (float)aiStream.getFrameLength();
        this.startSampleFrame = this.framePos = (long)((float)startTimeMicro / microSecFrame);
        long endSampleFrame = (long)((float)endTimeMicro / microSecFrame);
        if ((float)endTimeMicro % microSecFrame != 0.0f) {
            ++endSampleFrame;
        }
        this.frameLength = endSampleFrame;
        aiStream.reset();
        long startSampleByte = this.startSampleFrame * (long)aiStream.getFormat().getFrameSize();
        for (long skipped = aiStream.skip(startSampleByte); skipped < startSampleByte; skipped += nextSkip) {
            long nextReq = startSampleByte - skipped;
            nextSkip = aiStream.skip(nextReq);
        }
    }

    @Override
    public long getFrameLength() {
        return this.frameLength - this.startSampleFrame;
    }
}

