/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.player.component;

import java.awt.Component;
import java.awt.Window;
import uk.co.caprica.vlcj.factory.MediaPlayerFactory;
import uk.co.caprica.vlcj.medialist.MediaList;
import uk.co.caprica.vlcj.medialist.MediaListRef;
import uk.co.caprica.vlcj.player.component.EmbeddedMediaListPlayerComponentBase;
import uk.co.caprica.vlcj.player.component.InputEvents;
import uk.co.caprica.vlcj.player.component.MediaPlayerSpecs;
import uk.co.caprica.vlcj.player.embedded.fullscreen.FullScreenStrategy;
import uk.co.caprica.vlcj.player.list.MediaListPlayer;

public class EmbeddedMediaListPlayerComponent
extends EmbeddedMediaListPlayerComponentBase {
    private final MediaListPlayer mediaListPlayer = this.mediaPlayerFactory().mediaPlayers().newMediaListPlayer();
    private final MediaList mediaList;

    public EmbeddedMediaListPlayerComponent(MediaPlayerFactory mediaPlayerFactory, Component videoSurfaceComponent, FullScreenStrategy fullScreenStrategy, InputEvents inputEvents, Window overlay) {
        super(mediaPlayerFactory, videoSurfaceComponent, fullScreenStrategy, inputEvents, overlay);
        this.mediaListPlayer.mediaPlayer().setMediaPlayer(this.mediaPlayer());
        this.mediaListPlayer.events().addMediaListPlayerEventListener(this);
        this.mediaList = this.mediaPlayerFactory().media().newMediaList();
        this.mediaList.events().addMediaListEventListener(this);
        this.applyMediaList();
        this.onAfterConstruct();
    }

    public EmbeddedMediaListPlayerComponent(MediaPlayerSpecs.EmbeddedMediaPlayerSpec spec) {
        this(spec.factory, spec.videoSurfaceComponent, spec.fullScreenStrategy, spec.inputEvents, spec.overlay);
    }

    public EmbeddedMediaListPlayerComponent() {
        this(null, null, null, null, null);
    }

    private void applyMediaList() {
        MediaListRef mediaListRef = this.mediaList.newMediaListRef();
        try {
            this.mediaListPlayer.list().setMediaList(mediaListRef);
        }
        finally {
            mediaListRef.release();
        }
    }

    public final MediaListPlayer mediaListPlayer() {
        return this.mediaListPlayer;
    }

    @Override
    protected final void onBeforeRelease() {
        this.mediaListPlayer.release();
        this.mediaList.release();
    }
}

