/*
 * Decompiled with CFR 0.152.
 */
package mpi.dcr;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import mpi.dcr.AbstractDCSelectPanel2;
import mpi.dcr.DCRConnectorException;
import mpi.dcr.DCSmall;
import mpi.dcr.ILATDCRConnector;
import mpi.dcr.LocalDCRConnector;
import mpi.dcr.isocat.RestDCRConnector;

public class LocalDCSelectPanel
extends AbstractDCSelectPanel2 {
    protected JButton refreshButton;
    protected JButton refreshCatsButton;
    protected JButton addCatsButton;
    protected JButton removeCatsButton;
    protected JPanel buttonPanel;
    protected List<DCSmall> allDatCats;
    protected final Logger LOG = Logger.getLogger("DCR");

    public LocalDCSelectPanel(ILATDCRConnector connector) {
        super(connector);
        if (connector instanceof LocalDCRConnector) {
            this.connector = (LocalDCRConnector)connector;
        }
        this.initialize();
    }

    public LocalDCSelectPanel(ILATDCRConnector connector, ResourceBundle resBundle) {
        super(connector, resBundle);
        if (connector instanceof LocalDCRConnector) {
            this.connector = (LocalDCRConnector)connector;
        }
        this.initialize();
    }

    public LocalDCSelectPanel() {
        this.initialize();
    }

    @Override
    protected void initComponents() {
        try {
            this.allDatCats = this.connector.getDCSmallList(null, null);
            if (this.allDatCats == null) {
                this.allDatCats = new ArrayList<DCSmall>();
            }
        }
        catch (DCRConnectorException dce) {
            this.allDatCats = new ArrayList<DCSmall>();
        }
        this.setLayout(new GridBagLayout());
        this.refreshCatsButton = new JButton();
        this.addCatsButton = new JButton();
        this.removeCatsButton = new JButton();
        this.refreshButton = new JButton();
        ImageIcon refreshIcon = null;
        try {
            refreshIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Refresh16.gif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (refreshIcon != null) {
            this.refreshButton.setIcon(refreshIcon);
            this.refreshCatsButton.setIcon(refreshIcon);
        }
        this.refreshButton.addActionListener(this);
        this.refreshCatsButton.addActionListener(this);
        this.addCatsButton.addActionListener(this);
        this.removeCatsButton.addActionListener(this);
        this.buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = this.globalInsets;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        this.buttonPanel.add((Component)this.refreshCatsButton, gbc);
        gbc.anchor = 10;
        gbc.gridx = 1;
        this.buttonPanel.add((Component)this.addCatsButton, gbc);
        gbc.gridx = 2;
        this.buttonPanel.add((Component)this.removeCatsButton, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = this.globalInsets;
        gbc.fill = 0;
        gbc.anchor = 12;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        this.descPanel.add((Component)this.refreshButton, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 10;
        gbc.insets = this.globalInsets;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.weighty = 0.0;
        this.catPanel.add((Component)this.buttonPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = this.globalInsets;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.catPanel, gbc);
        gbc.gridx = 1;
        gbc.fill = 3;
        gbc.weightx = 0.0;
        this.add((Component)this.descPanel, gbc);
        this.updateLocale();
        this.updateCategories(this.allDatCats);
    }

    @Override
    protected void updateLocale() {
        super.updateLocale();
        String selCat = "Select Category";
        String addCat = "Add Categories";
        String remCat = "Remove Categories";
        String refresh = "Refresh";
        String refreshAllToolTip = "refresh categories";
        String refreshToolTip = "refresh category";
        if (this.resBundle != null) {
            try {
                selCat = this.resBundle.getString("DCR.Label.SelectCategory");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                addCat = this.resBundle.getString("DCR.Label.AddCategories");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                remCat = this.resBundle.getString("DCR.Label.RemoveCategories");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                refresh = this.resBundle.getString("DCR.Label.Refresh");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                refreshAllToolTip = this.resBundle.getString("DCR.Label.RefreshAll.ToolTip\t");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                refreshToolTip = this.resBundle.getString("DCR.Label.Refresh.ToolTip\t");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.catPanel.setBorder(new TitledBorder(selCat));
        this.addCatsButton.setText(addCat);
        this.removeCatsButton.setText(remCat);
        this.refreshCatsButton.setToolTipText(refreshAllToolTip);
        this.refreshButton.setToolTipText(refreshToolTip);
        if (this.refreshCatsButton.getIcon() == null) {
            this.refreshCatsButton.setText(refresh);
            this.refreshButton.setText(refresh);
        }
    }

    protected void selectAndAddCategories() {
    }

    protected void addCategories(List<DCSmall> dcsToAdd) {
        if (dcsToAdd != null && dcsToAdd.size() > 0) {
            ArrayList<DCSmall> addedDcs = new ArrayList<DCSmall>(dcsToAdd.size());
            DCSmall small1 = null;
            DCSmall small2 = null;
            block2: for (int i = 0; i < dcsToAdd.size(); ++i) {
                small1 = dcsToAdd.get(i);
                for (int j = 0; j < this.allDatCats.size(); ++j) {
                    small2 = this.allDatCats.get(j);
                    if (!small1.getIdentifier().equals(small2.getIdentifier())) continue;
                    this.allDatCats.set(j, small1);
                    continue block2;
                }
                addedDcs.add(small1);
            }
            if (addedDcs.size() > 0) {
                this.allDatCats.addAll(addedDcs);
                this.updateCategories(this.allDatCats);
            }
            if (this.connector instanceof LocalDCRConnector) {
                try {
                    ((LocalDCRConnector)this.connector).addDataCategories(dcsToAdd);
                }
                catch (DCRConnectorException dCRConnectorException) {
                    // empty catch block
                }
            }
        }
    }

    private void removeCategories() {
        ArrayList<DCSmall> remDatCats = new ArrayList<DCSmall>();
        Object sel = null;
        int[] rows = this.catTable.getSelectedRows();
        Arrays.sort(rows);
        if (rows != null) {
            for (int i = rows.length - 1; i >= 0; --i) {
                sel = this.catTable.getValueAt(rows[i], 0);
                if (!(sel instanceof DCSmall)) continue;
                this.allDatCats.remove(sel);
                this.catModel.removeRow(rows[i]);
                remDatCats.add((DCSmall)sel);
            }
        }
        if (remDatCats.size() > 0 && this.connector instanceof LocalDCRConnector) {
            try {
                ((LocalDCRConnector)this.connector).removeCategories(remDatCats);
            }
            catch (DCRConnectorException dCRConnectorException) {
                // empty catch block
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addCatsButton) {
            this.selectAndAddCategories();
        } else if (e.getSource() == this.removeCatsButton) {
            this.removeCategories();
        } else if (e.getSource() == this.refreshCatsButton) {
            this.refreshCatergories();
        } else if (e.getSource() == this.refreshButton) {
            this.refreshCategory();
        } else {
            super.actionPerformed(e);
        }
    }

    protected DCSmall getDC(String dcID) {
        DCSmall dc;
        block6: {
            if (dcID == null || "-".equals(dcID)) {
                return null;
            }
            if (this.connector instanceof RestDCRConnector) {
                this.remoteConnector = (RestDCRConnector)this.connector;
            } else if (this.remoteConnector == null) {
                this.remoteConnector = new RestDCRConnector();
            }
            dc = null;
            try {
                dc = this.remoteConnector.getDataCategory(dcID);
            }
            catch (DCRConnectorException dce) {
                if (!this.LOG.isLoggable(Level.INFO)) break block6;
                this.LOG.info("DCE: dcID=" + dcID + ": " + dce.getMessage());
            }
        }
        return dc;
    }

    protected void refreshCategory() {
        this.setCursor(this.BUSY_CURSOR);
        if (this.catTable.getSelectedRows().length == 1 && this.catTable.getSelectedRow() > -1) {
            DCSmall dc = (DCSmall)this.catTable.getValueAt(this.catTable.getSelectedRow(), 0);
            dc = this.getDC(dc.getId());
            this.catTable.setValueAt(dc, this.catTable.getSelectedRow(), 0);
            this.replaceDC(dc);
        }
        this.updateDescriptionPanel();
        this.setCursor(this.DEFAULT_CURSOR);
    }

    @Override
    protected void replaceDC(DCSmall dc) {
        for (int j = 0; j < this.allDatCats.size(); ++j) {
            DCSmall small2 = this.allDatCats.get(j);
            if (!dc.getIdentifier().equals(small2.getIdentifier())) continue;
            this.allDatCats.set(j, dc);
            break;
        }
        super.replaceDC(dc);
    }

    private void refreshCatergories() {
        block5: {
            ArrayList<DCSmall> dcList = new ArrayList<DCSmall>();
            this.setCursor(this.BUSY_CURSOR);
            for (int i = 0; i < this.catTable.getRowCount(); ++i) {
                DCSmall dc = (DCSmall)this.catTable.getValueAt(i, 0);
                if ((dc = this.getDC(dc.getId())) == null) continue;
                dcList.add(dc);
                this.catTable.setValueAt(dc, i, 0);
            }
            if (dcList.size() > 0) {
                this.allDatCats = dcList;
                if (this.connector instanceof LocalDCRConnector) {
                    try {
                        ((LocalDCRConnector)this.connector).addDataCategories(dcList);
                    }
                    catch (DCRConnectorException e) {
                        if (!this.LOG.isLoggable(Level.INFO)) break block5;
                        this.LOG.info("DCE: allDC's: " + e.getMessage());
                    }
                }
            }
        }
        this.updateDescriptionPanel();
        this.setCursor(this.DEFAULT_CURSOR);
    }
}

