/*
 * Decompiled with CFR 0.152.
 */
package mpi.dcr.isocat;

import java.util.ArrayList;
import java.util.List;
import mpi.dcr.DCSmall;
import mpi.dcr.isocat.DCSelection;
import mpi.dcr.isocat.Profile;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DCIF_DCS_Handler
extends DefaultHandler {
    private DCSelection selection;
    private List<DCSmall> catList;
    private DCSmall curDC;
    private Profile curProfile = null;
    private boolean inProfile = false;
    private List<Profile> curProfs = new ArrayList<Profile>();

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String p;
        Profile pp;
        if (this.inProfile && !this.curProfs.contains(pp = new Profile(null, p = new String(ch, start, length)))) {
            this.curProfs.add(pp);
        }
    }

    public DCSelection getDCSelection() {
        return this.selection;
    }

    @Override
    public void endDocument() throws SAXException {
        this.curProfs.clear();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("dcif:dataCategory")) {
            if (this.curProfs.size() > 0) {
                if (this.curProfile != null && !this.curProfs.contains(this.curProfile)) {
                    this.curProfs.add(0, this.curProfile);
                }
                this.curDC.setProfiles(this.curProfs.toArray(new Profile[0]));
                this.curProfs.clear();
            }
        } else if (qName.equals("dcif:profile")) {
            this.inProfile = false;
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.selection = new DCSelection();
        this.catList = new ArrayList<DCSmall>();
        this.selection.setDataCategories(this.catList);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equals("dcif:dataCategorySelection")) {
            String name = atts.getValue("name");
            this.selection.setName(name);
            String profNameKey = "profile:";
            if (name != null && name.startsWith(profNameKey) && name.length() > profNameKey.length()) {
                this.curProfile = new Profile(null, name.substring(profNameKey.length()).trim());
            }
        } else if (qName.equals("dcif:dataCategory")) {
            this.curDC = this.curProfile != null ? new DCSmall(this.curProfile, atts.getValue("pid"), atts.getValue("identifier")) : new DCSmall(atts.getValue("pid"), atts.getValue("identifier"));
            this.curDC.setName(atts.getValue("name"));
            this.curDC.setDesc(atts.getValue("definition"));
            this.catList.add(this.curDC);
        } else if (qName.equals("isA")) {
            DCSmall broader = null;
            broader = this.curProfile != null ? new DCSmall(this.curProfile, atts.getValue("pid"), atts.getValue("identifier")) : new DCSmall(atts.getValue("pid"), atts.getValue("identifier"));
            broader.setName(atts.getValue("name"));
            broader.setDesc(atts.getValue("definition"));
            this.curDC.setBroaderDC(broader);
            this.curDC.setBroaderDCId(broader.getId());
        } else if (qName.equals("dcif:profile")) {
            this.inProfile = true;
        }
    }
}

