/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import mpi.eudico.client.annotator.CacheSettingsChangeListener;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.PreferencesListener;
import mpi.eudico.client.annotator.util.ClientLogger;
import nl.mpi.util.FileUtility;

public class CachedDataManager
implements PreferencesListener {
    private static final CachedDataManager cachedDataManager = new CachedDataManager();
    private String cacheLocation;
    private static final Set<String> subdirectories = new HashSet<String>(){
        {
            this.add("lexica");
        }
    };
    private ArrayList<CacheSettingsChangeListener> cacheSettingsChangeListeners = new ArrayList();

    private CachedDataManager() {
        Preferences.addPreferencesListener(null, this);
        this.cacheLocation = this.getCacheLocationFromPreferences();
    }

    private String getCacheLocationFromPreferences() {
        String cacheLocationFromPreferences = Preferences.getString("CacheLocation", null);
        if (cacheLocationFromPreferences == null || cacheLocationFromPreferences.equals("") || cacheLocationFromPreferences.equals("-")) {
            cacheLocationFromPreferences = Constants.ELAN_DATA_DIR;
        } else if (cacheLocationFromPreferences.startsWith("file:")) {
            cacheLocationFromPreferences = cacheLocationFromPreferences.substring(5);
        }
        return cacheLocationFromPreferences;
    }

    public static CachedDataManager getInstance() {
        return cachedDataManager;
    }

    public String getCacheLocation() {
        return this.cacheLocation;
    }

    @Override
    public void preferencesChanged() {
        String newCacheLocation = this.getCacheLocationFromPreferences();
        if (!this.cacheLocation.equals(newCacheLocation)) {
            CachedDataManager.moveCache(this.cacheLocation, newCacheLocation);
            this.cacheLocation = newCacheLocation;
            for (CacheSettingsChangeListener listener : this.cacheSettingsChangeListeners) {
                listener.cacheSettingsChanged();
            }
        }
    }

    private static void moveCache(String oldDirectory, String newDirectory) {
        block3: {
            ClientLogger.LOG.info("Dirs: " + oldDirectory + " " + newDirectory);
            try {
                for (String subdirectory : subdirectories) {
                    File sourcePath = new File(oldDirectory + File.separator + subdirectory);
                    File destinationPath = new File(newDirectory + File.separator + subdirectory);
                    FileUtility.moveDirectory(sourcePath.toPath(), destinationPath.toPath(), null);
                }
            }
            catch (IOException e) {
                if (!ClientLogger.LOG.isLoggable(Level.WARNING)) break block3;
                ClientLogger.LOG.warning("The cache directory could not be moved (" + e.getMessage() + ")");
            }
        }
    }

    public void addCacheSettingsListener(CacheSettingsChangeListener listener) {
        this.cacheSettingsChangeListeners.add(listener);
    }

    public void removeCacheSettingsListener(CacheSettingsChangeListener listener) {
        this.cacheSettingsChangeListeners.remove(listener);
    }

    public static Boolean containsCacheSubdirs(File directory) {
        if (directory.isDirectory()) {
            String[] files = directory.list();
            HashSet<String> dirListing = new HashSet<String>(Arrays.asList(files));
            dirListing.retainAll(subdirectories);
            if (dirListing.size() > 0) {
                return true;
            }
        }
        return false;
    }
}

