/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.awt.Color;
import java.awt.Font;
import javax.swing.plaf.FontUIResource;

public class Constants {
    public static final String ELAN_INFO_URL = "https://archive.mpi.nl/tla/elan";
    public static final String ELAN_REL_NOTES_URL = "https://archive.mpi.nl/tla/elan/release-notes";
    public static final String ELAN_DOWNLOAD_URL = "https://archive.mpi.nl/tla/elan/download";
    public static final String ELAN_FORUM_URL = "https://archive.mpi.nl/forums/";
    public static final String ELAN_SUBSCRIBE_URL = "mailto:elanlist-request@mpi.nl?subject=subscribe";
    public static String USERHOME = System.getProperty("user.home");
    public static String FILESEPARATOR = System.getProperty("file.separator");
    public static String STRPROPERTIESFILE = USERHOME + FILESEPARATOR + ".elan.config";
    public static String ELAN_DATA_DIR = USERHOME + FILESEPARATOR + ".elan_data";
    public static final String LEXAN_LEXICON_DIR = "LexanLexicons";
    public static final String ANALYZER_CACHE_FOLDER_NAME = "Analyzers";
    public static Color DEFAULTBACKGROUNDCOLOR = new Color(230, 230, 230);
    public static Color DEFAULTFOREGROUNDCOLOR = Color.BLACK;
    public static Color SELECTIONCOLOR = new Color(204, 204, 255);
    public static Color CROSSHAIRCOLOR = Color.RED;
    public static Color SEGMENTATIONCOLOR = Color.BLUE;
    public static Color ACTIVEANNOTATIONCOLOR = Color.BLUE;
    public static Color MEDIAPLAYERCONTROLSLIDERSELECTIONCOLOR = Color.GRAY;
    public static Color MEDIAPLAYERCONTROLSLIDERCROSSHAIRCOLOR = Color.RED.darker();
    public static Color SIGNALSTEREOBLENDEDCOLOR1 = Color.GREEN;
    public static Color SIGNALSTEREOBLENDEDCOLOR2 = Color.BLUE;
    public static Color SIGNALCHANNELCOLOR = new Color(224, 224, 224);
    public static Color SHAREDCOLOR1 = Color.ORANGE;
    public static Color SHAREDCOLOR2 = Color.YELLOW;
    public static Color SHAREDCOLOR3 = Color.GRAY;
    public static Color SHAREDCOLOR4 = Color.WHITE;
    public static Color SHAREDCOLOR5 = new Color(128, 0, 128);
    public static Color SHAREDCOLOR6 = Color.DARK_GRAY;
    public static Color ACTIVETIERCOLOR = new Color(230, 210, 210);
    public static Color LIGHTBACKGROUNDCOLOR = new Color(240, 240, 240);
    public static final Color EVEN_ROW_BG = new Color(234, 245, 245);
    public static final Color SELECTED_ROW_BG = new Color(200, 215, 215);
    public static final Color LIGHT_YELLOW = new Color(255, 255, 192);
    public static Font DEFAULT_LF_LABEL_FONT = null;
    public static Font DEFAULTFONT = new Font("Arial Unicode MS", 0, 12);
    public static Font SMALLFONT = new Font("Arial Unicode MS", 0, 10);
    public static float SMALLFONT_SIZE = 10.0f;
    public static final float SMALLFONT_SCALE_FACTOR = 0.84f;
    public static final int LOW_RES_SCREEN_DPI = 144;
    public static final int COMBOBOX_VISIBLE_ROWS = 20;
    public static final int VISIBLE_MENUITEMS = 20;
    public static final int MAX_VISIBLE_PLAYERS = 4;
    public static final Integer BACKUP_NEVER = 0;
    public static final Integer BACKUP_1 = 60000;
    public static final Integer BACKUP_5 = 300000;
    public static final Integer BACKUP_10 = 600000;
    public static final Integer BACKUP_20 = 1200000;
    public static final Integer BACKUP_30 = 1800000;
    public static final int[] FONT_SIZES = new int[]{8, 9, 10, 12, 14, 16, 18, 24, 36, 42, 48, 60, 72};
    public static final int ONE_DIGIT = 1;
    public static final int TWO_DIGIT = 2;
    public static final int THREE_DIGIT = 3;
    public static final int HHMMSSMS = 100;
    public static final int SSMS = 101;
    public static final int MS = 102;
    public static final int HHMMSSFF = 103;
    public static final String HHMMSSMS_STRING = "hh:mm:ss.ms";
    public static final String SSMS_STRING = "ss.ms";
    public static final String MS_STRING = "ms";
    public static final String HHMMSSFF_STRING = "hh:mm:ss:ff";
    public static final String PAL_STRING = "PAL";
    public static final String PAL_50_STRING = "PAL-50fps";
    public static final String NTSC_STRING = "NTSC";
    public static final String ELAN_BEGIN_LABEL = "ELANBegin";
    public static final String ELAN_END_LABEL = "ELANEnd";
    public static final String ELAN_PARTICIPANT_LABEL = "ELANParticipant";
    public static final String TEXTANDTIME_STRING = "annotation + begintime + endtime";
    public static final String TEXT_STRING = "annotation only";
    public static final String URL_STRING = "filepath + tier name + begintime + endtime";
    public static final String CITE_STRING = "filename + tiername + begintime + endtime";

    public static void setFontScaling(float scaleFactor) {
        DEFAULTFONT = new Font(DEFAULTFONT.getFontName(), DEFAULTFONT.getStyle(), (int)Math.ceil((float)DEFAULTFONT.getSize() * scaleFactor));
        SMALLFONT_SIZE = scaleFactor * SMALLFONT_SIZE;
        SMALLFONT = new Font(SMALLFONT.getFontName(), SMALLFONT.getStyle(), (int)Math.ceil(SMALLFONT_SIZE));
    }

    public static void setDefaultFont(String fontName, int fontSize) {
        DEFAULTFONT = new Font(fontName, 0, fontSize);
        SMALLFONT_SIZE = (float)fontSize * 0.84f;
        SMALLFONT = DEFAULTFONT.deriveFont(0, SMALLFONT_SIZE);
    }

    public static void setLookAndFeelLabelFont(Font labelFont) {
        DEFAULT_LF_LABEL_FONT = labelFont instanceof FontUIResource ? new Font(labelFont.getFontName(), labelFont.getStyle(), labelFont.getSize()) : labelFont;
    }

    public static Font deriveSmallFont(Font sourceFont) {
        if (sourceFont == null) {
            return null;
        }
        return sourceFont.deriveFont(sourceFont.getSize2D() * 0.84f);
    }

    static {
        if (System.getProperty("os.name").indexOf("Mac OS") > -1) {
            ELAN_DATA_DIR = USERHOME + FILESEPARATOR + "Library" + FILESEPARATOR + "Preferences" + FILESEPARATOR + "ELAN";
        }
    }
}

