/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.awt.Desktop;
import java.awt.desktop.AboutEvent;
import java.awt.desktop.AboutHandler;
import java.awt.desktop.OpenFilesEvent;
import java.awt.desktop.OpenFilesHandler;
import java.awt.desktop.PreferencesEvent;
import java.awt.desktop.PreferencesHandler;
import java.awt.desktop.QuitEvent;
import java.awt.desktop.QuitHandler;
import java.awt.desktop.QuitResponse;
import java.io.File;
import java.util.logging.Level;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.commands.global.AboutMA;
import mpi.eudico.client.annotator.commands.global.EditPreferencesMA;
import mpi.eudico.client.annotator.commands.global.MenuAction;
import mpi.eudico.client.annotator.util.ClientLogger;

public class DesktopAppHandler {
    private static DesktopAppHandler dappHandler;
    private DesktopAdapter deskAdapter;

    private DesktopAppHandler() {
    }

    public static DesktopAppHandler getInstance() {
        if (dappHandler == null) {
            dappHandler = new DesktopAppHandler();
        }
        return dappHandler;
    }

    public void setHandlers() {
        if (this.deskAdapter == null) {
            this.deskAdapter = new DesktopAdapter();
            try {
                Desktop.getDesktop().setAboutHandler(this.deskAdapter);
            }
            catch (UnsupportedOperationException uoe) {
                ClientLogger.LOG.info(uoe.getMessage());
            }
            try {
                Desktop.getDesktop().setQuitHandler(this.deskAdapter);
            }
            catch (UnsupportedOperationException uoe) {
                ClientLogger.LOG.info(uoe.getMessage());
            }
            try {
                Desktop.getDesktop().setOpenFileHandler(this.deskAdapter);
            }
            catch (UnsupportedOperationException uoe) {
                ClientLogger.LOG.info(uoe.getMessage());
            }
            try {
                Desktop.getDesktop().setPreferencesHandler(this.deskAdapter);
            }
            catch (UnsupportedOperationException uoe) {
                ClientLogger.LOG.info(uoe.getMessage());
            }
        }
    }

    class DesktopAdapter
    implements AboutHandler,
    QuitHandler,
    PreferencesHandler,
    OpenFilesHandler {
        DesktopAdapter() {
        }

        @Override
        public void handleQuitRequestWith(QuitEvent qe, QuitResponse response) {
            if (ClientLogger.LOG.isLoggable(Level.FINE)) {
                ClientLogger.LOG.log(Level.FINE, "QuitHandler Quit");
            }
            FrameManager.getInstance().exit();
            response.cancelQuit();
        }

        @Override
        public void handleAbout(AboutEvent e) {
            if (ClientLogger.LOG.isLoggable(Level.FINE)) {
                ClientLogger.LOG.log(Level.FINE, "AboutHandler About");
            }
            AboutMA ma = new AboutMA("Menu.Help.About", (ElanFrame2)FrameManager.getInstance().getActiveFrame());
            ((MenuAction)ma).actionPerformed(null);
        }

        @Override
        public void handlePreferences(PreferencesEvent e) {
            if (ClientLogger.LOG.isLoggable(Level.FINE)) {
                ClientLogger.LOG.log(Level.FINE, "PreferencesHandler Preferences");
            }
            EditPreferencesMA ma2 = new EditPreferencesMA("Menu.Edit.Preferences.Edit", (ElanFrame2)FrameManager.getInstance().getActiveFrame());
            ((MenuAction)ma2).actionPerformed(null);
        }

        @Override
        public void openFiles(OpenFilesEvent e) {
            if (ClientLogger.LOG.isLoggable(Level.FINE)) {
                ClientLogger.LOG.log(Level.FINE, "OpenHandler Open");
            }
            for (File f : e.getFiles()) {
                try {
                    if (!f.exists() || f.isDirectory()) {
                        ClientLogger.LOG.info("Cannot open file: " + f.getName());
                        continue;
                    }
                    FrameManager.getInstance().createFrame(f.getAbsolutePath());
                }
                catch (Exception ex) {
                    ClientLogger.LOG.info("Cannot open file: " + ex.getMessage());
                }
            }
        }
    }
}

