/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import mpi.eudico.client.annotator.ElanLayoutManager;

public class DetachedFrame
extends JFrame
implements ComponentListener {
    private ElanLayoutManager layoutManager;
    private Component component;
    private float aspectRatio;
    private final int margin = 2;
    private ActionMap origActionMap;

    public DetachedFrame(ElanLayoutManager layoutManager, Component component, String title) {
        this.layoutManager = layoutManager;
        this.component = component;
        this.setAlwaysOnTop(true);
        this.setTitle(title);
        this.getContentPane().setLayout(null);
        this.getContentPane().add(component);
        this.origActionMap = this.getRootPane().getActionMap();
        this.updateShortcuts();
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        this.setDefaultCloseOperation(0);
        this.addComponentListener(this);
        this.addWindowListener(new FrameWindowListener());
    }

    public void setAspectRatio(float aspectRatio) {
        this.aspectRatio = aspectRatio;
    }

    public void updateShortcuts() {
        KeyStroke[] keys;
        InputMap rootMap = this.getRootPane().getInputMap(2);
        InputMap parentFrameMap = this.layoutManager.getElanFrame().getRootPane().getInputMap(2);
        rootMap.clear();
        for (KeyStroke ks : keys = parentFrameMap.allKeys()) {
            rootMap.put(ks, parentFrameMap.get(ks));
        }
        this.getRootPane().setActionMap(this.layoutManager.getElanFrame().getRootPane().getActionMap());
    }

    public void resetShortcutMaps() {
        InputMap rootMap = this.getRootPane().getInputMap(2);
        rootMap.clear();
        if (this.origActionMap != null) {
            this.getRootPane().setActionMap(this.origActionMap);
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.aspectRatio != 0.0f) {
            int h;
            int w = this.getContentPane().getWidth() - 4;
            if ((float)w > (float)(h = this.getContentPane().getHeight() - 4) * this.aspectRatio) {
                int xMargin = (int)(((float)w - (float)h * this.aspectRatio) / 2.0f) + 2;
                this.component.setBounds(xMargin, 2, (int)((float)h * this.aspectRatio), h);
            } else if ((float)w < (float)h * this.aspectRatio) {
                this.component.setBounds(2, 2, w, (int)((float)w / this.aspectRatio));
            }
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    private class FrameWindowListener
    extends WindowAdapter {
        private FrameWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            DetachedFrame.this.layoutManager.attach(DetachedFrame.this.component);
        }
    }
}

