/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.AnnotationNavigationPanel;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.DurationPanel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.MediaPlayerControlSlider;
import mpi.eudico.client.annotator.ModePanel;
import mpi.eudico.client.annotator.PlayButtonsPanel;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.PreferencesListener;
import mpi.eudico.client.annotator.SelectionButtonsPanel;
import mpi.eudico.client.annotator.SelectionPanel;
import mpi.eudico.client.annotator.StepAndRepeatPanel;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.VolumeIconPanel;
import mpi.eudico.client.annotator.gui.ElanSlider;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.EmptyMediaPlayer;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.client.annotator.viewer.AnnotationDensityViewer;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.client.mediacontrol.StartEvent;
import mpi.eudico.client.mediacontrol.StopEvent;
import mpi.eudico.client.mediacontrol.TimeEvent;
import nl.mpi.util.FileUtility;

public class ElanMediaPlayerController
extends AbstractViewer
implements PreferencesListener {
    private static final Dimension BUTTON_SIZE = new Dimension(30, 20);
    private long userTimeBetweenLoops = 500L;
    private ViewerManager2 vm;
    private ElanSlider rateslider;
    private ElanSlider volumeslider;
    private SelectionPanel selectionpanel;
    private VolumeIconPanel volumeIconPanel;
    private StepAndRepeatPanel stepAndRepeatPanel;
    private JPanel volumesPanel;
    private DurationPanel durationPanel;
    private AnnotationDensityViewer annotationDensityViewer;
    private PlayButtonsPanel playButtonsPanel;
    private AnnotationNavigationPanel annotationPanel;
    private SelectionButtonsPanel selectionButtonsPanel;
    private ModePanel modePanel;
    private long stopTime = 0L;
    private boolean playingSelection = false;
    private boolean bLoopMode = false;
    private boolean bSelectionMode = false;
    private boolean bBeginBoundaryActive = false;
    private boolean stepAndRepeatMode = false;
    private boolean prevHaveSliders = false;
    private LoopThread loopThread;
    private StepAndRepeatThread stepThread;
    static final String INDIVIDUAL_VOLUMES_PREFS = "IndividualPlayerVolumes";
    public static final String HAVE_INDIVIDUAL_VOLUME_CONTROLS_PREF = "Media.HaveIndividualVolumeControls";
    public static final String INDIVIDUAL_PLAYER_MUTE_SOLO_PREF = "IndividualPlayerMuteSoloSettings";
    private final String MUTE = "mute";
    private final String SOLO = "solo";
    private Map<String, Float> playerVolumes;
    private Map<String, String> playerMutedStates;
    private int deferringUpdates;
    private boolean updateWasDeferred;
    private List<ECheckBox> muteButtons;
    private List<ERadioButton> soloButtons;

    public ElanMediaPlayerController(ViewerManager2 theVM) {
        this.vm = theVM;
        this.rateslider = new ElanSlider("ELANSLIDERRATE", 0, 200, 100, this.vm);
        this.volumeslider = new ElanSlider("ELANSLIDERVOLUME", 0, 100, 100, this.vm);
        this.selectionpanel = new SelectionPanel(this.vm);
        this.durationPanel = new DurationPanel(this.vm.getMasterMediaPlayer().getMediaDuration());
        this.playButtonsPanel = new PlayButtonsPanel(this.getButtonSize(), this.vm);
        this.annotationPanel = new AnnotationNavigationPanel(this.getButtonSize(), this.vm);
        this.selectionButtonsPanel = new SelectionButtonsPanel(this.getButtonSize(), this.vm);
        this.modePanel = new ModePanel(this.vm, this);
        this.volumeIconPanel = new VolumeIconPanel(this.vm, 1, this.getButtonSize());
        this.stepAndRepeatPanel = new StepAndRepeatPanel(this.vm);
        Map<String, ?> prefs = Preferences.getMap(INDIVIDUAL_VOLUMES_PREFS, this.vm.getTranscription());
        this.playerVolumes = prefs == null ? new HashMap<String, Float>() : prefs;
        prefs = Preferences.getMap(INDIVIDUAL_PLAYER_MUTE_SOLO_PREF, this.vm.getTranscription());
        this.playerMutedStates = prefs == null ? new HashMap<String, String>() : prefs;
    }

    public Dimension getButtonSize() {
        return BUTTON_SIZE;
    }

    public long getUserTimeBetweenLoops() {
        return this.userTimeBetweenLoops;
    }

    public void setUserTimeBetweenLoops(long loopTime) {
        this.userTimeBetweenLoops = loopTime;
    }

    public MediaPlayerControlSlider getSliderPanel() {
        return this.vm.getMediaPlayerControlSlider();
    }

    public AnnotationDensityViewer getAnnotationDensityViewer() {
        if (this.annotationDensityViewer == null) {
            this.annotationDensityViewer = this.vm.createAnnotationDensityViewer();
        }
        return this.annotationDensityViewer;
    }

    public JComponent getRatePanel() {
        return this.rateslider;
    }

    @Override
    public void setRate(float rate) {
        super.setRate(rate);
        this.rateslider.setValue((int)(100.0f * rate));
    }

    public JComponent getVolumePanel() {
        return this.volumeslider;
    }

    public JComponent getPlayersVolumePanel() {
        if (this.volumesPanel == null) {
            this.makePlayersVolumePanel();
        }
        return this.volumesPanel;
    }

    @Override
    public void setVolume(float volume) {
        this.volumeslider.setValue((int)(100.0f * volume));
    }

    @Override
    public float getVolume() {
        if (this.volumeslider != null) {
            return (float)this.volumeslider.getValue() / 100.0f;
        }
        Float volume = Preferences.getFloat("MediaControlVolume", this.vm.getTranscription());
        if (volume != null) {
            return volume.floatValue();
        }
        return 1.0f;
    }

    public JPanel getModePanel() {
        return this.modePanel;
    }

    public SelectionButtonsPanel getSelectionButtonsPanel() {
        return this.selectionButtonsPanel;
    }

    public PlayButtonsPanel getPlayButtonsPanel() {
        return this.playButtonsPanel;
    }

    public AnnotationNavigationPanel getAnnotationNavigationPanel() {
        return this.annotationPanel;
    }

    public VolumeIconPanel getVolumeIconPanel() {
        return this.volumeIconPanel;
    }

    public JComponent getDurationPanel() {
        return this.durationPanel;
    }

    public JComponent getTimePanel() {
        return this.vm.getTimePanel();
    }

    public JPanel getSelectionPanel() {
        return this.selectionpanel;
    }

    public StepAndRepeatPanel getStepAndRepeatPanel() {
        return this.stepAndRepeatPanel;
    }

    @Override
    public void updateActiveAnnotation() {
    }

    @Override
    public void updateLocale() {
        if (this.muteButtons != null) {
            String muteStr = ElanLocale.getString("MediaPlayerControlPanel.VolumeSlider.Mute");
            for (ECheckBox eCheckBox : this.muteButtons) {
                eCheckBox.setText(muteStr);
            }
        }
        if (this.soloButtons != null) {
            String soloStr = ElanLocale.getString("MediaPlayerControlPanel.VolumeSlider.Solo");
            for (ERadioButton eRadioButton : this.soloButtons) {
                eRadioButton.setText(soloStr);
            }
        }
    }

    @Override
    public void updateSelection() {
    }

    private void adjustSelection() {
        long currTime = this.getMediaTime();
        long beginTime = this.getSelectionBeginTime();
        long endTime = this.getSelectionEndTime();
        if (this.bBeginBoundaryActive) {
            beginTime = currTime;
        } else {
            endTime = currTime;
        }
        if (beginTime > endTime) {
            this.setSelection(endTime, beginTime);
            this.toggleActiveSelectionBoundary();
        } else {
            this.setSelection(beginTime, endTime);
        }
    }

    @Override
    public void controllerUpdate(ControllerEvent event) {
        if (event instanceof StartEvent) {
            return;
        }
        if (event instanceof TimeEvent && System.currentTimeMillis() - this.stopTime < 700L) {
            return;
        }
        if (event instanceof StopEvent) {
            if (!this.bLoopMode) {
                // empty if block
            }
            this.stopTime = System.currentTimeMillis();
            if (this.isBeginBoundaryActive() && this.getMediaTime() == this.getSelectionEndTime()) {
                this.toggleActiveSelectionBoundary();
            }
            if (this.bSelectionMode) {
                while (this.vm.getMasterMediaPlayer().isPlayingInterval()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!this.bLoopMode && this.playingSelection) {
                    this.setPlaySelectionMode(false);
                }
                if (this.isBeginBoundaryActive() && this.getMediaTime() == this.getSelectionEndTime()) {
                    this.toggleActiveSelectionBoundary();
                }
            }
            if (!this.bSelectionMode && this.playingSelection) {
                this.setPlaySelectionMode(false);
            }
            return;
        }
        if (!this.playingSelection && this.bSelectionMode) {
            this.adjustSelection();
        }
    }

    public void setPlaySelectionMode(boolean b) {
        if (b && this.playingSelection) {
            int count = 0;
            while (this.playingSelection && count < 400) {
                ++count;
                try {
                    Thread.sleep(5L);
                }
                catch (Throwable throwable) {}
            }
        }
        this.playingSelection = b;
    }

    public boolean isPlaySelectionMode() {
        return this.playingSelection;
    }

    public void setLoopMode(boolean b) {
        this.bLoopMode = b;
        this.modePanel.updateLoopMode(this.bLoopMode);
    }

    public boolean getLoopMode() {
        return this.bLoopMode;
    }

    public void doToggleLoopMode() {
        this.bLoopMode = !this.bLoopMode;
    }

    public boolean getSelectionMode() {
        return this.bSelectionMode;
    }

    public void doToggleSelectionMode() {
        this.bSelectionMode = !this.bSelectionMode;
        this.modePanel.updateSelectionMode(this.bSelectionMode);
        this.getModePanel().revalidate();
    }

    public void toggleActiveSelectionBoundary() {
        this.bBeginBoundaryActive = !this.bBeginBoundaryActive;
        this.selectionButtonsPanel.updateBoundary();
    }

    public boolean isBeginBoundaryActive() {
        return this.bBeginBoundaryActive;
    }

    public void startLoop(long begin, long end) {
        if (this.loopThread != null && this.loopThread.isAlive()) {
            this.loopThread.stopLoop();
        }
        this.loopThread = new LoopThread(begin, end);
        this.loopThread.start();
    }

    public void stopLoop() {
        this.setPlaySelectionMode(false);
        if (this.loopThread != null && this.loopThread.isAlive()) {
            this.loopThread.stopLoop();
        }
    }

    public void setStepAndRepeatMode(boolean mode) {
        if (this.stepAndRepeatMode == mode) {
            return;
        }
        if (this.stepAndRepeatMode) {
            this.stepAndRepeatMode = false;
            if (this.stepThread != null) {
                try {
                    this.stepThread.interrupt();
                }
                catch (Exception ie) {
                    ie.printStackTrace();
                }
            }
            this.playButtonsPanel.setEnabled(true);
            this.selectionButtonsPanel.setEnabled(true);
            this.stepAndRepeatPanel.setPlayIcon(true);
        } else {
            this.playButtonsPanel.setEnabled(false);
            this.selectionButtonsPanel.setEnabled(false);
            this.stepAndRepeatPanel.setPlayIcon(false);
            this.stepAndRepeatMode = mode;
            this.playingSelection = false;
            this.bLoopMode = false;
            this.stepThread = new StepAndRepeatThread();
            this.stepThread.start();
        }
    }

    public boolean isStepAndRepeatMode() {
        return this.stepAndRepeatMode;
    }

    @Override
    public void preferencesChanged() {
        boolean newHaveSliders;
        Float rate;
        Float volume = Preferences.getFloat("MediaControlVolume", this.vm.getTranscription());
        if (volume != null) {
            this.setVolume(volume.floatValue());
        }
        if ((rate = Preferences.getFloat("MediaControlRate", this.vm.getTranscription())) != null) {
            this.setRate(rate.floatValue());
        }
        if (this.volumesPanel != null && (newHaveSliders = this.haveSliders()) != this.prevHaveSliders) {
            if (!newHaveSliders) {
                this.vm.getVolumeManager().setSimpleVolumes();
            }
            this.updatePlayersVolumePanel();
        }
    }

    private void makePlayersVolumePanel() {
        this.volumesPanel = new JPanel();
        this.volumesPanel.setLayout(new GridBagLayout());
        Border inner = BorderFactory.createEmptyBorder(0, 40, 0, 0);
        this.volumesPanel.setBorder(inner);
        this.deferringUpdates = 0;
        this.updateWasDeferred = false;
        this.updatePlayersVolumePanel();
    }

    public void deferUpdatePlayersVolumePanel(boolean defer) {
        if (defer) {
            ++this.deferringUpdates;
        } else {
            --this.deferringUpdates;
            if (this.deferringUpdates <= 0 && this.updateWasDeferred) {
                this.updatePlayersVolumePanel();
            }
        }
    }

    public void updatePlayersVolumePanel() {
        if (this.deferringUpdates > 0) {
            this.updateWasDeferred = true;
            return;
        }
        this.updateWasDeferred = false;
        if (this.volumesPanel == null) {
            return;
        }
        this.volumesPanel.removeAll();
        this.prevHaveSliders = this.haveSliders();
        if (!this.prevHaveSliders) {
            return;
        }
        this.muteButtons = new ArrayList<ECheckBox>();
        this.soloButtons = new ArrayList<ERadioButton>();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.anchor = 23;
        this.addOneVolumeSlider(this.vm.getMasterMediaPlayer(), gbc);
        for (ElanMediaPlayer mp : this.vm.getConnectedMediaPlayers()) {
            this.addOneVolumeSlider(mp, gbc);
        }
        this.updateLocale();
    }

    private void addOneVolumeSlider(final ElanMediaPlayer mp, GridBagConstraints gbc) {
        float volume;
        if (mp instanceof EmptyMediaPlayer) {
            return;
        }
        String name = mp.getMediaDescriptor().mediaURL;
        final String fileName = FileUtility.fileNameFromPath(name);
        JLabel label = new JLabel(fileName);
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.gridwidth = 2;
        gbc.gridheight = 1;
        this.volumesPanel.add((Component)label, gbc);
        ECheckBox muteButton = new ECheckBox();
        ERadioButton soloButton = new ERadioButton();
        muteButton.setSelected(mp.getMute());
        muteButton.setFont(Constants.deriveSmallFont(muteButton.getFont()));
        soloButton.setFont(muteButton.getFont());
        ++gbc.gridy;
        gbc.gridwidth = 1;
        this.volumesPanel.add((Component)muteButton, gbc);
        gbc.gridx = 1;
        this.volumesPanel.add((Component)soloButton, gbc);
        this.muteButtons.add(muteButton);
        this.soloButtons.add(soloButton);
        if (this.playerVolumes.containsKey(fileName)) {
            volume = this.playerVolumes.get(fileName).floatValue();
            this.vm.getVolumeManager().setSubVolume(mp, volume);
        } else {
            volume = mp.getSubVolume();
            this.playerVolumes.put(fileName, Float.valueOf(volume));
        }
        final JSlider slider = new JSlider(0, 100, (int)(100.0f * volume));
        slider.putClientProperty("JComponent.sizeVariant", "mini");
        slider.setMajorTickSpacing(25);
        slider.setMinorTickSpacing(5);
        slider.setPaintLabels(true);
        slider.setPaintTicks(true);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                JSlider s = (JSlider)event.getSource();
                float newVolume = (float)s.getValue() / 100.0f;
                ElanMediaPlayerController.this.vm.getVolumeManager().setSubVolume(mp, newVolume);
                if (!s.getValueIsAdjusting()) {
                    ElanMediaPlayerController.this.playerVolumes.put(fileName, Float.valueOf(newVolume));
                    Preferences.set(ElanMediaPlayerController.INDIVIDUAL_VOLUMES_PREFS, ElanMediaPlayerController.this.playerVolumes, ElanMediaPlayerController.this.vm.getTranscription(), false, false);
                }
            }
        });
        gbc.gridx = 2;
        gbc.weightx = 1.0;
        gbc.gridheight = 2;
        --gbc.gridy;
        this.volumesPanel.add((Component)slider, gbc);
        gbc.gridy += 2;
        if (this.playerMutedStates.containsKey(fileName)) {
            String value = this.playerMutedStates.get(fileName);
            if ("solo".equals(value)) {
                soloButton.setSelected(true);
            } else if ("mute".equals(value)) {
                muteButton.setSelected(true);
                this.vm.getVolumeManager().setMute(mp, true);
                slider.setEnabled(false);
            }
        }
        muteButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ECheckBox source = (ECheckBox)e.getSource();
                boolean selected = e.getStateChange() == 1;
                ElanMediaPlayerController.this.vm.getVolumeManager().setMute(mp, selected);
                slider.setEnabled(!selected);
                if (selected) {
                    ElanMediaPlayerController.this.playerMutedStates.put(fileName, "mute");
                } else if (!"solo".equals(ElanMediaPlayerController.this.playerMutedStates.get(fileName))) {
                    ElanMediaPlayerController.this.playerMutedStates.remove(fileName);
                }
                Preferences.set(ElanMediaPlayerController.INDIVIDUAL_PLAYER_MUTE_SOLO_PREF, ElanMediaPlayerController.this.playerMutedStates, ElanMediaPlayerController.this.vm.getTranscription(), false, false);
                if (source.wasNotExpected(selected)) {
                    for (ERadioButton box : ElanMediaPlayerController.this.soloButtons) {
                        box.setSelected(false);
                    }
                }
            }
        });
        soloButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                block8: {
                    boolean selected;
                    ERadioButton source = (ERadioButton)e.getSource();
                    boolean bl = selected = e.getStateChange() == 1;
                    if (selected) {
                        ElanMediaPlayerController.this.playerMutedStates.put(fileName, "solo");
                    } else if (!"mute".equals(ElanMediaPlayerController.this.playerMutedStates.get(fileName))) {
                        ElanMediaPlayerController.this.playerMutedStates.remove(fileName);
                    }
                    Preferences.set(ElanMediaPlayerController.INDIVIDUAL_PLAYER_MUTE_SOLO_PREF, ElanMediaPlayerController.this.playerMutedStates, ElanMediaPlayerController.this.vm.getTranscription(), false, false);
                    if (!source.wasNotExpected(selected)) break block8;
                    if (selected) {
                        for (int i = 0; i < ElanMediaPlayerController.this.soloButtons.size(); ++i) {
                            ERadioButton solobox = (ERadioButton)ElanMediaPlayerController.this.soloButtons.get(i);
                            if (source == solobox) {
                                ((ECheckBox)ElanMediaPlayerController.this.muteButtons.get(i)).setSelected(false);
                                continue;
                            }
                            ((ECheckBox)ElanMediaPlayerController.this.muteButtons.get(i)).setSelected(true);
                            solobox.setSelected(false);
                        }
                    } else {
                        for (ECheckBox box : ElanMediaPlayerController.this.muteButtons) {
                            box.setSelected(false);
                        }
                    }
                }
            }
        });
    }

    private boolean haveSliders() {
        Boolean boolPref = Preferences.getBool(HAVE_INDIVIDUAL_VOLUME_CONTROLS_PREF, null);
        boolean haveVolumeControls = true;
        if (boolPref != null) {
            haveVolumeControls = boolPref;
        }
        return haveVolumeControls;
    }

    private static class ECheckBox
    extends JCheckBox {
        private boolean expectedValue = false;

        ECheckBox() {
        }

        @Override
        public void setSelected(boolean val) {
            this.expectedValue = val;
            super.setSelected(val);
        }

        public boolean wasNotExpected(boolean selected) {
            boolean was = selected != this.expectedValue;
            this.expectedValue = selected;
            return was;
        }
    }

    private static class ERadioButton
    extends JRadioButton {
        private boolean expectedValue = false;

        ERadioButton() {
        }

        @Override
        public void setSelected(boolean val) {
            this.expectedValue = val;
            super.setSelected(val);
        }

        public boolean wasNotExpected(boolean selected) {
            boolean was = selected != this.expectedValue;
            this.expectedValue = selected;
            return was;
        }
    }

    private class LoopThread
    extends Thread {
        private long beginTime;
        private long endTime;
        private boolean stopLoop = false;

        LoopThread(long begin, long end) {
            this.beginTime = begin;
            this.endTime = end;
        }

        public void stopLoop() {
            this.stopLoop = true;
        }

        @Override
        public void run() {
            while (!this.stopLoop && ElanMediaPlayerController.this.getLoopMode()) {
                if (!ElanMediaPlayerController.this.playerIsPlaying()) {
                    ElanMediaPlayerController.this.playInterval(this.beginTime, this.endTime);
                    while (!ElanMediaPlayerController.this.playerIsPlaying()) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException ie) {
                            return;
                        }
                    }
                }
                while (ElanMediaPlayerController.this.playerIsPlaying()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!this.stopLoop) continue;
                    return;
                }
                try {
                    Thread.sleep(ElanMediaPlayerController.this.getUserTimeBetweenLoops());
                }
                catch (Exception exception) {}
            }
        }
    }

    class StepAndRepeatThread
    extends Thread {
        private long interval = 2000L;
        private long repeats = 3L;
        private long step = 1000L;
        private long pauseBetweenLoops = 500L;
        private long begin;
        private long end;
        private long ultimateEnd;
        private long count = 0L;

        public StepAndRepeatThread() {
            this.begin = ElanMediaPlayerController.this.stepAndRepeatPanel.getBeginTime() < 0L ? ElanMediaPlayerController.this.getMediaTime() : ElanMediaPlayerController.this.stepAndRepeatPanel.getBeginTime();
            if (this.begin == ElanMediaPlayerController.this.getMediaDuration()) {
                this.begin = 0L;
            }
            this.interval = ElanMediaPlayerController.this.stepAndRepeatPanel.getIntervalDuration();
            this.end = this.begin + this.interval;
            this.repeats = ElanMediaPlayerController.this.stepAndRepeatPanel.getNumRepeats();
            this.step = ElanMediaPlayerController.this.stepAndRepeatPanel.getStepSize();
            this.pauseBetweenLoops = ElanMediaPlayerController.this.stepAndRepeatPanel.getPauseDuration();
            if (ElanMediaPlayerController.this.stepAndRepeatPanel.getEndTime() <= 0L) {
                this.ultimateEnd = ElanMediaPlayerController.this.getMediaDuration();
            } else {
                this.ultimateEnd = ElanMediaPlayerController.this.stepAndRepeatPanel.getEndTime();
                if (this.ultimateEnd < this.begin + this.interval) {
                    this.ultimateEnd = this.begin + this.interval;
                    if (this.ultimateEnd > ElanMediaPlayerController.this.getMediaDuration()) {
                        this.ultimateEnd = ElanMediaPlayerController.this.getMediaDuration();
                        this.interval = this.ultimateEnd - this.begin;
                    }
                }
            }
        }

        @Override
        public void run() {
            if (!ElanMediaPlayerController.this.playerIsPlaying()) {
                ElanMediaPlayerController.this.playInterval(this.begin, this.end);
                while (!ElanMediaPlayerController.this.playerIsPlaying()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException ie) {
                        return;
                    }
                }
            }
            while (!this.isInterrupted()) {
                if (!ElanMediaPlayerController.this.playerIsPlaying()) {
                    if (this.isInterrupted()) {
                        return;
                    }
                    ElanMediaPlayerController.this.playInterval(this.begin, this.end);
                    while (!ElanMediaPlayerController.this.playerIsPlaying()) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException ie) {
                            return;
                        }
                    }
                }
                while (ElanMediaPlayerController.this.playerIsPlaying()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException ex) {
                        try {
                            ElanMediaPlayerController.this.vm.getMasterMediaPlayer().stop();
                            return;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!this.isInterrupted()) continue;
                    try {
                        ElanMediaPlayerController.this.vm.getMasterMediaPlayer().stop();
                        return;
                    }
                    catch (Exception ex) {
                    }
                }
                try {
                    Thread.sleep(this.pauseBetweenLoops);
                }
                catch (Exception ex) {
                    break;
                }
                ++this.count;
                if (this.count != this.repeats) continue;
                this.begin += this.step;
                if (this.begin >= this.ultimateEnd) break;
                this.end += this.step;
                if (this.end > this.ultimateEnd) {
                    this.end = this.ultimateEnd;
                } else if (this.ultimateEnd - this.end < this.step) {
                    this.end = this.ultimateEnd;
                }
                if (this.end - this.begin < 100L) break;
                this.count = 0L;
            }
            ElanMediaPlayerController.this.setStepAndRepeatMode(false);
        }
    }
}

