/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.ACMTranscriptionStore;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.multilangcv.LangInfo;

public class SaveAs27Preferences {
    public static int saveAsType(TranscriptionImpl t) {
        boolean saveAsOld = false;
        Boolean pref = Preferences.getBool("SaveAsOldEAF2_7", null);
        if (pref != null) {
            saveAsOld = pref;
        }
        int saveAsType = saveAsOld ? 4 : 0;
        return saveAsType;
    }

    public static int saveAsType(Transcription t) {
        TranscriptionImpl ti = t instanceof TranscriptionImpl ? (TranscriptionImpl)t : null;
        return SaveAs27Preferences.saveAsType(ti);
    }

    public static int saveAsTypeWithCheck(TranscriptionImpl t) {
        boolean lossIsOk;
        boolean saveWillLose;
        int saveAsType = SaveAs27Preferences.saveAsType(t);
        if (saveAsType == 4 && t != null && (saveWillLose = SaveAs27Preferences.savingWillLoseInformation(t)) && !(lossIsOk = SaveAs27Preferences.askIfLosingInformationIsOk())) {
            return 0;
        }
        return saveAsType;
    }

    public static int saveAsTypeWithCheck(Transcription t) {
        if (t instanceof TranscriptionImpl) {
            return SaveAs27Preferences.saveAsTypeWithCheck((TranscriptionImpl)t);
        }
        return SaveAs27Preferences.saveAsType(t);
    }

    public static boolean askIfLosingInformationIsOk() {
        Boolean pref = Preferences.getBool("SaveAsOldEAF2_7.DontAskAgain", null);
        if (pref != null && pref.booleanValue()) {
            return true;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            return SaveAs27Preferences.askIfOk();
        }
        class MutableBoolean {
            boolean reply;

            MutableBoolean() {
            }
        }
        final MutableBoolean helper = new MutableBoolean();
        helper.reply = false;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){
                {
                }

                @Override
                public void run() {
                    helper.reply = SaveAs27Preferences.askIfOk();
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return helper.reply;
    }

    private static boolean askIfOk() {
        JCheckBox dontShowAgainCB = new JCheckBox(ElanLocale.getString("Message.DontShow"));
        String message = ElanLocale.getString("SaveAs2_7.LosesInformation");
        String title = ElanLocale.getString("SaveAs2_7.AreYouSure");
        Object[] params = new Object[]{message, dontShowAgainCB};
        int answer = JOptionPane.showConfirmDialog(null, params, title, 0);
        boolean dont = dontShowAgainCB.isSelected();
        Preferences.set("SaveAsOldEAF2_7.DontAskAgain", dont, null, false, false);
        return answer == 0;
    }

    public static Object adjustPreferencesForSavingFormat(Transcription t, int format) {
        switch (format) {
            case 4: {
                return SaveAs27Preferences.convert2_7CVEntryPreferences((TranscriptionImpl)t, false, true);
            }
        }
        return null;
    }

    public static Object adjustPreferencesAfterLoadingFormat(Transcription t, int format) {
        switch (format) {
            case 4: {
                return SaveAs27Preferences.convert2_7CVEntryPreferences((TranscriptionImpl)t, true, false);
            }
            case 0: {
                if (Preferences.get("CV.Prefs", t) != null) {
                    Preferences.set("CV.Prefs", null, t, false, false);
                }
                return null;
            }
        }
        return null;
    }

    public static Object adjustPreferencesAfterLoadingFormat(TranscriptionImpl t) {
        String trPathName = t.getPathName();
        int format = 0;
        try {
            int version = ACMTranscriptionStore.eafFileFormatTaster(trPathName);
            format = version <= 14 ? 4 : 0;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return SaveAs27Preferences.adjustPreferencesAfterLoadingFormat(t, format);
    }

    public static void restoreAdjustedPreferences(Transcription t, Object undoprefs) {
        if (undoprefs instanceof Map) {
            Map p = (Map)undoprefs;
            for (Map.Entry entry : p.entrySet()) {
                Preferences.set((String)entry.getKey(), entry.getValue(), t, false, false);
            }
        }
    }

    private static Object convert2_7CVEntryPreferences(TranscriptionImpl t, boolean oldToNew, boolean mix) {
        String toPrefKey;
        String fromPrefKey;
        Object prefs;
        if (oldToNew && (prefs = Preferences.get("CV.ML.Prefs", t)) != null) {
            return null;
        }
        if (oldToNew) {
            fromPrefKey = "CV.Prefs";
            toPrefKey = "CV.ML.Prefs";
        } else {
            fromPrefKey = "CV.ML.Prefs";
            toPrefKey = "CV.Prefs";
        }
        HashMap oldPrefs = new HashMap();
        Map<String, ?> fromPrefs = Preferences.getMap(fromPrefKey, t);
        if (fromPrefs != null) {
            Map<String, ?> frommap = fromPrefs;
            HashMap tomap = new HashMap();
            Set<String> cvNames = frommap.keySet();
            for (String cvName : cvNames) {
                ControlledVocabulary cv = t.getControlledVocabulary(cvName);
                if (cv == null) continue;
                Map fromCvEntries = (Map)frommap.get(cvName);
                HashMap toCvEntries = new HashMap();
                Set entryKeys = fromCvEntries.keySet();
                for (String fromKey : entryKeys) {
                    CVEntry cve;
                    Object entryPrefs = fromCvEntries.get(fromKey);
                    String toKey = null;
                    if (oldToNew) {
                        cve = cv.getEntryWithValue(0, fromKey);
                        if (cve != null) {
                            toKey = cve.getId();
                        }
                    } else {
                        cve = cv.getEntrybyId(fromKey);
                        if (cve != null) {
                            toKey = cve.getValue(0);
                        }
                    }
                    if (toKey != null) {
                        toCvEntries.put(toKey, entryPrefs);
                        continue;
                    }
                    if (mix) continue;
                    toCvEntries.put(fromKey, entryPrefs);
                }
                tomap.put(cvName, toCvEntries);
            }
            Preferences.set(toPrefKey, tomap, t, false, false);
            oldPrefs.put(toPrefKey, null);
            if (!mix) {
                Preferences.set(fromPrefKey, null, t, false, false);
                oldPrefs.put(fromPrefKey, fromPrefs);
            }
        }
        return oldPrefs;
    }

    public static boolean savingWillLoseInformation(Transcription theTranscription) {
        TranscriptionImpl ti = (TranscriptionImpl)theTranscription;
        if (ti.getLicenses() != null && !ti.getLicenses().isEmpty()) {
            return true;
        }
        for (ControlledVocabulary controlledVocabulary : ti.getControlledVocabularies()) {
            if (controlledVocabulary.getNumberOfLanguages() > 1) {
                return true;
            }
            LangInfo li = controlledVocabulary.getLangInfo(0);
            if (!li.getId().equals("und")) {
                return true;
            }
            if (!li.getLongId().equals("http://cdb.iso.org/lg/CDB-00130975-001")) {
                return true;
            }
            if (li.getLabel().equals("undetermined (und)")) continue;
            return true;
        }
        for (Tier tier : ti.getTiers()) {
            if (SaveAs27Preferences.isNotEmpty(tier.getLangRef())) {
                return true;
            }
            if (!SaveAs27Preferences.isNotEmpty(tier.getExtRef())) continue;
            return true;
        }
        return false;
    }

    private static boolean isNotEmpty(String s) {
        return s != null && !s.isEmpty();
    }
}

