/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.PreferencesUser;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.client.mediacontrol.StopEvent;
import mpi.eudico.client.mediacontrol.TimeEvent;
import mpi.eudico.util.TimeFormatter;

public class TimePanel
extends AbstractViewer
implements ActionListener,
PreferencesUser {
    private JLabel timeLabel;
    private JPopupMenu popup;
    private ButtonGroup formatBG;
    private JMenu formatMenu;
    private JRadioButtonMenuItem hhmmssmsMI;
    private JRadioButtonMenuItem timecodePalMI;
    private JRadioButtonMenuItem timecodePal50MI;
    private JRadioButtonMenuItem timecodeNtscMI;
    private JRadioButtonMenuItem msMI;
    private JRadioButtonMenuItem secMI;
    private final int TC = 0;
    private final int TC_PAL = 1;
    private final int TC_NTSC = 2;
    private final int MS = 3;
    private final int SEC = 4;
    private final int TC_PAL_50 = 5;
    private int mode = 0;

    public TimePanel() {
        this.setLayout(new BorderLayout());
        this.timeLabel = new JLabel("00:00:00.000");
        this.timeLabel.setFont(Constants.deriveSmallFont(this.timeLabel.getFont()));
        this.addMouseListener(new TimeLabelMouseHandler());
        this.add((Component)this.timeLabel, "Center");
        this.updateLocale();
        this.setVisible(true);
    }

    @Override
    public void controllerUpdate(ControllerEvent event) {
        if (event instanceof TimeEvent || event instanceof StopEvent) {
            this.updateLabel();
        }
    }

    public void updateLabel() {
        switch (this.mode) {
            case 3: {
                this.timeLabel.setText(String.valueOf(this.getMediaTime()));
                break;
            }
            case 1: {
                this.timeLabel.setText(TimeFormatter.toTimecodePAL(this.getMediaTime()));
                break;
            }
            case 2: {
                this.timeLabel.setText(TimeFormatter.toTimecodeNTSC(this.getMediaTime()));
                break;
            }
            case 4: {
                this.timeLabel.setText(TimeFormatter.toSSMSString(this.getMediaTime()));
                break;
            }
            case 5: {
                this.timeLabel.setText(TimeFormatter.toTimecodePAL50(this.getMediaTime()));
                break;
            }
            default: {
                this.timeLabel.setText(TimeFormatter.toString(this.getMediaTime()));
            }
        }
        this.repaint();
    }

    public void showCrosshairTimeInputBox() {
        boolean bAgain = true;
        while (bAgain) {
            String strNewTime = JOptionPane.showInputDialog(this, ElanLocale.getString("MediaPlayerControlPanel.MediaTimeInputBoxNewTime"), ElanLocale.getString("MediaPlayerControlPanel.MediaTimeInputBoxTitle"), -1);
            if (strNewTime != null && !strNewTime.equals("")) {
                long lngSeconds = TimeFormatter.toMilliSeconds(strNewTime);
                if ((double)lngSeconds >= 0.0) {
                    this.setMediaTime(lngSeconds);
                    bAgain = false;
                } else {
                    String inputFormatMessage = ElanLocale.getString("TimeCodeFormat.TimeCode");
                    try {
                        inputFormatMessage = String.format(ElanLocale.getString("MediaPlayerControlPanel.MediaTimeInputBoxFormats"), ElanLocale.getString("TimeCodeFormat.TimeCode"), ElanLocale.getString("TimeCodeFormat.Seconds"), ElanLocale.getString("TimeCodeFormat.MilliSec"));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    JOptionPane.showMessageDialog(this, ElanLocale.getString("MediaPlayerControlPanel.MediaTimeInputBoxFormatError1") + "\n" + String.format(ElanLocale.getString("MediaPlayerControlPanel.MediaTimeInputBoxFormatError2"), inputFormatMessage), ElanLocale.getString("MediaPlayerControlPanel.MediaTimeInputBoxErrorTitle"), 0);
                    bAgain = true;
                }
            }
            if (strNewTime != null) continue;
            break;
        }
    }

    private void createPopupMenu() {
        this.popup = new JPopupMenu();
        this.formatBG = new ButtonGroup();
        this.formatMenu = new JMenu();
        this.hhmmssmsMI = new JRadioButtonMenuItem();
        this.timecodePalMI = new JRadioButtonMenuItem();
        this.timecodePal50MI = new JRadioButtonMenuItem();
        this.timecodeNtscMI = new JRadioButtonMenuItem();
        this.msMI = new JRadioButtonMenuItem();
        this.secMI = new JRadioButtonMenuItem();
        this.formatBG.add(this.hhmmssmsMI);
        this.formatBG.add(this.timecodePalMI);
        this.formatBG.add(this.timecodePal50MI);
        this.formatBG.add(this.timecodeNtscMI);
        this.formatBG.add(this.secMI);
        this.formatBG.add(this.msMI);
        this.hhmmssmsMI.setSelected(this.mode == 0);
        this.timecodePalMI.setSelected(this.mode == 1);
        this.timecodePal50MI.setSelected(this.mode == 5);
        this.timecodeNtscMI.setSelected(this.mode == 2);
        this.secMI.setSelected(this.mode == 4);
        this.msMI.setSelected(this.mode == 3);
        this.hhmmssmsMI.addActionListener(this);
        this.timecodePalMI.addActionListener(this);
        this.timecodePal50MI.addActionListener(this);
        this.timecodeNtscMI.addActionListener(this);
        this.secMI.addActionListener(this);
        this.msMI.addActionListener(this);
        this.popup.add(this.formatMenu);
        this.formatMenu.add(this.hhmmssmsMI);
        this.formatMenu.add(this.timecodePalMI);
        this.formatMenu.add(this.timecodePal50MI);
        this.formatMenu.add(this.timecodeNtscMI);
        this.formatMenu.add(this.secMI);
        this.formatMenu.add(this.msMI);
        this.updateLocale();
    }

    @Override
    public void updateLocale() {
        if (this.popup != null) {
            this.formatMenu.setText(ElanLocale.getString("TimeCodeFormat.Label.TimeFormat"));
            this.hhmmssmsMI.setText(ElanLocale.getString("TimeCodeFormat.TimeCode"));
            this.timecodePalMI.setText(ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.PAL"));
            this.timecodePal50MI.setText(ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.PAL50"));
            this.timecodeNtscMI.setText(ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.NTSC"));
            this.msMI.setText(ElanLocale.getString("TimeCodeFormat.MilliSec"));
            this.secMI.setText(ElanLocale.getString("TimeCodeFormat.Seconds"));
        }
    }

    @Override
    public void updateActiveAnnotation() {
    }

    @Override
    public void updateSelection() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.timecodePalMI.isSelected()) {
            this.mode = 1;
            this.setPreference("TimePanel.TimeFormat", "PAL", this.getViewerManager().getTranscription());
        } else if (this.timecodePal50MI.isSelected()) {
            this.mode = 5;
            this.setPreference("TimePanel.TimeFormat", "PAL-50fps", this.getViewerManager().getTranscription());
        } else if (this.timecodeNtscMI.isSelected()) {
            this.mode = 2;
            this.setPreference("TimePanel.TimeFormat", "NTSC", this.getViewerManager().getTranscription());
        } else if (this.msMI.isSelected()) {
            this.mode = 3;
            this.setPreference("TimePanel.TimeFormat", "ms", this.getViewerManager().getTranscription());
        } else if (this.secMI.isSelected()) {
            this.mode = 4;
            this.setPreference("TimePanel.TimeFormat", "ss.ms", this.getViewerManager().getTranscription());
        } else {
            this.mode = 0;
            this.setPreference("TimePanel.TimeFormat", "hh:mm:ss.ms", this.getViewerManager().getTranscription());
        }
        this.updateLabel();
    }

    @Override
    public void preferencesChanged() {
        String timeformat = Preferences.getString("TimePanel.TimeFormat", this.getViewerManager().getTranscription());
        if (timeformat != null) {
            if (timeformat.equals("hh:mm:ss.ms")) {
                this.mode = 0;
            } else if (timeformat.equals("PAL")) {
                this.mode = 1;
            } else if (timeformat.equals("PAL-50fps")) {
                this.mode = 5;
            } else if (timeformat.equals("NTSC")) {
                this.mode = 2;
            } else if (timeformat.equals("ms")) {
                this.mode = 3;
            } else if (timeformat.equals("ss.ms")) {
                this.mode = 4;
            }
            this.updateLabel();
        }
    }

    private class TimeLabelMouseHandler
    extends MouseAdapter {
        private TimeLabelMouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
                return;
            }
            TimePanel.this.showCrosshairTimeInputBox();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Point pp = e.getPoint();
            if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
                if (TimePanel.this.popup == null) {
                    TimePanel.this.createPopupMenu();
                }
                TimePanel.this.popup.show(TimePanel.this, pp.x, pp.y);
            }
        }
    }
}

