/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mpi.eudico.client.annotator.ActiveAnnotation;
import mpi.eudico.client.annotator.ActiveAnnotationListener;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanMediaPlayerController;
import mpi.eudico.client.annotator.MediaPlayerControlSlider;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.PreferencesListener;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.SelectionListener;
import mpi.eudico.client.annotator.TierOrder;
import mpi.eudico.client.annotator.TimePanel;
import mpi.eudico.client.annotator.TimeScale;
import mpi.eudico.client.annotator.TimeScaleListener;
import mpi.eudico.client.annotator.TimeScaleUser;
import mpi.eudico.client.annotator.VolumeManager;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.grid.GridViewer;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.EmptyMediaPlayer;
import mpi.eudico.client.annotator.player.NoPlayerException;
import mpi.eudico.client.annotator.player.PlayerFactory;
import mpi.eudico.client.annotator.player.WAVSamplerFactory;
import mpi.eudico.client.annotator.recognizer.gui.RecognizerPanel;
import mpi.eudico.client.annotator.search.result.viewer.ElanResultViewer;
import mpi.eudico.client.annotator.transcriptionMode.TranscriptionViewer;
import mpi.eudico.client.annotator.turnsandscenemode.TurnsAndSceneViewer;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.client.annotator.viewer.AnnotationDensityViewer;
import mpi.eudico.client.annotator.viewer.CommentViewer;
import mpi.eudico.client.annotator.viewer.InterlinearViewer;
import mpi.eudico.client.annotator.viewer.LexiconEntryViewer;
import mpi.eudico.client.annotator.viewer.MetadataViewer;
import mpi.eudico.client.annotator.viewer.MultiTierControlPanel;
import mpi.eudico.client.annotator.viewer.MultiTierViewer;
import mpi.eudico.client.annotator.viewer.SegmentationViewer2;
import mpi.eudico.client.annotator.viewer.SignalViewer;
import mpi.eudico.client.annotator.viewer.SignalViewerControlPanel;
import mpi.eudico.client.annotator.viewer.SingleTierViewer;
import mpi.eudico.client.annotator.viewer.SingleTierViewerPanel;
import mpi.eudico.client.annotator.viewer.SubtitleViewer;
import mpi.eudico.client.annotator.viewer.TextViewer;
import mpi.eudico.client.annotator.viewer.TimeLineViewer;
import mpi.eudico.client.annotator.viewer.TimeSeriesViewer;
import mpi.eudico.client.annotator.viewer.Viewer;
import mpi.eudico.client.mediacontrol.Controller;
import mpi.eudico.client.mediacontrol.ControllerListener;
import mpi.eudico.client.mediacontrol.PeriodicUpdateController;
import mpi.eudico.client.mediacontrol.TimeEvent;
import mpi.eudico.client.mediacontrol.TimeLineController;
import mpi.eudico.client.util.WAVSamplesProvider;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.event.ACMEditListener;
import nl.mpi.util.FileUtility;

public class ViewerManager2 {
    private static final long SIGNAL_VIEWER_PERIOD = 50L;
    private static final long TIME_LINE_VIEWER_PERIOD = 50L;
    private static final long INTERLINEAR_VIEWER_PERIOD = 100L;
    private static final long MEDIA_CONTROL_PANEL_PERIOD = 100L;
    private ElanMediaPlayer masterMediaPlayer;
    private ElanMediaPlayer signalSourcePlayer;
    private SignalViewer signalViewer;
    private RecognizerPanel recognizerPanel;
    private TranscriptionImpl transcription;
    private Selection selection;
    private TimeScale timeScale;
    private ActiveAnnotation activeAnnotation;
    private TierOrder tierOrder;
    private ElanMediaPlayerController mediaPlayerController;
    private AnnotationDensityViewer annotationDensityViewer;
    private MediaPlayerControlSlider mediaPlayerControlSlider;
    private TimePanel timePanel;
    private MultiTierControlPanel multiTierControlPanel;
    private SignalViewerControlPanel signalViewerControlPanel;
    private List<ElanMediaPlayer> connectedMediaPlayers;
    private List<ElanMediaPlayer> disabledMediaPlayers;
    private Map<Object, Controller> controllers;
    private List<AbstractViewer> viewers;
    private List<AbstractViewer> enabledViewers;
    private List<AbstractViewer> disabledViewers;
    private MetadataViewer metadataViewer;
    private GridViewer gridViewer;
    private TimeLineViewer timeLineViewer;
    private TextViewer textViewer;
    private LexiconEntryViewer lexiconViewer;
    private CommentViewer commentViewer;
    private TurnsAndSceneViewer turnsAndSceneViewer;
    private List<SubtitleViewer> subtitleViewers;
    private InterlinearViewer interlinearViewer;
    private TranscriptionViewer transcriptionViewer;
    private String signalMediaURL;
    private List<String> audioPaths;
    private List<String> videoPaths;
    private List<String> otherMediaPaths;
    private VolumeManager volumeManager;
    public static final int MAX_NUM_VIDEO_PLAYERS = 2;
    public static final int MAX_NUM_AUDIO_PLAYERS = 1;

    public ViewerManager2(TranscriptionImpl transcription) {
        this.transcription = transcription;
        this.masterMediaPlayer = new EmptyMediaPlayer(Integer.MAX_VALUE);
        this.selection = new Selection();
        this.timeScale = new TimeScale();
        this.activeAnnotation = new ActiveAnnotation();
        this.createTierOrderObject();
        this.connectedMediaPlayers = new ArrayList<ElanMediaPlayer>();
        this.disabledMediaPlayers = new ArrayList<ElanMediaPlayer>();
        this.controllers = new HashMap<Object, Controller>();
        this.viewers = new ArrayList<AbstractViewer>();
        this.subtitleViewers = new ArrayList<SubtitleViewer>();
        this.enabledViewers = new ArrayList<AbstractViewer>();
        this.disabledViewers = new ArrayList<AbstractViewer>();
        this.audioPaths = new ArrayList<String>();
        this.videoPaths = new ArrayList<String>();
        this.otherMediaPaths = new ArrayList<String>();
    }

    private void createTierOrderObject() {
        this.tierOrder = new TierOrder(this.transcription);
        this.connectListener(this.tierOrder);
        List<TierImpl> tiers = this.transcription.getTiers();
        List<String> tierOrderList = Preferences.getListOfString("MultiTierViewer.TierOrder", this.transcription);
        if (tierOrderList != null) {
            for (int i = 0; i < tierOrderList.size(); ++i) {
                TierImpl tierImpl = this.transcription.getTierWithId(tierOrderList.get(i));
                if (tierImpl != null) continue;
                tierOrderList.remove(i);
                --i;
            }
            for (Tier tier : tiers) {
                if (tierOrderList.contains(tier.getName())) continue;
                tierOrderList.add(tier.getName());
            }
        } else {
            tierOrderList = new ArrayList<String>();
            for (Tier tier : tiers) {
                tierOrderList.add(tier.getName());
            }
        }
        if (tierOrderList instanceof ArrayList) {
            this.tierOrder.setTierOrder(tierOrderList);
        } else {
            this.tierOrder.setTierOrder(new ArrayList<String>(tierOrderList));
        }
    }

    public Transcription getTranscription() {
        return this.transcription;
    }

    public Selection getSelection() {
        return this.selection;
    }

    public TimeScale getTimeScale() {
        return this.timeScale;
    }

    public ActiveAnnotation getActiveAnnotation() {
        return this.activeAnnotation;
    }

    public TierOrder getTierOrder() {
        return this.tierOrder;
    }

    public void setMasterMediaPlayer(ElanMediaPlayer player) {
        if (player == this.masterMediaPlayer) {
            return;
        }
        float rate = this.masterMediaPlayer.getRate();
        for (ElanMediaPlayer mp : this.connectedMediaPlayers) {
            this.masterMediaPlayer.removeController(mp);
        }
        for (Controller c : this.controllers.values()) {
            this.masterMediaPlayer.removeController(c);
        }
        this.connectedMediaPlayers.remove(player);
        this.disabledMediaPlayers.remove(player);
        this.connectedMediaPlayers.add(this.masterMediaPlayer);
        this.masterMediaPlayer = player;
        for (ElanMediaPlayer mp : this.connectedMediaPlayers) {
            this.masterMediaPlayer.addController(mp);
        }
        for (Controller c : this.controllers.values()) {
            this.masterMediaPlayer.addController(c);
        }
        for (AbstractViewer v : this.viewers) {
            v.setPlayer(this.masterMediaPlayer);
        }
        this.masterMediaPlayer.setRate(rate);
        this.getVolumeManager().setSimpleVolumes();
        if (this.mediaPlayerController != null) {
            this.mediaPlayerController.updatePlayersVolumePanel();
        }
    }

    public ElanMediaPlayer createMediaPlayer(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        ElanMediaPlayer player = PlayerFactory.createElanMediaPlayer(mediaDescriptor);
        if (player == null) {
            return null;
        }
        this.addMediaPlayer(player);
        return player;
    }

    public ElanMediaPlayer createMediaPlayer(MediaDescriptor mediaDescriptor, String preferredMediaFramework) throws NoPlayerException {
        if (preferredMediaFramework == null) {
            return this.createMediaPlayer(mediaDescriptor);
        }
        ElanMediaPlayer player = null;
        StringBuilder errors = new StringBuilder();
        try {
            player = PlayerFactory.createElanMediaPlayer(mediaDescriptor, preferredMediaFramework);
            if (player == null) {
                errors.append(String.format("A player of the requested framework \"%s\" could not be created on this platform\n", preferredMediaFramework));
                return this.createMediaPlayer(mediaDescriptor);
            }
        }
        catch (NoPlayerException npe) {
            errors.append(npe.getMessage() + "\n");
            try {
                return this.createMediaPlayer(mediaDescriptor);
            }
            catch (NoPlayerException np) {
                errors.append(np.getMessage() + "\n");
            }
        }
        if (player == null) {
            throw new NoPlayerException(errors.toString());
        }
        this.addMediaPlayer(player);
        return player;
    }

    public void addMediaPlayer(ElanMediaPlayer player) {
        if (player == null || this.connectedMediaPlayers.contains(player) || player == this.masterMediaPlayer) {
            return;
        }
        ElanLocale.addElanLocaleListener(this.transcription, player);
        this.connectListener(player);
        player.setRate(this.masterMediaPlayer.getRate());
        this.getVolumeManager().setSubVolume(player, 0.0f);
        this.masterMediaPlayer.addController(player);
        this.connectedMediaPlayers.add(player);
        if (this.mediaPlayerController != null) {
            this.mediaPlayerController.updatePlayersVolumePanel();
        }
    }

    public void destroyMediaPlayer(ElanMediaPlayer player) {
        if (player == this.masterMediaPlayer) {
            return;
        }
        ElanLocale.removeElanLocaleListener(player);
        this.disconnectListener(player);
        this.masterMediaPlayer.removeController(player);
        this.connectedMediaPlayers.remove(player);
        this.disabledMediaPlayers.remove(player);
        player.cleanUpOnClose();
        player = null;
        if (this.mediaPlayerController != null) {
            this.mediaPlayerController.updatePlayersVolumePanel();
        }
    }

    public void enableMediaPlayer(ElanMediaPlayer player) {
        if (this.disabledMediaPlayers.contains(player)) {
            this.masterMediaPlayer.addController(player);
            this.connectedMediaPlayers.add(player);
            this.disabledMediaPlayers.remove(player);
            if (this.mediaPlayerController != null) {
                this.mediaPlayerController.updatePlayersVolumePanel();
            }
        }
    }

    public void disableMediaPlayer(ElanMediaPlayer player) {
        if (this.connectedMediaPlayers.contains(player)) {
            this.masterMediaPlayer.removeController(player);
            this.connectedMediaPlayers.remove(player);
            this.disabledMediaPlayers.add(player);
            if (this.mediaPlayerController != null) {
                this.mediaPlayerController.updatePlayersVolumePanel();
            }
        }
    }

    public void enableDisabledMediaPlayers() {
        for (ElanMediaPlayer mp : this.disabledMediaPlayers) {
            this.masterMediaPlayer.addController(mp);
        }
        this.connectedMediaPlayers.addAll(this.disabledMediaPlayers);
        this.disabledMediaPlayers.clear();
        if (this.mediaPlayerController != null) {
            this.mediaPlayerController.updatePlayersVolumePanel();
        }
    }

    public void disableConnectedMediaPlayers() {
        for (ElanMediaPlayer mp : this.connectedMediaPlayers) {
            this.masterMediaPlayer.removeController(mp);
        }
        this.disabledMediaPlayers.addAll(this.connectedMediaPlayers);
        this.connectedMediaPlayers.clear();
        if (this.mediaPlayerController != null) {
            this.mediaPlayerController.updatePlayersVolumePanel();
        }
    }

    public void setSignalSourcePlayer(ElanMediaPlayer player) {
        this.signalSourcePlayer = player;
    }

    public long getSignalViewerOffset() {
        long offset = 0L;
        if (this.signalSourcePlayer != null) {
            offset = this.signalSourcePlayer.getOffset();
        }
        return offset;
    }

    public SignalViewer getSignalViewer() {
        return this.signalViewer;
    }

    public void setOffset(ElanMediaPlayer player, long offset) {
        player.setOffset(offset);
        if (player == this.signalSourcePlayer && this.signalViewer != null) {
            this.signalViewer.setOffset(offset);
        }
        this.transcription.setChanged();
    }

    public ElanMediaPlayer getMasterMediaPlayer() {
        return this.masterMediaPlayer;
    }

    public List<ElanMediaPlayer> getConnectedMediaPlayers() {
        return this.connectedMediaPlayers;
    }

    public ElanMediaPlayerController getMediaPlayerController() {
        if (this.mediaPlayerController == null) {
            this.mediaPlayerController = new ElanMediaPlayerController(this);
            PeriodicUpdateController controller = this.getControllerForPeriod(100L);
            this.controllers.put(this.mediaPlayerController, controller);
            this.connect(this.mediaPlayerController);
            this.viewers.add(this.mediaPlayerController);
            this.enabledViewers.add(this.mediaPlayerController);
        }
        return this.mediaPlayerController;
    }

    public void destroyElanMediaPlayerController() {
        if (this.mediaPlayerController != null) {
            this.destroyViewer(this.mediaPlayerController);
            this.mediaPlayerController = null;
        }
    }

    public VolumeManager getVolumeManager() {
        if (this.volumeManager == null) {
            this.volumeManager = new VolumeManager(this);
        }
        return this.volumeManager;
    }

    public void destroyVolumeManager() {
        if (this.volumeManager != null) {
            this.volumeManager = null;
        }
    }

    public MediaPlayerControlSlider getMediaPlayerControlSlider() {
        if (this.mediaPlayerControlSlider == null) {
            this.mediaPlayerControlSlider = new MediaPlayerControlSlider();
            PeriodicUpdateController controller = this.getControllerForPeriod(100L);
            this.controllers.put(this.mediaPlayerControlSlider, controller);
            this.connect(this.mediaPlayerControlSlider);
            this.viewers.add(this.mediaPlayerControlSlider);
            this.enabledViewers.add(this.mediaPlayerControlSlider);
        }
        return this.mediaPlayerControlSlider;
    }

    public AnnotationDensityViewer createAnnotationDensityViewer() {
        if (this.annotationDensityViewer == null) {
            this.annotationDensityViewer = new AnnotationDensityViewer(this.transcription);
            this.annotationDensityViewer.setTierOrderObject(this.tierOrder);
            PeriodicUpdateController controller = this.getControllerForPeriod(100L);
            this.controllers.put(this.annotationDensityViewer, controller);
            this.connect(this.annotationDensityViewer);
            this.viewers.add(this.annotationDensityViewer);
            this.enabledViewers.add(this.annotationDensityViewer);
        }
        return this.annotationDensityViewer;
    }

    public AnnotationDensityViewer getAnnotationDensityViewer() {
        return this.annotationDensityViewer;
    }

    public TimePanel getTimePanel() {
        if (this.timePanel == null) {
            this.timePanel = new TimePanel();
            PeriodicUpdateController controller = this.getControllerForPeriod(100L);
            this.controllers.put(this.timePanel, controller);
            this.connect(this.timePanel);
            this.viewers.add(this.timePanel);
            this.enabledViewers.add(this.timePanel);
        }
        return this.timePanel;
    }

    public Viewer createViewer(String className, long controllerPeriod) {
        Viewer viewer = null;
        try {
            viewer = (Viewer)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            viewer.setViewerManager(this);
            if (viewer instanceof AbstractViewer) {
                PeriodicUpdateController controller = this.getControllerForPeriod(controllerPeriod);
                this.controllers.put(viewer, controller);
                this.connect((AbstractViewer)viewer);
                this.viewers.add((AbstractViewer)viewer);
                this.enabledViewers.add((AbstractViewer)viewer);
            } else if (viewer instanceof ControllerListener) {
                this.getControllerForPeriod(controllerPeriod).addControllerListener((ControllerListener)((Object)viewer));
            }
        }
        catch (Exception e) {
            System.out.println("Could not create viewer: " + className + ": " + e.getMessage());
        }
        return viewer;
    }

    public void connectListener(Object listener) {
        if (listener instanceof ControllerListener) {
            this.getControllerForPeriod(100L).addControllerListener((ControllerListener)listener);
        }
        if (listener instanceof SelectionListener) {
            this.selection.addSelectionListener((SelectionListener)listener);
        }
        if (listener instanceof ActiveAnnotationListener) {
            this.activeAnnotation.addActiveAnnotationListener((ActiveAnnotationListener)listener);
        }
        if (listener instanceof TimeScaleListener) {
            this.timeScale.addTimeScaleListener((TimeScaleListener)listener);
        }
        if (listener instanceof ACMEditListener) {
            try {
                this.transcription.addACMEditListener((ACMEditListener)listener);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (listener instanceof PreferencesListener) {
            Preferences.addPreferencesListener(this.transcription, (PreferencesListener)listener);
        }
    }

    public void disconnectListener(Object listener) {
        if (listener instanceof ControllerListener) {
            this.getControllerForPeriod(100L).removeControllerListener((ControllerListener)listener);
        }
        if (listener instanceof SelectionListener) {
            this.selection.removeSelectionListener((SelectionListener)listener);
        }
        if (listener instanceof ActiveAnnotationListener) {
            this.activeAnnotation.removeActiveAnnotationListener((ActiveAnnotationListener)listener);
        }
        if (listener instanceof TimeScaleListener) {
            this.timeScale.removeTimeScaleListener((TimeScaleListener)listener);
        }
        if (listener instanceof ACMEditListener) {
            try {
                this.transcription.removeACMEditListener((ACMEditListener)listener);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (listener instanceof PreferencesListener) {
            Preferences.removePreferencesListener(this.transcription, (PreferencesListener)listener);
        }
    }

    public SignalViewerControlPanel getSignalViewerControlPanel() {
        if (this.signalViewerControlPanel == null) {
            return this.createSignalViewerControlPanel();
        }
        return this.signalViewerControlPanel;
    }

    public SignalViewerControlPanel createSignalViewerControlPanel() {
        if (this.signalViewerControlPanel == null) {
            this.signalViewerControlPanel = new SignalViewerControlPanel(((ElanFrame2)ELANCommandFactory.getRootFrame(this.transcription)).getWaveFormViewerMenuManager());
        }
        return this.signalViewerControlPanel;
    }

    public void destroySignalViewerControlPanel() {
        if (this.signalViewerControlPanel != null) {
            this.signalViewerControlPanel = null;
        }
    }

    public MultiTierControlPanel getMultiTierControlPanel() {
        if (this.multiTierControlPanel == null) {
            return this.createMultiTierControlPanel();
        }
        return this.multiTierControlPanel;
    }

    public MultiTierControlPanel createMultiTierControlPanel() {
        if (this.multiTierControlPanel == null) {
            this.multiTierControlPanel = new MultiTierControlPanel(this.transcription, this.tierOrder);
            ElanLocale.addElanLocaleListener(this.transcription, this.multiTierControlPanel);
            Preferences.addPreferencesListener(this.transcription, this.multiTierControlPanel);
        }
        return this.multiTierControlPanel;
    }

    public void destroyMultiTierControlPanel() {
        if (this.multiTierControlPanel != null) {
            Preferences.removePreferencesListener(this.transcription, this.multiTierControlPanel);
            ElanLocale.removeElanLocaleListener(this.multiTierControlPanel);
            this.multiTierControlPanel = null;
        }
    }

    public TimeLineViewer createTimeLineViewer() {
        this.timeLineViewer = new TimeLineViewer(this.transcription);
        PeriodicUpdateController controller = this.getControllerForPeriod(50L);
        this.controllers.put(this.timeLineViewer, controller);
        this.connect(this.timeLineViewer);
        this.viewers.add(this.timeLineViewer);
        this.enabledViewers.add(this.timeLineViewer);
        return this.timeLineViewer;
    }

    public TimeLineViewer getTimeLineViewer() {
        return this.timeLineViewer;
    }

    public InterlinearViewer createInterlinearViewer() {
        Boolean val = Preferences.getBool("Menu.View.Viewers.InterLinear", null);
        if (val == null || val.booleanValue()) {
            if (this.interlinearViewer == null) {
                this.interlinearViewer = new InterlinearViewer(this.transcription);
                PeriodicUpdateController controller = this.getControllerForPeriod(100L);
                this.controllers.put(this.interlinearViewer, controller);
                this.connect(this.interlinearViewer);
                this.viewers.add(this.interlinearViewer);
                this.enabledViewers.add(this.interlinearViewer);
            }
            return this.interlinearViewer;
        }
        return null;
    }

    public InterlinearViewer getInterlinearViewer() {
        return this.interlinearViewer;
    }

    public String getSignalMediaURL() {
        return this.signalMediaURL;
    }

    public void setAudioPaths(List<String> audioPath) {
        this.audioPaths.clear();
        if (audioPath != null) {
            for (String path : audioPath) {
                if (this.audioPaths.contains(path = FileUtility.urlToAbsPath(path))) continue;
                this.audioPaths.add(path);
            }
        }
    }

    public List<String> getAudioPaths() {
        return this.audioPaths;
    }

    public void setVideoPaths(List<String> videoPath) {
        this.videoPaths.clear();
        if (videoPath != null) {
            for (String path : videoPath) {
                if (this.videoPaths.contains(path = FileUtility.urlToAbsPath(path))) continue;
                this.videoPaths.add(path);
            }
        }
    }

    public List<String> getVideoPaths() {
        return this.videoPaths;
    }

    public void setOtherMediaPaths(List<String> otherPath) {
        this.otherMediaPaths.clear();
        if (otherPath != null) {
            for (String path : otherPath) {
                if (this.otherMediaPaths.contains(path = FileUtility.urlToAbsPath(path))) continue;
                this.otherMediaPaths.add(path);
            }
        }
    }

    public List<String> getOtherMediaPaths() {
        return this.otherMediaPaths;
    }

    public SignalViewer createSignalViewer() {
        Boolean val = Preferences.getBool("Menu.View.Viewers.Signal", null);
        if (val == null || val.booleanValue()) {
            if (this.signalViewer == null && this.signalMediaURL != null) {
                this.createSignalViewer(this.signalMediaURL);
                if (this.signalViewer != null) {
                    this.signalViewer.setOffset(this.getSignalViewerOffset());
                    this.signalViewer.preferencesChanged();
                }
            }
            return this.signalViewer;
        }
        return null;
    }

    public SignalViewer createSignalViewer(String mediaURL) {
        Boolean val;
        SignalViewer viewer = null;
        if (mediaURL != null) {
            this.signalMediaURL = mediaURL;
        }
        if ((val = Preferences.getBool("Menu.View.Viewers.Signal", null)) != null && !val.booleanValue()) {
            return viewer;
        }
        WAVSamplesProvider sampler = WAVSamplerFactory.createWAVSamplesProvider(mediaURL);
        if (sampler != null) {
            viewer = new SignalViewer(sampler);
            PeriodicUpdateController controller = this.getControllerForPeriod(50L);
            this.controllers.put(viewer, controller);
            this.connect(viewer);
            this.viewers.add(viewer);
            this.enabledViewers.add(viewer);
            this.signalViewer = viewer;
        }
        return viewer;
    }

    public void updateSignalViewerMedia(String mediaURL) {
        if (mediaURL != null) {
            this.signalMediaURL = mediaURL;
        }
    }

    public TranscriptionViewer createTranscriptionViewer() {
        this.transcriptionViewer = new TranscriptionViewer(this);
        PeriodicUpdateController controller = this.getControllerForPeriod(100L);
        this.controllers.put(this.transcriptionViewer, controller);
        this.connect(this.transcriptionViewer);
        this.viewers.add(this.transcriptionViewer);
        this.enabledViewers.add(this.transcriptionViewer);
        return this.transcriptionViewer;
    }

    public TranscriptionViewer getTranscriptionViewer() {
        return this.transcriptionViewer;
    }

    public GridViewer createGridViewer() {
        Boolean val = Preferences.getBool("Menu.View.Viewers.Grid", null);
        if (val == null || val.booleanValue()) {
            if (this.gridViewer == null) {
                this.gridViewer = new GridViewer();
                this.connect(this.gridViewer);
                this.viewers.add(this.gridViewer);
                this.enabledViewers.add(this.gridViewer);
            }
            return this.gridViewer;
        }
        return null;
    }

    public GridViewer getGridViewer() {
        return this.gridViewer;
    }

    public ElanResultViewer createSearchResultViewer() {
        ElanResultViewer viewer = new ElanResultViewer();
        this.connect(viewer);
        this.viewers.add(viewer);
        this.enabledViewers.add(viewer);
        return viewer;
    }

    public SubtitleViewer createSubtitleViewer() {
        Boolean val = Preferences.getBool("Menu.View.Viewers.Subtitles", null);
        if (val == null || val.booleanValue()) {
            SubtitleViewer subtitleViewer = new SubtitleViewer();
            this.connect(subtitleViewer);
            this.viewers.add(subtitleViewer);
            this.enabledViewers.add(subtitleViewer);
            this.subtitleViewers.add(subtitleViewer);
            return subtitleViewer;
        }
        return null;
    }

    public List<SubtitleViewer> getSubtitleViewers() {
        return this.subtitleViewers;
    }

    public TextViewer createTextViewer() {
        Boolean val = Preferences.getBool("Menu.View.Viewers.Text", null);
        if (val == null || val.booleanValue()) {
            if (this.textViewer == null) {
                this.textViewer = new TextViewer();
                this.connect(this.textViewer);
                this.viewers.add(this.textViewer);
                this.enabledViewers.add(this.textViewer);
            }
            return this.textViewer;
        }
        return null;
    }

    public TextViewer getTextViewer() {
        return this.textViewer;
    }

    public SegmentationViewer2 createSegmentationViewer() {
        SegmentationViewer2 viewer = new SegmentationViewer2(this.transcription);
        PeriodicUpdateController controller = this.getControllerForPeriod(50L);
        this.controllers.put(viewer, controller);
        this.connect(viewer);
        this.viewers.add(viewer);
        this.enabledViewers.add(viewer);
        return viewer;
    }

    public TimeSeriesViewer createTimeSeriesViewer() {
        TimeSeriesViewer viewer = new TimeSeriesViewer(this.transcription);
        PeriodicUpdateController controller = this.getControllerForPeriod(50L);
        this.controllers.put(viewer, controller);
        this.connect(viewer);
        this.viewers.add(viewer);
        this.enabledViewers.add(viewer);
        return viewer;
    }

    public void connectViewer(AbstractViewer viewer, boolean connect) {
        if (viewer == null) {
            return;
        }
        if (connect) {
            if (viewer instanceof TimeSeriesViewer) {
                this.controllers.put(viewer, this.getControllerForPeriod(50L));
            } else if (viewer instanceof SignalViewer) {
                this.controllers.put(viewer, this.getControllerForPeriod(50L));
            }
            this.connect(viewer);
            this.viewers.add(viewer);
            this.enabledViewers.add(viewer);
            this.disabledViewers.remove(viewer);
        } else {
            this.disconnect(viewer, false);
            this.enabledViewers.remove(viewer);
            this.disabledViewers.add(viewer);
        }
    }

    public MetadataViewer createMetadataViewer() {
        Boolean val = Preferences.getBool("Menu.View.Viewers.MetaData", null);
        if (val == null || val.booleanValue()) {
            if (this.metadataViewer == null) {
                this.metadataViewer = new MetadataViewer(this);
                ElanLocale.addElanLocaleListener(this.transcription, this.metadataViewer);
                Preferences.addPreferencesListener(this.transcription, this.metadataViewer);
            }
            return this.metadataViewer;
        }
        return null;
    }

    public MetadataViewer getMetadataViewer() {
        return this.metadataViewer;
    }

    public void destroyMetaDataViewer() {
        if (this.metadataViewer != null) {
            ElanLocale.removeElanLocaleListener(this.metadataViewer);
            Preferences.removePreferencesListener(this.transcription, this.metadataViewer);
            this.metadataViewer = null;
        }
    }

    public RecognizerPanel createRecognizerPanel() {
        Boolean val = Preferences.getBool("Menu.View.Viewers.Recognizer", null);
        if (val == null || val.booleanValue()) {
            if (this.recognizerPanel == null) {
                boolean o;
                boolean a = this.audioPaths != null && !this.audioPaths.isEmpty();
                boolean v = this.videoPaths != null && !this.videoPaths.isEmpty();
                boolean bl = o = this.otherMediaPaths != null && !this.otherMediaPaths.isEmpty();
                if (a || v || o) {
                    this.recognizerPanel = new RecognizerPanel(this);
                    if (a) {
                        this.recognizerPanel.setAudioFilePaths(this.audioPaths);
                    }
                    if (v) {
                        this.recognizerPanel.setVideoFilePaths(this.videoPaths);
                    }
                    if (o) {
                        this.recognizerPanel.setOtherFilePaths(this.otherMediaPaths);
                    }
                    ElanLocale.addElanLocaleListener(this.transcription, this.recognizerPanel);
                }
            }
            return this.recognizerPanel;
        }
        return null;
    }

    public RecognizerPanel getRecognizerPanel() {
        return this.recognizerPanel;
    }

    public LexiconEntryViewer createLexiconEntryViewer() {
        this.lexiconViewer = new LexiconEntryViewer();
        this.connect(this.lexiconViewer);
        this.viewers.add(this.lexiconViewer);
        this.enabledViewers.add(this.lexiconViewer);
        return this.lexiconViewer;
    }

    public LexiconEntryViewer getLexiconViewer() {
        return this.lexiconViewer;
    }

    public CommentViewer createCommentViewer(Transcription transcription) {
        this.commentViewer = new CommentViewer((TranscriptionImpl)transcription);
        PeriodicUpdateController controller = this.getControllerForPeriod(50L);
        this.controllers.put(this.commentViewer, controller);
        this.connect(this.commentViewer);
        this.viewers.add(this.commentViewer);
        this.enabledViewers.add(this.commentViewer);
        if (this.multiTierControlPanel != null) {
            this.multiTierControlPanel.addViewer(this.commentViewer);
        }
        return this.commentViewer;
    }

    public CommentViewer getCommentViewer() {
        return this.commentViewer;
    }

    public TurnsAndSceneViewer createTurnsAndSceneViewer() {
        this.turnsAndSceneViewer = new TurnsAndSceneViewer(this.transcription);
        PeriodicUpdateController controller = this.getControllerForPeriod(100L);
        this.controllers.put(this.turnsAndSceneViewer, controller);
        this.connect(this.turnsAndSceneViewer);
        this.viewers.add(this.turnsAndSceneViewer);
        this.enabledViewers.add(this.turnsAndSceneViewer);
        return this.turnsAndSceneViewer;
    }

    public TurnsAndSceneViewer getTurnsAndSceneViewer() {
        return this.turnsAndSceneViewer;
    }

    public void destroyPanel(String panelName) {
        if (panelName == null) {
            return;
        }
        if (panelName.equals("Menu.View.Viewers.Recognizer") && this.recognizerPanel != null) {
            ElanLocale.removeElanLocaleListener(this.recognizerPanel);
            this.recognizerPanel = null;
        }
    }

    public void setControllersForViewer(AbstractViewer viewer, String[] tierNames) {
        try {
            Tier[] tiers = new Tier[tierNames.length];
            for (int i = 0; i < tierNames.length; ++i) {
                tiers[i] = this.transcription.getTierWithId(tierNames[i]);
            }
            this.setControllersForViewer(viewer, tiers);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setTierForViewer(SingleTierViewer viewer, Tier tier) {
        if (viewer instanceof AbstractViewer) {
            Tier[] tierArray;
            AbstractViewer abstractViewer = (AbstractViewer)((Object)viewer);
            if (tier == null) {
                tierArray = new Tier[]{};
            } else {
                Tier[] tierArray2 = new Tier[1];
                tierArray = tierArray2;
                tierArray2[0] = tier;
            }
            this.setControllersForViewer(abstractViewer, tierArray);
        }
        viewer.setTier(tier);
    }

    public void setControllersForViewer(AbstractViewer viewer, Tier[] tiers) {
        if (viewer == null) {
            return;
        }
        this.disconnectController(viewer, true);
        if (tiers != null && tiers.length > 0) {
            TimeLineController controller = this.getControllerForTier(tiers[0]);
            controller.addControllerListener(viewer);
            this.controllers.put(viewer, controller);
            if (this.masterMediaPlayer.isPlaying()) {
                controller.start();
            }
        }
    }

    public SingleTierViewerPanel createSingleTierViewerPanel() {
        SingleTierViewerPanel panel = new SingleTierViewerPanel(this);
        this.tierOrder.addTierOrderListener(panel);
        try {
            this.transcription.addACMEditListener(panel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ElanLocale.addElanLocaleListener(this.transcription, panel);
        return panel;
    }

    public void destroySingleTierViewerPanel(SingleTierViewerPanel panel) {
        if (panel == null) {
            return;
        }
        this.tierOrder.removeTierorderListener(panel);
        try {
            this.transcription.removeACMEditListener(panel);
            Preferences.removePreferencesListener(this.transcription, panel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ElanLocale.removeElanLocaleListener(panel);
    }

    public void destroyViewer(AbstractViewer viewer) {
        if (this.enabledViewers.contains(viewer)) {
            this.enabledViewers.remove(viewer);
        }
        if (this.disabledViewers.contains(viewer)) {
            this.disabledViewers.remove(viewer);
        }
        this.disconnect(viewer, true);
        this.viewers.remove(viewer);
    }

    public void destroyTranscriptionViewer() {
        if (this.transcriptionViewer != null) {
            this.destroyViewer(this.transcriptionViewer);
            this.transcriptionViewer = null;
        }
    }

    public void destroyGridViewer() {
        if (this.gridViewer != null) {
            this.destroyViewer(this.gridViewer);
            this.gridViewer = null;
        }
    }

    public void destroyTextViewer() {
        if (this.textViewer != null) {
            this.destroyViewer(this.textViewer);
            this.textViewer = null;
        }
    }

    public void destroySubtitleViewers() {
        if (this.subtitleViewers != null) {
            for (int i = 0; i < this.subtitleViewers.size(); ++i) {
                this.destroyViewer(this.subtitleViewers.get(i));
            }
            this.subtitleViewers.clear();
        }
    }

    public void destroyLexiconViewer() {
        if (this.lexiconViewer != null) {
            this.destroyViewer(this.lexiconViewer);
            this.lexiconViewer = null;
        }
    }

    public void destroyCommentViewer() {
        if (this.commentViewer != null) {
            this.destroyViewer(this.commentViewer);
            this.commentViewer = null;
        }
    }

    public void destroySignalViewer() {
        if (this.signalViewer != null) {
            this.destroyViewer(this.signalViewer);
            this.signalViewer = null;
            this.destroySignalViewerControlPanel();
        }
    }

    public void destroyInterlinearViewer() {
        if (this.interlinearViewer != null) {
            this.destroyViewer(this.interlinearViewer);
            this.interlinearViewer = null;
        }
    }

    public void destroyTimeLineViewer() {
        if (this.timeLineViewer != null) {
            this.destroyViewer(this.timeLineViewer);
            this.timeLineViewer = null;
        }
    }

    public void destroyAnnotationDensityViewer() {
        if (this.annotationDensityViewer != null) {
            this.destroyViewer(this.annotationDensityViewer);
            this.annotationDensityViewer = null;
        }
    }

    public void destroyMediaPlayerControlSlider() {
        if (this.mediaPlayerControlSlider != null) {
            this.destroyViewer(this.mediaPlayerControlSlider);
            this.mediaPlayerControlSlider = null;
        }
    }

    public void destroyTimePanel() {
        if (this.timePanel != null) {
            this.destroyViewer(this.timePanel);
            this.timePanel = null;
        }
    }

    public void disableViewer(AbstractViewer viewer) {
        if (this.enabledViewers.contains(viewer)) {
            this.enabledViewers.remove(viewer);
            this.disconnect(viewer, false);
            this.disabledViewers.add(viewer);
        }
    }

    public void enableViewer(AbstractViewer viewer) {
        if (this.disabledViewers.contains(viewer)) {
            this.disabledViewers.remove(viewer);
            this.connect(viewer);
            this.enabledViewers.add(viewer);
        }
    }

    public void setFrameStepsToBeginOfFrame(boolean stepsToBegin) {
        if (this.masterMediaPlayer != null) {
            this.masterMediaPlayer.setFrameStepsToFrameBegin(stepsToBegin);
        }
        for (ElanMediaPlayer player : this.connectedMediaPlayers) {
            player.setFrameStepsToFrameBegin(stepsToBegin);
        }
        for (ElanMediaPlayer player : this.disabledMediaPlayers) {
            player.setFrameStepsToFrameBegin(stepsToBegin);
        }
    }

    public void cleanUpOnClose() {
        if (this.masterMediaPlayer != null && this.masterMediaPlayer.isPlaying()) {
            this.masterMediaPlayer.stop();
        }
        for (ElanMediaPlayer player : this.connectedMediaPlayers) {
            player.cleanUpOnClose();
        }
        for (ElanMediaPlayer player : this.disabledMediaPlayers) {
            player.cleanUpOnClose();
        }
        if (this.masterMediaPlayer != null) {
            this.masterMediaPlayer.cleanUpOnClose();
        }
        for (int i = 0; i < this.viewers.size(); ++i) {
            AbstractViewer viewer = this.viewers.get(i);
            this.disconnect(viewer, true);
            if (viewer instanceof ACMEditListener && this.transcription != null) {
                this.transcription.removeACMEditListener((ACMEditListener)((Object)viewer));
            }
            if (viewer instanceof TimeLineViewer) {
                ((TimeLineViewer)viewer).setTranscription(null);
            }
            if (!(viewer instanceof InterlinearViewer)) continue;
            ((InterlinearViewer)viewer).setTranscription(null);
        }
        if (this.recognizerPanel != null) {
            // empty if block
        }
        this.enabledViewers.clear();
        this.viewers.clear();
        this.disabledViewers.clear();
    }

    private void connect(AbstractViewer viewer) {
        Controller controller;
        viewer.setPlayer(this.masterMediaPlayer);
        viewer.setSelectionObject(this.selection);
        this.selection.addSelectionListener(viewer);
        viewer.setActiveAnnotationObject(this.activeAnnotation);
        this.activeAnnotation.addActiveAnnotationListener(viewer);
        ElanLocale.addElanLocaleListener(this.transcription, viewer);
        viewer.setViewerManager(this);
        if (viewer instanceof ACMEditListener) {
            try {
                this.transcription.addACMEditListener((ACMEditListener)((Object)viewer));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (viewer instanceof TimeScaleUser) {
            ((TimeScaleUser)((Object)viewer)).setGlobalTimeScale(this.timeScale);
            this.timeScale.addTimeScaleListener((TimeScaleListener)((Object)viewer));
        }
        if (viewer instanceof MultiTierViewer && this.multiTierControlPanel != null) {
            this.multiTierControlPanel.addViewer((MultiTierViewer)((Object)viewer));
        }
        if (viewer instanceof PreferencesListener) {
            Preferences.addPreferencesListener(this.transcription, viewer);
        }
        if ((controller = this.controllers.get(viewer)) != null) {
            controller.addControllerListener(viewer);
            viewer.controllerUpdate(new TimeEvent(controller));
        }
    }

    private void disconnect(AbstractViewer viewer, boolean finalDisconnection) {
        viewer.setPlayer(null);
        viewer.setSelectionObject(null);
        this.selection.removeSelectionListener(viewer);
        viewer.setActiveAnnotationObject(null);
        this.activeAnnotation.removeActiveAnnotationListener(viewer);
        ElanLocale.removeElanLocaleListener(viewer);
        viewer.setViewerManager(null);
        if (viewer instanceof ACMEditListener) {
            try {
                this.transcription.removeACMEditListener((ACMEditListener)((Object)viewer));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (viewer instanceof TimeScaleUser) {
            this.timeScale.removeTimeScaleListener((TimeScaleUser)((Object)viewer));
        }
        if (viewer instanceof MultiTierViewer && this.multiTierControlPanel != null) {
            this.multiTierControlPanel.removeViewer((MultiTierViewer)((Object)viewer));
        }
        if (viewer instanceof PreferencesListener) {
            Preferences.removePreferencesListener(this.transcription, viewer);
        }
        this.disconnectController(viewer, finalDisconnection);
    }

    private void disconnectController(AbstractViewer viewer, boolean finalDisconnection) {
        Controller controller = this.controllers.get(viewer);
        if (controller != null) {
            controller.removeControllerListener(viewer);
            if (finalDisconnection) {
                this.controllers.remove(viewer);
                if (controller.getNrOfConnectedListeners() == 0) {
                    this.removeFromHashTable(controller, this.controllers);
                    this.masterMediaPlayer.removeController(controller);
                    controller = null;
                }
            }
        }
    }

    private TimeLineController getControllerForTier(Tier tier) {
        if (tier == null) {
            return null;
        }
        TimeLineController controller = null;
        if (this.controllers.containsKey(tier)) {
            controller = (TimeLineController)this.controllers.get(tier);
        } else {
            controller = new TimeLineController(tier, this.masterMediaPlayer);
            this.masterMediaPlayer.addController(controller);
            this.controllers.put(tier, controller);
        }
        return controller;
    }

    private PeriodicUpdateController getControllerForPeriod(long period) {
        PeriodicUpdateController controller = null;
        Long periodKey = period;
        if (this.controllers.containsKey(periodKey)) {
            controller = (PeriodicUpdateController)this.controllers.get(periodKey);
        } else {
            controller = new PeriodicUpdateController(period);
            this.masterMediaPlayer.addController(controller);
            this.controllers.put(periodKey, controller);
        }
        return controller;
    }

    private boolean removeFromHashTable(Object object, Map<Object, Controller> hashtable) {
        boolean objectRemoved = false;
        Iterator<Map.Entry<Object, Controller>> it = hashtable.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Controller> e = it.next();
            if (e.getValue() != object) continue;
            it.remove();
            objectRemoved = true;
        }
        return objectRemoved;
    }
}

