/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.ArrayList;
import java.util.List;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.util.ProgressListener;

public abstract class AbstractProgressCommand
implements Command {
    private List<ProgressListener> listeners;
    private String commandName;
    protected boolean cancelled = false;
    protected boolean errorOccurred = false;
    protected float curProgress = 0.0f;

    public AbstractProgressCommand(String theName) {
        this.commandName = theName;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    public synchronized void addProgressListener(ProgressListener pl) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ProgressListener>(2);
        }
        this.listeners.add(pl);
    }

    public synchronized void removeProgressListener(ProgressListener pl) {
        if (pl != null && this.listeners != null) {
            this.listeners.remove(pl);
        }
    }

    public void cancelProcess() {
        this.cancelled = true;
    }

    protected void progressUpdate(int percent, String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).progressUpdated(this, percent, message);
            }
        }
    }

    protected void progressComplete(String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).progressCompleted(this, message);
            }
        }
    }

    protected void progressInterrupt(String message) {
        this.errorOccurred = true;
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).progressInterrupted(this, message);
            }
        }
    }
}

