/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.comments.CommentEnvelope;
import mpi.eudico.client.annotator.comments.CommentManager;

public class ChangeCommentCommand
implements UndoableCommand {
    private String commandName;
    private CommentManager commentManager;
    private CommentEnvelope oldComment;
    private CommentEnvelope newComment;
    private int insertPosition;

    public ChangeCommentCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        if (receiver instanceof CommentManager && arguments != null && arguments.length >= 2 && arguments[0] instanceof Integer && arguments[1] instanceof CommentEnvelope) {
            this.commentManager = (CommentManager)receiver;
            int changeIndex = (Integer)arguments[0];
            this.newComment = (CommentEnvelope)arguments[1];
            this.oldComment = this.commentManager.get(changeIndex);
            this.insertPosition = this.commentManager.replace(changeIndex, this.newComment);
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    @Override
    public void undo() {
        int index;
        if (this.oldComment != null && this.newComment != null && (index = this.commentManager.findCommentById(this.newComment.getMessageID())) >= 0) {
            this.commentManager.replace(index, this.oldComment);
        }
    }

    @Override
    public void redo() {
        int index;
        if (this.newComment != null && this.newComment != null && (index = this.commentManager.findCommentById(this.oldComment.getMessageID())) >= 0) {
            this.commentManager.replace(index, this.newComment);
        }
    }

    public int getInsertPosition() {
        return this.insertPosition;
    }
}

