/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.event.ActionEvent;
import java.io.File;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.SelectionListener;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.CommandAction;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.ClipWithScriptUtil;

public class ClipMediaCA
extends CommandAction
implements SelectionListener {
    private File scriptFile;
    private String executable;
    private String paramLine;
    private final String scriptFileName = "clip-media.txt";
    private long lastModified = 0L;
    private String outFilePath = null;
    private ClipWithScriptUtil scriptUtil = new ClipWithScriptUtil();

    public ClipMediaCA(ViewerManager2 viewerManager) {
        super(viewerManager, "Menu.File.Export.MediaWithScript");
        try {
            this.scriptFile = this.scriptUtil.getScriptFile("clip-media.txt");
            if (this.scriptFile != null) {
                ClientLogger.LOG.info("Found clipping script: " + this.scriptFile.getName());
            } else {
                ClientLogger.LOG.info("No clipping script found!");
            }
        }
        catch (Exception e) {
            ClientLogger.LOG.info("No clipping script found");
        }
        viewerManager.connectListener(this);
    }

    @Override
    protected void newCommand() {
        this.command = ELANCommandFactory.createCommand(this.vm.getTranscription(), "Menu.File.Export.MediaWithScript");
    }

    public void setPath(String outFilePath) {
        this.outFilePath = outFilePath;
    }

    @Override
    protected Object getReceiver() {
        return null;
    }

    @Override
    protected Object[] getArguments() {
        if (this.scriptFile == null) {
            return new Object[]{this.vm, new Exception(ElanLocale.getString("ExportClipDialog.Message.NoScript") + "\n" + ElanLocale.getString("ExportClipDialog.Message.LookingFor") + "\n" + System.getProperty("user.dir") + File.separator + "clip-media.txt\n" + Constants.ELAN_DATA_DIR + File.separator + "clip-media.txt")};
        }
        if (this.executable == null) {
            return new Object[]{this.vm, new Exception(ElanLocale.getString("ExportClipDialog.Message.InvalidScript"))};
        }
        if (this.outFilePath != null) {
            return new Object[]{this.vm, this.executable, this.paramLine, this.outFilePath};
        }
        return new Object[]{this.vm, this.executable, this.paramLine};
    }

    @Override
    public void updateSelection() {
        if (this.vm.getSelection().getEndTime() > this.vm.getSelection().getBeginTime()) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.scriptFile == null) {
            this.scriptFile = this.scriptUtil.getScriptFile("clip-media.txt");
            if (this.scriptFile != null) {
                this.lastModified = this.scriptFile.lastModified();
                String[] scriptParts = this.scriptUtil.parseScriptLine(this.scriptFile);
                if (scriptParts != null && scriptParts.length >= 2) {
                    this.executable = scriptParts[0];
                    this.paramLine = scriptParts[1];
                }
            }
        } else {
            long lm = this.scriptFile.lastModified();
            if (lm > this.lastModified) {
                String[] scriptParts = this.scriptUtil.parseScriptLine(this.scriptFile);
                if (scriptParts != null && scriptParts.length >= 2) {
                    this.executable = scriptParts[0];
                    this.paramLine = scriptParts[1];
                }
                this.lastModified = lm;
            }
        }
        super.actionPerformed(event);
    }
}

