/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.ClipMediaCommand;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.AnnotationCore;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.util.ProcessReport;
import nl.mpi.util.FileUtility;

public class ClipMediaMultiCommand
extends ClipMediaCommand {
    public ClipMediaMultiCommand(String theName) {
        super(theName);
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        List arg2;
        TranscriptionImpl transcription = (TranscriptionImpl)receiver;
        if (arguments.length >= 5) {
            this.report = (ProcessReport)arguments[4];
        }
        if (transcription.getMediaDescriptors().size() == 0) {
            ClientLogger.LOG.warning("No media descriptors in the transcription, nothing to clip");
            if (this.report != null) {
                this.report.append("No media descriptors in the transcription, nothing to clip");
            }
            return;
        }
        String executable = (String)arguments[0];
        if (executable == null) {
            return;
        }
        String command = (String)arguments[1];
        if (command == null) {
            return;
        }
        this.readPrefs();
        List<AnnotationCore> segmentList = null;
        if (arguments[2] instanceof List && (arg2 = (List)arguments[2]).size() > 0) {
            Object first = arg2.get(0);
            if (first instanceof AnnotationCore) {
                segmentList = arg2;
            } else if (first instanceof String) {
                segmentList = this.extractSegments(transcription, arg2);
            }
        }
        if (segmentList == null || segmentList.size() == 0) {
            return;
        }
        String outputFolder = (String)arguments[3];
        this.unattendedMode = true;
        HashMap<String, Long> medMap = new HashMap<String, Long>(transcription.getMediaDescriptors().size());
        for (int i = 0; !(i >= transcription.getMediaDescriptors().size() || i > 0 && this.masterMediaOnly); ++i) {
            MediaDescriptor md = transcription.getMediaDescriptors().get(i);
            String string = this.processSourceFileName(md.mediaURL);
            medMap.put(string, md.timeOrigin);
        }
        ArrayList<ClipMediaCommand.MediaClipper> clippingList = new ArrayList<ClipMediaCommand.MediaClipper>();
        for (Map.Entry entry : medMap.entrySet()) {
            String mediaSource = (String)entry.getKey();
            long offset = (Long)entry.getValue();
            if (this.report != null) {
                this.report.append("Clipping " + segmentList.size() + " segments from " + mediaSource);
            }
            String rawOutputName = outputFolder + File.separator + FileUtility.fileNameFromPath(mediaSource);
            String ext = FileUtility.getExtension(mediaSource);
            String completeOutputName = null;
            for (int i = 0; i < segmentList.size(); ++i) {
                AnnotationCore segment = segmentList.get(i);
                completeOutputName = this.useAnnotationValueForFileName ? this.createDestinationNameFromAnnotation(outputFolder, ext, segment) : this.createDestinationName(rawOutputName, segment.getBeginTimeBoundary() + offset, segment.getEndTimeBoundary() + offset);
                List<String> defCommand = this.processCommand(command, mediaSource, completeOutputName, segment.getBeginTimeBoundary() + offset, segment.getEndTimeBoundary() + offset);
                defCommand.add(0, executable);
                clippingList.add(new ClipMediaCommand.MediaClipper(defCommand));
            }
        }
        ClipMediaCommand.ClipRunner cRun = new ClipMediaCommand.ClipRunner(clippingList);
        cRun.start();
        try {
            cRun.join();
            if (cRun.getErrorMessage() != null) {
                if (this.unattendedMode) {
                    ClientLogger.LOG.warning(cRun.getErrorMessage() + "(" + cRun.numErrors + ")");
                }
                if (this.report != null) {
                    this.report.append("Errors occurred: " + cRun.getErrorMessage() + "(" + cRun.numErrors + ")");
                }
            }
        }
        catch (InterruptedException interruptedException) {
            ClientLogger.LOG.warning(ElanLocale.getString("Message.Error") + ": " + interruptedException.getMessage());
        }
    }

    private List<AnnotationCore> extractSegments(TranscriptionImpl transcription, List<String> tierNames) {
        if (transcription != null && tierNames != null && tierNames.size() > 0) {
            ArrayList<AnnotationCore> segments = new ArrayList<AnnotationCore>();
            for (String name : tierNames) {
                TierImpl t = transcription.getTierWithId(name);
                if (t == null) continue;
                List<AbstractAnnotation> annotations = t.getAnnotations();
                int size = annotations.size();
                for (int i = 0; i < size; ++i) {
                    Annotation a = annotations.get(i);
                    segments.add(a);
                }
            }
            return segments;
        }
        return null;
    }
}

