/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.util.SystemReporting;

public abstract class CommandAction
extends AbstractAction
implements ElanLocaleListener {
    public static final String MNEMONIC = "MNEMONIC.";
    protected Command command;
    private String commandId;
    protected ViewerManager2 vm;
    private static boolean useMnemonics = true;

    public CommandAction(ViewerManager2 theVM, String name) {
        super(name);
        this.vm = theVM;
        this.commandId = name;
        ElanLocale.addElanLocaleListener(this.vm.getTranscription(), this);
        this.updateLocale();
    }

    public CommandAction(ViewerManager2 theVM, String name, Icon icon) {
        super(name, icon);
        this.vm = theVM;
        this.commandId = name;
        ElanLocale.addElanLocaleListener(this.vm.getTranscription(), this);
        this.updateLocale();
    }

    protected abstract void newCommand();

    protected Object getReceiver() {
        return null;
    }

    protected Object[] getArguments() {
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.newCommand();
        if (this.command != null) {
            this.command.execute(this.getReceiver(), this.getArguments());
        }
    }

    public void setActionKeyStroke(KeyStroke ks) {
        this.putValue("AcceleratorKey", ks);
    }

    @Override
    public void updateLocale() {
        String mnemonic;
        Object newString = null;
        if (this.commandId != null) {
            newString = ElanLocale.getString(this.commandId);
        }
        Object[] obj = this.getKeys();
        for (int i = 0; i < obj.length; ++i) {
            if (!obj[i].equals("SmallIcon")) continue;
            newString = "";
        }
        Object object = this.getValue("ShortDescription");
        if (object == null || !object.equals("")) {
            this.putValue("ShortDescription", ElanLocale.getString(this.commandId + "ToolTip"));
        }
        this.putValue("Name", newString);
        if (useMnemonics && (mnemonic = ElanLocale.getString(MNEMONIC + this.commandId)).length() > 0) {
            try {
                this.putValue("MnemonicKey", mnemonic.charAt(0));
            }
            catch (NumberFormatException nfe) {
                try {
                    this.putValue("MnemonicKey", Integer.parseInt(mnemonic));
                }
                catch (NumberFormatException nfe2) {
                    this.putValue("MnemonicKey", null);
                }
            }
        }
    }

    static {
        if (SystemReporting.isMacOS()) {
            useMnemonics = false;
        }
    }
}

