/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.ArrayList;
import java.util.List;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.RedoCA;
import mpi.eudico.client.annotator.commands.UndoCA;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class CommandHistory {
    public static final int historySize = 25;
    private List<UndoableCommand> history;
    private int nextCommand;
    private UndoCA undoCA;
    private RedoCA redoCA;
    private TranscriptionImpl trans;

    public CommandHistory(int size, Transcription trans) {
        this.history = new ArrayList<UndoableCommand>(size);
        this.nextCommand = 0;
        this.trans = (TranscriptionImpl)trans;
    }

    public void addCommand(UndoableCommand theCommand) {
        if (this.nextCommand >= 25) {
            for (int surplus = this.nextCommand - 25 + 1; surplus > 0; --surplus) {
                this.history.remove(0);
                --this.nextCommand;
            }
            this.trans.forgetOldUndoTransactions(24);
        }
        if (this.nextCommand == this.history.size()) {
            this.history.add(theCommand);
        } else {
            this.history.set(this.nextCommand, theCommand);
        }
        ++this.nextCommand;
        for (int i = this.nextCommand; i < this.history.size(); ++i) {
            this.history.set(i, null);
        }
        this.adjustCurrentCommand();
        this.trans.pushNewUndoTransaction();
    }

    private void adjustCurrentCommand() {
        if (this.nextCommand > 0) {
            Object undoString = ElanLocale.getString("Menu.Edit.Undo");
            undoString = (String)undoString + " ";
            undoString = (String)undoString + ElanLocale.getString(this.history.get(this.nextCommand - 1).getName());
            this.undoCA.putValue("Name", undoString);
            this.undoCA.setEnabled(true);
        } else {
            this.undoCA.putValue("Name", ElanLocale.getString("Menu.Edit.Undo"));
            this.undoCA.setEnabled(false);
        }
        if (this.nextCommand < this.history.size() && this.history.get(this.nextCommand) != null) {
            Object redoString = ElanLocale.getString("Menu.Edit.Redo");
            redoString = (String)redoString + " ";
            redoString = (String)redoString + ElanLocale.getString(this.history.get(this.nextCommand).getName());
            this.redoCA.putValue("Name", redoString);
            this.redoCA.setEnabled(true);
        } else {
            this.redoCA.putValue("Name", ElanLocale.getString("Menu.Edit.Redo"));
            this.redoCA.setEnabled(false);
        }
    }

    public void undo() {
        if (this.nextCommand > 0) {
            --this.nextCommand;
            this.trans.pushNewUndoTransaction();
            this.history.get(this.nextCommand).undo();
            this.trans.popAndForgetTransaction();
            this.trans.popAndUndoTransaction();
            this.adjustCurrentCommand();
        }
    }

    public void redo() {
        if (this.nextCommand < this.history.size() && this.history.get(this.nextCommand) != null) {
            this.trans.pushNewUndoTransaction();
            this.history.get(this.nextCommand).redo();
            ++this.nextCommand;
            this.adjustCurrentCommand();
        }
    }

    public void setUndoCA(UndoCA theUndoCA) {
        this.undoCA = theUndoCA;
    }

    public void setRedoCA(RedoCA theRedoCA) {
        this.redoCA = theRedoCA;
    }

    public String toString() {
        Object s = "\n";
        for (int i = 0; i < this.history.size(); ++i) {
            if (this.history.get(i) == null) continue;
            s = i == this.nextCommand ? (String)s + "-> " : (String)s + "   ";
            s = (String)s + this.history.get(i).getName() + "\n";
        }
        return s;
    }
}

