/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.UnsupportedCharsetException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import mpi.eudico.client.annotator.commands.AbstractCompareCommand;
import mpi.eudico.client.annotator.interannotator.CompareConstants;
import mpi.eudico.client.annotator.interannotator.CompareUnit;
import mpi.eudico.client.annotator.interannotator.multi.AnnotatorCompareUtilMulti;
import mpi.eudico.client.annotator.interannotator.multi.CompareCombiMulti;
import mpi.eudico.client.annotator.interannotator.multi.MatchCluster;
import mpi.eudico.client.annotator.interannotator.multi.MultiMatrix;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.AnnotationCore;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.ACMTranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class CompareAnnotationMultiRaterCommand
extends AbstractCompareCommand {
    private double minimalOverlapPercentage = 0.6;
    private boolean outputTables = true;
    private final String NL = "\n";
    private final String NL2 = "\n\n";
    private final DecimalFormat decFormat = new DecimalFormat("#0.0000", new DecimalFormatSymbols(Locale.US));
    private List<List<MatchCluster>> clusterLists;
    private List<MultiMatrix> matrixList;

    public CompareAnnotationMultiRaterCommand(String theName) {
        super(theName);
    }

    @Override
    protected void calculateAgreement() {
        int i;
        if (this.compareSegments.size() == 0) {
            this.logErrorAndInterrupt("There are no tier groups, nothing to calculate.");
            return;
        }
        Object prefObject = this.compareProperties.get("Compare.OverlapAveragePercentage");
        if (prefObject instanceof Double) {
            this.minimalOverlapPercentage = (Double)prefObject;
        } else if (prefObject instanceof Integer) {
            this.minimalOverlapPercentage = (double)((Integer)prefObject).intValue() / 100.0;
        }
        Object prefTablesObject = this.compareProperties.get("Compare.Output.TablesOfValues");
        if (prefTablesObject instanceof Boolean) {
            this.outputTables = (Boolean)prefTablesObject;
        }
        boolean exportMatchingTiers = false;
        String exportTierFolder = null;
        Object prefTierExport = this.compareProperties.get("Compare.ExportMatchingTiers");
        if (prefTierExport instanceof Boolean && (exportMatchingTiers = ((Boolean)prefTierExport).booleanValue())) {
            Object prefFolder = this.compareProperties.get("Compare.ExportFolder");
            if (prefFolder instanceof String) {
                exportTierFolder = (String)prefFolder;
                if (!this.ensureBaseFolder(exportTierFolder = exportTierFolder.replace('\\', '/'))) {
                    exportMatchingTiers = false;
                    ClientLogger.LOG.warning("Cannot export matching tiers, the output folder does not exist and cannot be created");
                }
            } else {
                exportMatchingTiers = false;
                ClientLogger.LOG.warning("Cannot export matching tiers, no output folder specified");
            }
        }
        float perCombi = 25.0f / (float)this.compareSegments.size();
        this.clusterLists = new ArrayList<List<MatchCluster>>(this.compareSegments.size());
        AnnotatorCompareUtilMulti compareUtil = new AnnotatorCompareUtilMulti();
        compareUtil.setAvgRatioThreshold(this.minimalOverlapPercentage);
        this.progressUpdate((int)this.curProgress, "Matching annotations from multiple raters...");
        for (i = 0; i < this.compareSegments.size(); ++i) {
            this.clusterLists.add(compareUtil.matchAnnotationsMulti((CompareCombiMulti)this.compareSegments.get(i)));
            if (exportMatchingTiers) {
                this.writeCCtoEAF((CompareCombiMulti)this.compareSegments.get(i), i, exportTierFolder);
            }
            this.curProgress += perCombi;
            this.progressUpdate((int)this.curProgress, null);
        }
        this.progressUpdate((int)this.curProgress, "Creating matrices for multiple raters...");
        this.matrixList = new ArrayList<MultiMatrix>(this.compareSegments.size());
        for (i = 0; i < this.compareSegments.size(); ++i) {
            this.matrixList.add(new MultiMatrix((CompareCombiMulti)this.compareSegments.get(i), this.clusterLists.get(i)));
            this.curProgress += perCombi;
            this.progressUpdate((int)this.curProgress, null);
        }
        this.progressComplete(String.format("Completed calculations of %d groups of tiers.", this.matrixList.size()));
    }

    @Override
    public void writeResultsAsText(File toFile, String encoding) throws IOException {
        if (toFile == null) {
            throw new IOException("There is no file location specified.");
        }
        BufferedWriter writer = null;
        try {
            FileOutputStream out = new FileOutputStream(toFile);
            OutputStreamWriter osw = null;
            try {
                osw = new OutputStreamWriter((OutputStream)out, encoding);
            }
            catch (UnsupportedCharsetException uce) {
                osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
            }
            writer = new BufferedWriter(osw);
            writer.write(String.format("Output created: %tD %<tT", Calendar.getInstance()));
            writer.write("\n\n");
            writer.write("Calculating Fleiss' kappa per group of matching tiers.");
            writer.write("\n");
            writer.write("k = (P - Pe) / (1 - Pe), see https://en.wikipedia.org/wiki/Fleiss'_kappa");
            writer.write("\n");
            writer.write("Number of files involved: ");
            if (this.transcription != null && this.compareProperties.get("Compare.TierSource") == CompareConstants.FILE_MATCHING.CURRENT_DOC) {
                writer.write("1 (current transcription)");
            } else {
                writer.write(String.valueOf(this.numFiles));
            }
            writer.write("\n");
            writer.write("Number of selected tiers: " + this.numSelTiers);
            writer.write("\n");
            writer.write("Preferred average overlap percentage: " + String.valueOf(Math.round(this.minimalOverlapPercentage * 100.0)) + "%");
            writer.write("\n\n");
            for (int i = 0; i < this.matrixList.size() && i < this.clusterLists.size(); ++i) {
                writer.write(String.format("Comparison cluster: ", i));
                writer.write("\n");
                CompareCombiMulti ccm = (CompareCombiMulti)this.compareSegments.get(i);
                int numEmptyTiers = 0;
                for (CompareUnit cu : ccm.getCompareUnits()) {
                    if (cu.annotations.size() != 0) continue;
                    ++numEmptyTiers;
                }
                writer.write(String.format("Number of tiers in this cluster: %d (%d without annotations)", ccm.getCompareUnits().size(), numEmptyTiers));
                writer.write("\n");
                for (int j = 0; j < ccm.getCompareUnits().size(); ++j) {
                    CompareUnit cu;
                    cu = ccm.getCompareUnit(j);
                    writer.write(String.format("File: %s, Tier %d: %s, #Annotations: %d", cu.fileName, j, cu.tierName, cu.annotations.size()));
                    writer.write("\n");
                }
                List<MatchCluster> mcList = this.clusterLists.get(i);
                MultiMatrix mm = this.matrixList.get(i);
                if (mcList == null) {
                    writer.write("There are no clusters of matching annotations for this combination.");
                    writer.write("\n\n");
                    continue;
                }
                if (mm == null) {
                    writer.write("There's no matrix as the basis for the calculation of the kappa value.");
                    writer.write("\n\n");
                    continue;
                }
                writer.write(String.format("Kappa including \"Unmatched\" value: k = (%s - %s) / (1.0 - %s) = %s", this.decFormat.format(mm.getAvgPIU()), this.decFormat.format(mm.getPeIU()), this.decFormat.format(mm.getPeIU()), this.decFormat.format(mm.getKappaIU())));
                if (mm.getPeIU() == 1.0) {
                    writer.write(" (k = 1.0)");
                }
                writer.write("\n");
                writer.write(String.format("Kappa excluding \"Unmatched\" value:  k = (%s - %s) / (1.0 - %s) = %s", this.decFormat.format(mm.getAvgPEU()), this.decFormat.format(mm.getPeEU()), this.decFormat.format(mm.getPeEU()), this.decFormat.format(mm.getKappaEU())));
                if (mm.getPeEU() == 1.0) {
                    writer.write(" (k = 1.0)");
                }
                writer.write("\n");
                if (!this.outputTables) continue;
                mm.printMatrix(writer, this.decFormat, true);
                writer.write("\n");
                mm.printMatrix(writer, this.decFormat, false);
                writer.write("\n");
            }
            writer.flush();
        }
        catch (Throwable tr) {
            throw new IOException("Cannot write to file: " + tr.getMessage());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Throwable out) {}
            }
        }
    }

    private void writeCCtoEAF(CompareCombiMulti ccm, int index, String folderPath) {
        try {
            TranscriptionImpl tr = new TranscriptionImpl();
            LinguisticType lt = new LinguisticType("compare");
            tr.addLinguisticType(lt);
            String trName = null;
            String tierName = null;
            for (int i = 0; i < ccm.getCompareUnits().size(); ++i) {
                CompareUnit cu = ccm.getCompareUnit(i);
                if (i == 0) {
                    trName = cu.fileName;
                    tierName = cu.tierName;
                }
                TierImpl nt = null;
                nt = tr.getTierWithId(cu.tierName) == null ? new TierImpl(cu.tierName, cu.annotator, tr, lt) : new TierImpl(cu.tierName + "-" + i, cu.annotator, tr, lt);
                tr.addTier(nt);
                for (AnnotationCore ac : cu.annotations) {
                    AbstractAnnotation aa = (AbstractAnnotation)nt.createAnnotation(ac.getBeginTimeBoundary(), ac.getEndTimeBoundary());
                    if (aa == null) continue;
                    aa.setValue(ac.getValue());
                    nt.addAnnotation(aa);
                }
            }
            if (trName != null && trName.indexOf("/") > 0) {
                trName = trName.substring(trName.lastIndexOf("/") + 1);
            }
            String path = folderPath + "/ccm-" + index + ".eaf";
            if (trName != null) {
                String dir = folderPath + "/" + tierName;
                File dirFile = new File(dir);
                if (!dirFile.exists()) {
                    dirFile.mkdir();
                }
                path = dir + "/" + trName;
            }
            tr.setPathName(path);
            ACMTranscriptionStore.getCurrentTranscriptionStore().storeTranscriptionIn(tr, null, null, path, 0);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private boolean ensureBaseFolder(String exportFolderString) {
        try {
            File f = new File(exportFolderString);
            if (f.exists()) {
                return f.canWrite();
            }
            return f.mkdirs();
        }
        catch (Throwable t) {
            return false;
        }
    }
}

