/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.comments.CommentEnvelope;
import mpi.eudico.client.annotator.comments.CommentManager;

public class DeleteCommentCommand
implements UndoableCommand {
    private String commandName;
    private CommentManager commentManager;
    private CommentEnvelope oldComment;

    public DeleteCommentCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        if (receiver instanceof CommentManager && arguments != null && arguments.length >= 1 && arguments[0] instanceof Integer) {
            this.commentManager = (CommentManager)receiver;
            int removeIndex = (Integer)arguments[0];
            this.oldComment = this.commentManager.get(removeIndex);
            this.commentManager.remove(removeIndex);
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    @Override
    public void undo() {
        if (this.oldComment != null) {
            int n = this.commentManager.insert(this.oldComment);
        }
    }

    @Override
    public void redo() {
        int index;
        if (this.oldComment != null && (index = this.commentManager.findCommentById(this.oldComment.getMessageID())) >= 0) {
            this.commentManager.remove(index);
        }
    }
}

