/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class DeleteTierCommand
implements UndoableCommand {
    private String commandName;
    private TierImpl tier;
    private List<TierImpl> depTiers;
    private List<DefaultMutableTreeNode> annotationsNodes;
    private Map<String, Color> colorPrefs;
    private Map<String, Font> fontPrefs;
    private TranscriptionImpl transcription;

    public DeleteTierCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void undo() {
        if (this.transcription != null && this.tier != null) {
            Map<String, Font> fonts;
            Map<String, Color> colors;
            int curPropMode = 0;
            curPropMode = this.transcription.getTimeChangePropagationMode();
            if (curPropMode != 0) {
                this.transcription.setTimeChangePropagationMode(0);
            }
            this.setWaitCursor(true);
            if (this.transcription.getTierWithId(this.tier.getName()) == null) {
                this.transcription.addTier(this.tier);
            }
            if (this.depTiers != null) {
                for (int i = 0; i < this.depTiers.size(); ++i) {
                    TierImpl deptier = this.depTiers.get(i);
                    if (this.transcription.getTierWithId(deptier.getName()) != null) continue;
                    this.transcription.addTier(deptier);
                }
            }
            if (this.annotationsNodes.size() > 0) {
                this.transcription.setNotifying(false);
                if (this.tier.hasParentTier()) {
                    AnnotationRecreator.createAnnotationsSequentially(this.transcription, this.annotationsNodes, true);
                } else {
                    for (int i = 0; i < this.annotationsNodes.size(); ++i) {
                        DefaultMutableTreeNode node = this.annotationsNodes.get(i);
                        AnnotationRecreator.createAnnotationFromTree(this.transcription, node, true);
                    }
                }
                this.transcription.setNotifying(true);
            }
            this.setWaitCursor(false);
            this.transcription.setTimeChangePropagationMode(curPropMode);
            if (this.colorPrefs != null && (colors = Preferences.getMapOfColor("TierColors", this.transcription)) != null) {
                colors.putAll(this.colorPrefs);
                Preferences.set("TierColors", colors, this.transcription, true);
            }
            if (this.fontPrefs != null && (fonts = Preferences.getMapOfFont("TierFonts", this.transcription)) != null) {
                fonts.putAll(this.fontPrefs);
                Preferences.set("TierFonts", fonts, this.transcription, true);
            }
        }
    }

    @Override
    public void redo() {
        Map<String, Font> fonts;
        Map<String, Color> colors;
        if (this.transcription == null || this.tier == null) {
            return;
        }
        this.transcription.removeTier(this.tier);
        if (this.depTiers != null) {
            for (int i = 0; i < this.depTiers.size(); ++i) {
                this.transcription.removeTier(this.depTiers.get(i));
            }
        }
        if ((colors = Preferences.getMapOfColor("TierColors", this.transcription)) != null) {
            for (TierImpl t : this.depTiers) {
                colors.remove(t.getName());
            }
            colors.remove(this.tier.getName());
        }
        if ((fonts = Preferences.getMapOfFont("TierFonts", this.transcription)) != null) {
            for (TierImpl t : this.depTiers) {
                fonts.remove(t.getName());
            }
            fonts.remove(this.tier.getName());
        }
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        Map<String, Font> map;
        if (!(receiver instanceof TranscriptionImpl)) {
            return;
        }
        this.transcription = (TranscriptionImpl)receiver;
        this.tier = (TierImpl)arguments[0];
        if (this.tier == null) {
            return;
        }
        this.depTiers = this.tier.getDependentTiers();
        this.annotationsNodes = new ArrayList<DefaultMutableTreeNode>();
        for (AbstractAnnotation abstractAnnotation : this.tier.getAnnotations()) {
            this.annotationsNodes.add(AnnotationRecreator.createTreeForAnnotation(abstractAnnotation));
        }
        if (this.depTiers != null) {
            for (int i = 0; i < this.depTiers.size(); ++i) {
                this.transcription.removeTier(this.depTiers.get(i));
            }
        }
        this.transcription.removeTier(this.tier);
        Map<String, Color> colors = Preferences.getMapOfColor("TierColors", this.transcription);
        if (colors != null) {
            this.colorPrefs = new HashMap<String, Color>(colors.size());
            for (TierImpl tierImpl : this.depTiers) {
                Color col = colors.remove(tierImpl.getName());
                if (col == null) continue;
                this.colorPrefs.put(tierImpl.getName(), col);
            }
            Color color = colors.remove(this.tier.getName());
            if (color != null) {
                this.colorPrefs.put(this.tier.getName(), color);
            }
        }
        if ((map = Preferences.getMapOfFont("TierFonts", this.transcription)) != null) {
            this.fontPrefs = new HashMap<String, Font>(map.size());
            for (TierImpl t : this.depTiers) {
                Font fon = map.remove(t.getName());
                if (fon == null) continue;
                this.fontPrefs.put(t.getName(), fon);
            }
            Font font = map.remove(this.tier.getName());
            if (font != null) {
                this.fontPrefs.put(this.tier.getName(), font);
            }
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    private void setWaitCursor(boolean showWaitCursor) {
        if (showWaitCursor) {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getDefaultCursor());
        }
    }
}

