/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class DeleteTiersCommand
implements UndoableCommand {
    private String commandName;
    private TierImpl[] tiers;
    private List<TierImpl>[] depTiers;
    private ArrayList<DefaultMutableTreeNode>[] annotationsNodes;
    private Map<String, Color>[] colorPrefs;
    private Map<String, Font>[] fontPrefs;
    private TranscriptionImpl transcription;

    public DeleteTiersCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void undo() {
        if (this.transcription != null && this.tiers != null) {
            int curPropMode = 0;
            curPropMode = this.transcription.getTimeChangePropagationMode();
            if (curPropMode != 0) {
                this.transcription.setTimeChangePropagationMode(0);
            }
            this.setWaitCursor(true);
            for (int i = 0; i < this.tiers.length; ++i) {
                Map<String, Font> fonts;
                Map<String, Color> colors;
                if (this.transcription.getTierWithId(this.tiers[i].getName()) == null) {
                    this.transcription.addTier(this.tiers[i]);
                }
                if (this.depTiers[i] != null) {
                    for (int j = 0; j < this.depTiers[i].size(); ++j) {
                        TierImpl deptier = this.depTiers[i].get(j);
                        if (this.transcription.getTierWithId(deptier.getName()) != null) continue;
                        this.transcription.addTier(deptier);
                    }
                }
                if (this.annotationsNodes[i].size() > 0) {
                    this.transcription.setNotifying(false);
                    if (this.tiers[i].hasParentTier()) {
                        AnnotationRecreator.createAnnotationsSequentially(this.transcription, this.annotationsNodes[i], true);
                    } else {
                        for (int j = 0; j < this.annotationsNodes[i].size(); ++j) {
                            DefaultMutableTreeNode node = this.annotationsNodes[i].get(j);
                            AnnotationRecreator.createAnnotationFromTree(this.transcription, node, true);
                        }
                    }
                    this.transcription.setNotifying(true);
                }
                if (this.colorPrefs != null && (colors = Preferences.getMapOfColor("TierColors", this.transcription)) != null) {
                    colors.putAll(this.colorPrefs[i]);
                    Preferences.set("TierColors", colors, this.transcription, true);
                }
                if (this.fontPrefs == null || (fonts = Preferences.getMapOfFont("TierFonts", this.transcription)) == null) continue;
                fonts.putAll(this.fontPrefs[i]);
                Preferences.set("TierFonts", fonts, this.transcription, true);
            }
            this.setWaitCursor(false);
            this.transcription.setTimeChangePropagationMode(curPropMode);
        }
    }

    @Override
    public void redo() {
        for (int i = 0; i < this.tiers.length; ++i) {
            Map<String, Font> fonts;
            Map<String, Color> colors;
            if (this.transcription == null || this.tiers[i] == null) continue;
            this.transcription.removeTier(this.tiers[i]);
            if (this.depTiers[i] != null) {
                for (int j = 0; j < this.depTiers[i].size(); ++j) {
                    this.transcription.removeTier(this.depTiers[i].get(j));
                }
            }
            if ((colors = Preferences.getMapOfColor("TierColors", this.transcription)) != null) {
                for (TierImpl t : this.depTiers[i]) {
                    colors.remove(t.getName());
                }
                colors.remove(this.tiers[i].getName());
            }
            if ((fonts = Preferences.getMapOfFont("TierFonts", this.transcription)) == null) continue;
            for (TierImpl t : this.depTiers[i]) {
                fonts.remove(t.getName());
            }
            fonts.remove(this.tiers[i].getName());
        }
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        if (!(receiver instanceof TranscriptionImpl)) {
            return;
        }
        this.transcription = (TranscriptionImpl)receiver;
        int numTiers = arguments.length;
        this.tiers = new TierImpl[numTiers];
        this.depTiers = new List[numTiers];
        this.annotationsNodes = new ArrayList[numTiers];
        this.colorPrefs = new Map[numTiers];
        this.fontPrefs = new Map[numTiers];
        for (int i = 0; i < numTiers; ++i) {
            Map<String, Font> fonts;
            this.tiers[i] = (TierImpl)arguments[i];
            if (this.tiers[i] == null) continue;
            this.depTiers[i] = this.tiers[i].getDependentTiers();
            this.annotationsNodes[i] = new ArrayList();
            List<AbstractAnnotation> annos = this.tiers[i].getAnnotations();
            for (AbstractAnnotation ann : annos) {
                this.annotationsNodes[i].add(AnnotationRecreator.createTreeForAnnotation(ann));
            }
            if (this.depTiers[i] != null) {
                for (int j = 0; j < this.depTiers[i].size(); ++j) {
                    this.transcription.removeTier(this.depTiers[i].get(j));
                }
            }
            this.transcription.removeTier(this.tiers[i]);
            Map<String, Color> colors = Preferences.getMapOfColor("TierColors", this.transcription);
            if (colors != null) {
                this.colorPrefs[i] = new HashMap<String, Color>(colors.size());
                for (TierImpl tierImpl : this.depTiers[i]) {
                    Color col = colors.remove(tierImpl.getName());
                    if (col == null) continue;
                    this.colorPrefs[i].put(tierImpl.getName(), col);
                }
                Color col = colors.remove(this.tiers[i].getName());
                if (col != null) {
                    this.colorPrefs[i].put(this.tiers[i].getName(), col);
                }
            }
            if ((fonts = Preferences.getMapOfFont("TierFonts", this.transcription)) == null) continue;
            this.fontPrefs[i] = new HashMap<String, Font>(fonts.size());
            for (TierImpl t3 : this.depTiers[i]) {
                Font fon = fonts.remove(t3.getName());
                if (fon == null) continue;
                this.fontPrefs[i].put(t3.getName(), fon);
            }
            Font font = fonts.remove(this.tiers[i].getName());
            if (font == null) continue;
            this.fontPrefs[i].put(this.tiers[i].getName(), font);
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    private void setWaitCursor(boolean showWaitCursor) {
        if (showWaitCursor) {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getDefaultCursor());
        }
    }
}

