/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.AWTException;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.server.corpora.clom.Transcription;
import nl.mpi.util.FileExtension;

public class ExportImageFromWindowCommand
implements Command {
    static final Logger LOG = Logger.getLogger(ExportImageFromWindowCommand.class.getName());
    private String commandName;

    public ExportImageFromWindowCommand(String theName) {
        this.commandName = theName;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        Transcription transcription = (Transcription)arguments[0];
        JFrame frame = ELANCommandFactory.getRootFrame(transcription);
        FileChooser chooser = new FileChooser(frame);
        chooser.createAndShowFileDialog(null, 1, FileExtension.IMAGE_EXT, "MediaDir");
        File saveFile = chooser.getSelectedFile();
        String imageIOType = "jpg";
        if (saveFile != null) {
            Object fileName = saveFile.getAbsolutePath();
            String lowerFileName = ((String)fileName).toLowerCase();
            if (lowerFileName.endsWith("png")) {
                imageIOType = "png";
            } else if (lowerFileName.endsWith("bmp")) {
                imageIOType = "bmp";
            } else if (!lowerFileName.endsWith("jpg") && !lowerFileName.endsWith("jpeg")) {
                fileName = (String)fileName + ".jpg";
            }
            File newSaveFile = new File((String)fileName);
            new CaptureThread(frame, imageIOType, newSaveFile).start();
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    class CaptureThread
    extends Thread {
        private JFrame frame;
        private String imageType;
        private File saveFile;

        CaptureThread(JFrame frame, String imageType, File saveFile) {
            this.frame = frame;
            this.imageType = imageType;
            this.saveFile = saveFile;
        }

        @Override
        public void run() {
            try {
                try {
                    Thread.sleep(200L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Robot robot = new Robot();
                BufferedImage image = robot.createScreenCapture(this.frame.getBounds());
                ImageIO.write((RenderedImage)image, this.imageType, this.saveFile);
            }
            catch (AWTException ae) {
                LOG.warning("Could not capture an image of the screen: " + ae.getMessage());
            }
            catch (IOException ioe) {
                LOG.warning("Could not save the screen capture image: " + ioe.getMessage());
            }
        }
    }
}

