/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.Map;
import java.util.logging.Level;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.imports.MergeUtil;
import mpi.eudico.client.annotator.imports.UndoableTranscriptionMerger;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.DecoderInfo;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class ImportDelimitedTextCommand
implements UndoableCommand {
    protected String name;
    protected TranscriptionImpl transcription;
    protected UndoableTranscriptionMerger transMerger = null;

    public ImportDelimitedTextCommand(String commandName) {
        this.name = commandName;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        block6: {
            this.transcription = (TranscriptionImpl)receiver;
            DecoderInfo decInfo = null;
            if (arguments.length > 0 && arguments[0] instanceof DecoderInfo) {
                decInfo = (DecoderInfo)arguments[0];
            }
            if (decInfo == null) {
                if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                    ClientLogger.LOG.warning("No source file and decoder information provided");
                }
                return;
            }
            try {
                TranscriptionImpl impTrans = new TranscriptionImpl(decInfo.getSourceFilePath(), decInfo);
                if (!impTrans.getTiers().isEmpty()) {
                    MergeUtil mergeUtil = new MergeUtil();
                    Map<String, String> renamedTiers = mergeUtil.getRenamingTierMap(impTrans, this.transcription, null);
                    mergeUtil.renameTiersWithTierMap(impTrans, renamedTiers);
                    this.transMerger = new UndoableTranscriptionMerger();
                    this.transMerger.mergeWith(this.transcription, impTrans, true);
                }
            }
            catch (Throwable t) {
                if (!ClientLogger.LOG.isLoggable(Level.WARNING)) break block6;
                ClientLogger.LOG.warning("Error while importing text: " + t.getMessage());
            }
        }
    }

    @Override
    public void undo() {
        if (this.transMerger != null) {
            this.transMerger.undo();
        }
    }

    @Override
    public void redo() {
        if (this.transMerger != null) {
            this.transMerger.redo();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }
}

