/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.gui.ImportCSVDialog;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.delimitedtext.DelimitedTextDecoderInfo;
import nl.mpi.util.FileExtension;

public class ImportDelimitedTextDlgCommand
implements Command {
    private String commandName;

    public ImportDelimitedTextDlgCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        TranscriptionImpl trans = (TranscriptionImpl)receiver;
        FileChooser chooser = new FileChooser(ELANCommandFactory.getRootFrame(trans));
        ArrayList<String[]> extensionList = new ArrayList<String[]>();
        extensionList.add(FileExtension.CSV_EXT);
        chooser.createAndShowFileDialog(ElanLocale.getString("Frame.ElanFrame.OpenDialog.Title"), 0, null, extensionList, FileExtension.CSV_EXT, true, "LastUsedCSVDir", 0, null);
        File csvFile = chooser.getSelectedFile();
        String fullPath = null;
        if (csvFile != null) {
            File fileTemp;
            fullPath = chooser.getSelectedFile().getAbsolutePath();
            csvFile = fileTemp = new File(fullPath);
            ImportCSVDialog dialog = new ImportCSVDialog((Frame)ELANCommandFactory.getRootFrame(trans), fileTemp);
            Object value = dialog.showDialog();
            if (value == null || !(value instanceof DelimitedTextDecoderInfo)) {
                return;
            }
            DelimitedTextDecoderInfo decInfo = (DelimitedTextDecoderInfo)value;
            Command com = ELANCommandFactory.createCommand(trans, "Menu.File.Import.Delimited");
            com.execute(trans, new Object[]{decInfo});
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }
}

